/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.main;

import java.util.HashMap;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jp.sourceforge.sos.cytoq.main.AbstractVariable;
import jp.sourceforge.sos.cytoq.main.VariableList;
import jp.sourceforge.sos.cytoq.main.VariableSingle;
import sos.designPattern.command.ICommand;
import sos.io.SOSFileIO;
import sos.pac.IPACAbstraction;
import sos.window.DoubleListModel;
import sos.window.ListComboBoxModel;

public class ModelMain
implements IPACAbstraction,
ICommand {
    private DefaultTableModel modelResultTable = new DefaultTableModel();
    private DoubleListModel<AbstractVariable> modelSelection;
    private ListComboBoxModel modelHeader = new ListComboBoxModel();
    private AbstractVariable itemFileName;
    private static HashMap<String, AbstractVariable> mapVariable = new HashMap();
    private DefaultListModel modelPreset = new DefaultListModel();
    private SOSFileIO fileIO = new SOSFileIO();

    public ModelMain() {
        this.addToMap(new VariableSingle("File"));
        this.add(new VariableSingle("Time"));
        this.add(new VariableSingle("Iteration"));
        this.add(new VariableList("Area"));
        this.modelSelection = new DoubleListModel(this.modelPreset, null);
        this.itemFileName = ModelMain.getItem("File");
        int i = 0;
        while (i < 3) {
            this.modelSelection.selectFromPreset(i);
            ++i;
        }
        this.updateHeader();
    }

    public String toString() {
        return "ModelMain";
    }

    private void addToMap(AbstractVariable item) {
        mapVariable.put(item.toString(), item);
    }

    private void add(AbstractVariable item) {
        this.addToMap(item);
        this.modelPreset.addElement(item);
    }

    private void setHeader() {
        this.modelHeader.clear();
        this.itemFileName.toHeader(this.modelHeader);
        int i = 0;
        while (i < this.modelSelection.getSizeSelection()) {
            this.modelSelection.getSelectionItem(i).toHeader(this.modelHeader);
            ++i;
        }
    }

    public ComboBoxModel getModelHeader() {
        this.setHeader();
        return this.modelHeader;
    }

    public void updateHeader() {
        this.setHeader();
        this.modelResultTable.setColumnIdentifiers(this.modelHeader.toArray());
    }

    DoubleListModel getModel() {
        return this.modelSelection;
    }

    public AbstractVariable getItem(int i) {
        return this.modelSelection.getPresetItem(i);
    }

    TableModel getTableModel() {
        return this.modelResultTable;
    }

    public static AbstractVariable getItem(String arg) {
        return mapVariable.get(arg);
    }

    public VariableSingle getHeader(String name) {
        int index = this.modelResultTable.findColumn(name);
        return (VariableSingle)this.modelHeader.get(index);
    }

    public void execute() {
        Vector<String> result = new Vector<String>();
        this.itemFileName.toResult(result);
        int i = 0;
        while (i < this.modelSelection.getSizeSelection()) {
            this.modelSelection.getSelectionItem(i).toResult(result);
            ++i;
        }
        this.modelResultTable.addRow(result);
    }

    void clear() {
        this.modelResultTable.setRowCount(0);
    }

    void save() {
        String[] result = new String[this.modelResultTable.getRowCount()];
        int i = 0;
        while (i < result.length) {
            StringBuilder builder = new StringBuilder();
            int j = 0;
            while (j < this.modelResultTable.getColumnCount()) {
                builder.append(this.modelResultTable.getValueAt(i, j));
                builder.append(",");
                ++j;
            }
            result[i] = builder.toString();
            ++i;
        }
        this.fileIO.writeStrings(result);
    }
}

