/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.equation;

import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import jp.sourceforge.sos.cytoq.equation.NonVariable;
import jp.sourceforge.sos.cytoq.main.IModel;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import jp.sourceforge.sos.cytoq.main.VariableSingle;
import sos.designPattern.command.ICommand;
import sos.designPattern.observer.ConcreteSubject;
import sos.designPattern.observer.IObserver;
import sos.designPattern.observer.ISubject;
import sos.math.RevertPolish;
import sos.pac.IPACAbstraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEquation
implements IModel,
ISubject<String>,
ICommand {
    private ArrayList<VariableSingle> equationItems = new ArrayList();
    private ConcreteSubject<String> subject = new ConcreteSubject();
    private ModelMain modelMain;
    private DecimalFormat answerFormat = new DecimalFormat();
    private int decimal = 2;
    private String unit = "%";

    @Override
    public void setAbstraction(IPACAbstraction abstraction) {
        this.modelMain = (ModelMain)abstraction;
    }

    void init() {
        this.add("100");
        this.add("*");
        this.equationItems.add(this.getVaribale("Area3"));
        this.add("/");
        this.add("(");
        this.equationItems.add(this.getVaribale("Area2"));
        this.add("+");
        this.equationItems.add(this.getVaribale("Area3"));
        this.add(")");
        this.setEquation();
    }

    private VariableSingle getVaribale(String name) {
        return this.modelMain.getHeader(name);
    }

    private void setEquation() {
        StringBuffer buffer = new StringBuffer("=");
        if (this.equationItems.size() > 0) {
            int i = 0;
            while (i < this.equationItems.size()) {
                buffer.append(this.equationItems.get(i));
                ++i;
            }
        }
        this.subject.inform(buffer.toString());
    }

    void remove() {
        int index = this.equationItems.size() - 1;
        if (index >= 0) {
            this.equationItems.remove(index);
            this.setEquation();
        }
    }

    void clear() {
        this.equationItems.clear();
        this.setEquation();
    }

    void appendVariable(VariableSingle item) {
        this.equationItems.add(item);
        this.setEquation();
    }

    void appendNonVariable(String arg) {
        this.add(arg);
        this.setEquation();
    }

    private void add(String arg) {
        this.equationItems.add(new NonVariable(arg));
    }

    ComboBoxModel getHeader() {
        return this.modelMain.getModelHeader();
    }

    private String getFormattedValue(double value) {
        this.answerFormat.setMaximumFractionDigits(this.decimal);
        return String.valueOf(this.answerFormat.format(value)) + this.unit;
    }

    @Override
    public void addObserver(IObserver<String> observer) {
        this.subject.addObserver(observer);
    }

    @Override
    public void execute() {
        StringBuffer equation = new StringBuffer();
        int i = 0;
        while (i < this.equationItems.size()) {
            equation.append(this.equationItems.get(i).getValue());
            ++i;
        }
        String eq = RevertPolish.convert(equation.toString());
        String result = this.getFormattedValue(RevertPolish.calc(eq));
        this.subject.inform(result);
    }
}

