/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.color;

import java.awt.Color;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.sos.cytoq.color.IPickup;
import jp.sourceforge.sos.cytoq.color.ISort;
import jp.sourceforge.sos.cytoq.color.PickupNull;
import jp.sourceforge.sos.cytoq.color.SortLuminance;
import jp.sourceforge.sos.cytoq.color.SortNull;
import jp.sourceforge.sos.cytoq.main.IModel;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import sos.color.ColorModel;
import sos.color.ColorPanelModel;
import sos.colorspace.SOSColorSpace;
import sos.design.ComboModelStrategy;
import sos.designPattern.observer.IObserver;
import sos.designPattern.observer.ISubject;
import sos.pac.IPACAbstraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelColor
implements IModel,
ISubject<ColorModel> {
    public ColorPanelModel initModel;
    private ComboModelStrategy<IPickup> pickups;
    public ColorPanelModel finalModel;
    private ComboModelStrategy<ISort> finalEnd;
    private SOSColorSpace colorSpace;
    private ModelMain modelMain;
    private SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
    private DefaultComboBoxModel modelColorSpace;
    private DefaultComboBoxModel modelAnimationColor;
    private ColorPanelModel animationColor;

    public ModelColor() {
        this.initModel = new ColorPanelModel();
        this.initModel.setName("Initial");
        this.finalModel = new ColorPanelModel();
        this.finalModel.setName("Final");
        this.initModel.addObserver(this.finalModel);
        this.setInitStart();
        this.setFinalEnd();
        this.spinnerNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ModelColor.this.initModel.setColorNumber((Integer)ModelColor.this.spinnerNumberModel.getValue());
                ModelColor.this.modelMain.updateHeader();
            }
        });
    }

    private void setFinalEnd() {
        this.finalEnd = new ComboModelStrategy();
        this.finalEnd.add(new SortNull());
        this.finalEnd.add(new SortLuminance());
    }

    @Override
    public void setAbstraction(IPACAbstraction abstraction) {
        this.modelMain = (ModelMain)abstraction;
    }

    ColorPanelModel getModelInit() {
        return this.initModel;
    }

    public void setInitColor() {
        int[] color = this.pickups.getSelected().getColor();
        if (color.length > 0) {
            this.spinnerNumberModel.setValue(color.length);
            this.initModel.updateColor(color);
        }
    }

    public void addToPickups(IPickup pickup, int index) {
        this.pickups.insertElementAt(pickup, index);
    }

    private void setInitStart() {
        this.pickups = new ComboModelStrategy();
        PickupNull nullPickup = new PickupNull();
        this.pickups.add(nullPickup);
    }

    @Override
    public void addObserver(IObserver<ColorModel> observer) {
        this.initModel.addObserver(observer);
    }

    public int getColorNumber() {
        return this.initModel.getColorNumber();
    }

    ColorPanelModel getModelFinal() {
        return this.finalModel;
    }

    ComboBoxModel getFinalEnd() {
        return this.finalEnd;
    }

    void setInitColorFromFinal() {
        this.initModel.updateColor(this.finalModel.getColor());
    }

    public int[] setFinalColorOrder() {
        return this.finalEnd.getSelected().sort(this.initModel, this.finalModel);
    }

    public Color[] getFinalColor() {
        return this.finalModel.getColor();
    }

    public double[][] toData() {
        return this.colorSpace.fromRGB(this.initModel.getColorArray());
    }

    public double[][] convertToData(int[] intRGB) {
        this.colorSpace = (SOSColorSpace)this.modelColorSpace.getSelectedItem();
        this.animationColor = (ColorPanelModel)this.modelAnimationColor.getSelectedItem();
        double[][] input = new double[intRGB.length][];
        int[] rgb = new int[3];
        int i = 0;
        while (i < intRGB.length) {
            int value = intRGB[i];
            rgb[0] = value >> 16 & 0xFF;
            rgb[1] = value >> 8 & 0xFF;
            rgb[2] = value >> 0 & 0xFF;
            input[i] = this.colorSpace.fromRGB(rgb);
            ++i;
        }
        return input;
    }

    ComboBoxModel getColorSpaceModel() {
        this.modelColorSpace = new DefaultComboBoxModel();
        this.modelColorSpace.addElement(SOSColorSpace.getCIELabSpace());
        this.modelColorSpace.addElement(SOSColorSpace.getRGBSpace());
        return this.modelColorSpace;
    }

    ComboBoxModel getPickups() {
        return this.pickups;
    }

    SpinnerModel getSpinnerNumberModel() {
        return this.spinnerNumberModel;
    }

    public DefaultComboBoxModel getColorModels() {
        this.modelAnimationColor = new DefaultComboBoxModel();
        this.modelAnimationColor.addElement(this.initModel);
        this.modelAnimationColor.addElement(this.finalModel);
        return this.modelAnimationColor;
    }

    public void setSelected(IPickup pickup) {
        this.pickups.setSelectedItem(pickup);
    }

    public void update(double[][] means) {
        int[][] newColor = this.colorSpace.toRGB(means);
        this.finalModel.updateColor(newColor);
    }

    public int[] getAnimationColor() {
        return this.animationColor.getColorInt();
    }
}

