/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis.process;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.sourceforge.sos.cytoq.analysis.process.ModelProcess;
import sos.designPattern.command.ICommand;
import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

class ViewPanelProcess
extends JPanel
implements IPACPresentation,
ICommand {
    private ModelProcess model;
    private JComboBox jComboBox = null;
    private JButton jButton = null;

    ViewPanelProcess() {
        this.initialize();
    }

    private void initialize() {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.setColumns(1);
        gridLayout1.setRows(2);
        this.setBorder(BorderFactory.createTitledBorder(null, "Process", 0, 0, new Font("Dialog", 1, 12), Color.blue));
        this.setSize(new Dimension(82, 78));
        this.setLayout(gridLayout1);
        this.add(this.getJComboBox());
        this.add((Component)this.getJButton(), null);
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
        }
        return this.jComboBox;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setForeground(new Color(102, 102, 255));
            this.jButton.setText("START");
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ViewPanelProcess.this.model.isStarted()) {
                        ViewPanelProcess.this.jButton.setText(ViewPanelProcess.this.model.setThreadSuspended());
                    } else {
                        ViewPanelProcess.this.pack();
                        if (ViewPanelProcess.this.model.start()) {
                            ViewPanelProcess.this.jButton.setText("SUSPEND");
                        }
                    }
                }
            });
        }
        return this.jButton;
    }

    private void pack() {
        SwingUtilities.getWindowAncestor(this).pack();
    }

    public void setAbstraction(IPACAbstraction abstraction) {
        this.model = (ModelProcess)abstraction;
        this.model.addCommand(this);
        this.jComboBox.setModel(this.model.getModelProcess());
        this.jComboBox.setSelectedIndex(0);
    }

    public void execute() {
        this.jButton.setText("START");
    }
}

