/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis.process;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.sos.cytoq.analysis.process.ModelProcess;
import jp.sourceforge.sos.cytoq.analysis.process.ProcessBatch;
import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

class ViewPanelOptionProcess
extends JPanel
implements IPACPresentation {
    private ModelProcess model = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JSpinner jSpinnerBatchIteration = null;
    private JSpinner jSpinnerEPS = null;
    private JSpinner jSpinnerMaxIteration = null;

    ViewPanelOptionProcess() {
        this.initialize();
    }

    private void initSpinner(JSpinner spinner, int value, int min, int max) {
        SpinnerNumberModel model = new SpinnerNumberModel(min, min, max, 1);
        spinner.setModel(model);
        spinner.setValue(value);
    }

    private void initialize() {
        this.setBorder(BorderFactory.createTitledBorder(null, "Process", 0, 0, null, Color.blue));
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(3);
        gridLayout.setColumns(2);
        this.jLabel2 = new JLabel();
        this.jLabel2.setText("max iteration: ");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("EPS(decimal): ");
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel = new JLabel();
        this.jLabel.setText("batch iteration: ");
        this.jLabel.setHorizontalAlignment(4);
        this.setLayout(gridLayout);
        this.add((Component)this.jLabel, null);
        this.add((Component)this.getJSpinnerBatchIteration(), null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.getJSpinnerEPS(), null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.getJSpinnerMaxIteration(), null);
    }

    private JSpinner getJSpinnerBatchIteration() {
        if (this.jSpinnerBatchIteration == null) {
            this.jSpinnerBatchIteration = new JSpinner();
            this.jSpinnerBatchIteration.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int value;
                    ProcessBatch.iteration = value = ((Integer)ViewPanelOptionProcess.this.jSpinnerBatchIteration.getValue()).intValue();
                }
            });
        }
        return this.jSpinnerBatchIteration;
    }

    private JSpinner getJSpinnerEPS() {
        if (this.jSpinnerEPS == null) {
            this.jSpinnerEPS = new JSpinner();
            this.jSpinnerEPS.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    double value = Math.pow(0.1, ((Integer)ViewPanelOptionProcess.this.jSpinnerEPS.getValue()).intValue());
                    ViewPanelOptionProcess.this.model.setEPS(value);
                }
            });
        }
        return this.jSpinnerEPS;
    }

    private JSpinner getJSpinnerMaxIteration() {
        if (this.jSpinnerMaxIteration == null) {
            this.jSpinnerMaxIteration = new JSpinner();
            this.jSpinnerMaxIteration.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ViewPanelOptionProcess.this.model.setMaxIteration((Integer)ViewPanelOptionProcess.this.jSpinnerMaxIteration.getValue());
                }
            });
        }
        return this.jSpinnerMaxIteration;
    }

    public void setAbstraction(IPACAbstraction abstraction) {
        this.model = (ModelProcess)abstraction;
        this.initSpinner(this.jSpinnerBatchIteration, 1, 1, 1000);
        this.initSpinner(this.jSpinnerEPS, 7, 0, 16);
        this.initSpinner(this.jSpinnerMaxIteration, 1000, 1, Integer.MAX_VALUE);
    }
}

