/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis.process;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import jp.sourceforge.sos.cytoq.analysis.ModelAnalysis;
import jp.sourceforge.sos.cytoq.analysis.process.IProcess;
import sos.io.SOSFileIO;
import sos.io.SOSImageIO;
import sos.window.JProgressDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessBatch
implements IProcess {
    protected static int iteration = 1;
    private String saveDir;
    private Iterator<File> imageIterator;
    private SOSFileIO imageIO = new SOSFileIO();
    private ModelAnalysis modelAnalysis;
    private ArrayList<File> list = new ArrayList();

    public ProcessBatch(ModelAnalysis mode) {
        this.modelAnalysis = mode;
    }

    public String toString() {
        return "Batch";
    }

    @Override
    public boolean init() {
        File dir = this.imageIO.getOpenDirectory();
        if (dir == null) {
            return false;
        }
        this.saveDir = this.imageIO.getSaveDirectory().getPath();
        if (this.saveDir == null) {
            return false;
        }
        this.imageIterator = this.getIterator(dir);
        this.modelAnalysis.initFile(this.imageIterator.next());
        return true;
    }

    private Iterator<File> getIterator(File dir) {
        Object[] fileList = dir.listFiles();
        Arrays.sort(fileList);
        this.list.clear();
        JProgressDialog dialog = new JProgressDialog(null);
        dialog.start("Loading images...", false);
        int i = 0;
        while (i < fileList.length) {
            BufferedImage img = SOSImageIO.readImage((File)fileList[i]);
            if (img != null) {
                this.list.add((File)fileList[i]);
            }
            dialog.setValue(100 * i / fileList.length);
            ++i;
        }
        dialog.stop();
        int n = this.list.size();
        int t = 1;
        while (t < iteration) {
            int i2 = 0;
            while (i2 < n) {
                File file = this.list.get(i2);
                this.list.add(file);
                ++i2;
            }
            ++t;
        }
        return this.list.iterator();
    }

    @Override
    public boolean isConvoluted() {
        this.doAfterEachFile();
        if (this.imageIterator.hasNext()) {
            this.modelAnalysis.initFile(this.imageIterator.next());
            return false;
        }
        return true;
    }

    private void doAfterEachFile() {
        if (this.saveDir != null) {
            this.modelAnalysis.saveResultImages(this.saveDir);
        }
    }
}

