/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis.process;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import jp.sourceforge.sos.cytoq.analysis.ModelAnalysis;
import jp.sourceforge.sos.cytoq.analysis.process.IProcess;
import jp.sourceforge.sos.cytoq.analysis.process.ProcessBatch;
import jp.sourceforge.sos.cytoq.analysis.process.ProcessSingle;
import jp.sourceforge.sos.cytoq.main.AbstractVariable;
import jp.sourceforge.sos.cytoq.main.IModel;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import sos.designPattern.command.CommandList;
import sos.designPattern.command.ICommand;
import sos.designPattern.command.IInvoker;
import sos.pac.IPACAbstraction;

public class ModelProcess
implements Runnable,
IModel,
IInvoker {
    private IProcess currentMode;
    private volatile boolean threadSuspended;
    private volatile int iteration;
    private Thread blinker;
    private int interval = 10;
    private int maxIteration;
    private long startTime;
    private DefaultComboBoxModel modelProcess;
    private AbstractVariable itemIteration;
    private AbstractVariable itemRequiredTime;
    private ModelAnalysis modelAnalysis;
    private double eps;
    private CommandList commandList = new CommandList();
    ICommand main;

    public ModelProcess() {
        this.itemIteration = ModelMain.getItem("Iteration");
        this.itemRequiredTime = ModelMain.getItem("Time");
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (true) {
            if (!this.modelAnalysis.isConvoluted() && this.iteration <= this.maxIteration) {
                this.modelAnalysis.doMainProcess();
                ++this.iteration;
                this.sleep(thisThread);
                continue;
            }
            this.updateItems();
            this.modelAnalysis.updateResultData();
            this.main.execute();
            if (this.currentMode.isConvoluted()) break;
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(Thread thisThread) {
        try {
            Thread.sleep(this.interval);
            ModelProcess modelProcess = this;
            synchronized (modelProcess) {
                while (this.threadSuspended && this.blinker == thisThread) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    boolean start() {
        this.currentMode = (IProcess)this.modelProcess.getSelectedItem();
        boolean value = this.currentMode.init();
        if (value) {
            this.init();
            this.blinker.start();
        }
        return value;
    }

    private void init() {
        this.threadSuspended = false;
        this.blinker = new Thread(this);
        this.iteration = 1;
        this.startTime = System.currentTimeMillis();
        this.modelAnalysis.setEPS(this.eps);
    }

    private synchronized void stop() {
        this.commandList.execute();
        this.blinker = null;
        this.notify();
    }

    private void updateItems() {
        this.itemIteration.setValue(new Integer(this.iteration).toString());
        int requiredTime = (int)(System.currentTimeMillis() - this.startTime) / 1000;
        this.itemRequiredTime.setValue(new Integer(requiredTime).toString());
        this.iteration = 0;
        this.startTime = System.currentTimeMillis();
    }

    synchronized String setThreadSuspended() {
        boolean bl = this.threadSuspended = !this.threadSuspended;
        if (!this.threadSuspended) {
            this.notify();
            return "SUSPEND";
        }
        return "RESUME";
    }

    boolean isStarted() {
        return this.blinker != null;
    }

    void setMaxIteration(int max) {
        this.maxIteration = max;
    }

    ComboBoxModel getModelProcess() {
        return this.modelProcess;
    }

    void setEPS(double value) {
        this.eps = value;
    }

    public void setAbstraction(IPACAbstraction abstraction) {
        this.modelAnalysis = (ModelAnalysis)abstraction;
        this.modelProcess = new DefaultComboBoxModel();
        this.modelProcess.addElement(new ProcessSingle(this.modelAnalysis));
        this.modelProcess.addElement(new ProcessBatch(this.modelAnalysis));
    }

    public void setBatchIteration(int value) {
    }

    public void addCommand(ICommand command) {
        this.commandList.add(command);
    }
}

