/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis.imageColor;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import jp.sourceforge.sos.cytoq.analysis.imageColor.AbstractView;
import jp.sourceforge.sos.cytoq.analysis.imageColor.Animation;

class ViewSegmentation
extends AbstractView {
    private Animation animation = new Animation();

    public ViewSegmentation(String frameTitle) {
        super(frameTitle);
    }

    public void init() {
        super.init();
        this.animation.setSize(this.canvas.getWidth(), this.canvas.getHeight());
        this.canvas.setImage(this.createImage(this.animation.getProducer()));
        this.canvas.getImageTransform().setFullSrc();
        this.canvas.repaint();
    }

    public void update(Color[] colors) {
        if (this.isShowing()) {
            this.model.setLabelColors(colors);
            this.model.updateImage(this.animation);
            this.canvas.repaint();
        }
    }

    public void componentResized(ComponentEvent e) {
        this.updateBounds(e);
    }

    public void componentMoved(ComponentEvent e) {
        this.updateBounds(e);
    }

    private void updateBounds(ComponentEvent e) {
        Rectangle bounds = e.getComponent().getBounds();
        this.setLocation(bounds.x + bounds.width, bounds.y);
    }
}

