/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis.imageColor;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import jp.sourceforge.sos.cytoq.analysis.imageColor.AbstractView;
import sos.graphics.PointRect;

class ViewDistribution
extends AbstractView {
    public ViewDistribution(String arg) {
        super(arg);
    }

    public void update(Color[] colors) {
        if (this.isShowing()) {
            int i = 0;
            while (i < this.model.getRectNumber()) {
                PointRect pr = (PointRect)this.canvas.getGraphicObject(i);
                int[] p = this.model.convertRect(i);
                pr.setLocation(p[0], p[1]);
                pr.setRectColor(colors[i]);
                ++i;
            }
            this.canvas.repaint();
        }
    }

    public void componentResized(ComponentEvent e) {
        Rectangle bounds = e.getComponent().getBounds();
        this.setLocation(bounds.x, bounds.y + bounds.height);
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void init() {
        this.model.setLabelColors();
        super.init();
        this.adjustPointRect();
    }

    private void adjustPointRect() {
        int n = this.model.getRectNumber() - this.canvas.getGrahicsObjectsNumber();
        if (n > 0) {
            int i = 0;
            while (i < n) {
                this.addRect();
                ++i;
            }
        } else {
            int i = 0;
            while (i < -n) {
                this.removeRect();
                ++i;
            }
        }
    }

    private void addRect() {
        PointRect pr = new PointRect(0, 0, 10);
        pr.setDrawBounds(true);
        pr.setFillRect(true);
        pr.setBoundsColor(Color.black);
        this.canvas.addGraphicObject(pr);
    }

    private void removeRect() {
        this.canvas.removeGraphicObject(this.canvas.getGrahicsObjectsNumber() - 1);
    }
}

