/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis.imageColor;

import java.awt.Color;
import java.awt.Image;
import java.util.Arrays;
import jp.sourceforge.sos.cytoq.analysis.IView;
import jp.sourceforge.sos.cytoq.analysis.ModelAnalysis;
import jp.sourceforge.sos.cytoq.analysis.imageColor.Animation;
import jp.sourceforge.sos.cytoq.main.IModel;
import sos.image.ImagePixelMediator;
import sos.math.MathMatrix;
import sos.math.MathVector;
import sos.math.Statistics;
import sos.pac.IPACAbstraction;

public class ModelImageColor
implements IModel,
IView {
    private double[][] viewMx = null;
    private double[][] pointLocation = null;
    private int[] colorsForPoints = null;
    private double minX;
    private double minY;
    private double colorWidth;
    private double colorHeight;
    private double rw;
    private double rh;
    private double[][] rectLocation;
    private ModelAnalysis model;

    void setLabelColors(Color[] colors) {
        int[] labels = this.model.getColorLabel();
        int in = 0;
        while (in < labels.length) {
            this.colorsForPoints[in] = colors[labels[in]].getRGB();
            ++in;
        }
    }

    Image getImage(int w, int h) {
        this.rw = (double)(w - 1) / this.colorWidth;
        this.rh = (double)(h - 1) / this.colorHeight;
        int[] pixels = new int[w * h];
        Arrays.fill(pixels, -16777216);
        int in = 0;
        while (in < this.pointLocation.length) {
            int x = (int)(this.rw * this.pointLocation[in][0]);
            int y = (int)(this.rh * this.pointLocation[in][1]);
            pixels[x + y * w] = -16777216 + this.colorsForPoints[in];
            ++in;
        }
        return ImagePixelMediator.convertToImage(pixels, w, h);
    }

    int[] convertRect(int index) {
        double[] p = this.rectLocation[index];
        double x = MathVector.dot(this.viewMx[0], p) - this.minX;
        double y = MathVector.dot(this.viewMx[1], p) - this.minY;
        int[] result = new int[]{(int)(this.rw * x), (int)(this.rh * y)};
        return result;
    }

    int getRectNumber() {
        return this.rectLocation.length;
    }

    public void setAbstraction(IPACAbstraction abstraction) {
        this.model = (ModelAnalysis)abstraction;
        this.model.addViewer(this);
    }

    int getHeight(int width) {
        return (int)((double)width * this.colorHeight / this.colorWidth);
    }

    String getName() {
        return this.model.getFileName();
    }

    void addViewer(IView view) {
        this.model.addViewer(view);
    }

    Color[] getFinalColor() {
        return this.model.getFinalColor();
    }

    public void init() {
        double[][] points = this.model.getInput();
        Statistics stat = new Statistics(points);
        double[][] covMx = stat.getCovariance();
        this.viewMx = new double[covMx.length][covMx.length];
        MathMatrix.eigenJacobi(covMx, this.viewMx);
        this.pointLocation = new double[points.length][2];
        int in = 0;
        while (in < points.length) {
            this.pointLocation[in][0] = MathVector.dot(this.viewMx[0], points[in]);
            this.pointLocation[in][1] = MathVector.dot(this.viewMx[1], points[in]);
            ++in;
        }
        Statistics statLoc = new Statistics(this.pointLocation);
        double[] minPoints = statLoc.getMin();
        this.minX = minPoints[0];
        this.minY = minPoints[1];
        int in2 = 0;
        while (in2 < points.length) {
            double[] dArray = this.pointLocation[in2];
            dArray[0] = dArray[0] - this.minX;
            double[] dArray2 = this.pointLocation[in2];
            dArray2[1] = dArray2[1] - this.minY;
            ++in2;
        }
        double[] maxPoints = statLoc.getMax();
        this.colorWidth = maxPoints[0] - this.minX;
        this.colorHeight = maxPoints[1] - this.minY;
        this.rectLocation = this.model.getUnits();
        this.colorsForPoints = new int[points.length];
    }

    public void update(Color[] obj) {
    }

    public void post() {
    }

    void setLabelColors() {
        int[] colors = this.model.getUsedColor();
        System.arraycopy(colors, 0, this.colorsForPoints, 0, colors.length);
    }

    void updateImage(Animation animation) {
        int w = animation.getWidth();
        int h = animation.getHeight();
        this.rw = (double)(w - 1) / this.colorWidth;
        this.rh = (double)(h - 1) / this.colorHeight;
        int[] pixels = animation.getPixels();
        int in = 0;
        while (in < this.pointLocation.length) {
            int x = (int)(this.rw * this.pointLocation[in][0]);
            int y = (int)(this.rh * this.pointLocation[in][1]);
            pixels[x + y * w] = -16777216 + this.colorsForPoints[in];
            ++in;
        }
        animation.update();
    }
}

