/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis.algorithm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jp.sourceforge.sos.cytoq.analysis.algorithm.ModelAlgorithm;
import jp.sourceforge.sos.cytoq.main.SegmentationAlgorithm;
import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;

class ViewPanelAlgorithm
extends JPanel
implements IPACPresentation {
    private JComboBox jComboBox = null;
    private JPanel jPanelOption;
    private ModelAlgorithm model;

    public ViewPanelAlgorithm() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, "Algorithm", 0, 0, new Font("Dialog", 1, 12), Color.blue));
        this.add((Component)this.getJComboBox(), "North");
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ViewPanelAlgorithm.this.setClusteringOption();
                }
            });
        }
        return this.jComboBox;
    }

    public void setAbstraction(IPACAbstraction abstraction) {
        this.model = (ModelAlgorithm)abstraction;
        this.jComboBox.setModel(this.model.getModel());
        this.setClusteringOption();
    }

    private void setClusteringOption() {
        SegmentationAlgorithm clustering = (SegmentationAlgorithm)this.jComboBox.getSelectedItem();
        if (clustering != null) {
            if (this.jPanelOption != null) {
                this.remove(this.jPanelOption);
            }
            this.jPanelOption = clustering.getOptionPanel();
            this.add((Component)this.jPanelOption, "Center");
            this.model.update();
        }
    }
}

