/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis.algorithm;

import java.io.File;
import javax.swing.DefaultComboBoxModel;
import jp.sourceforge.sos.cytoq.analysis.ModelAnalysis;
import jp.sourceforge.sos.cytoq.main.IModel;
import jp.sourceforge.sos.cytoq.main.SegmentationAlgorithm;
import sos.io.Extension;
import sos.io.PluginClassLoader;
import sos.pac.IPACAbstraction;

public class ModelAlgorithm
implements IModel {
    private ModelAnalysis parent;
    private PluginClassLoader loader;
    private DefaultComboBoxModel plugins = new DefaultComboBoxModel();

    public ModelAlgorithm() {
        File dir = new File(this.setPath());
        System.out.println(dir.getPath());
        this.loader = new PluginClassLoader(dir.getPath());
        File[] fileList = dir.listFiles();
        if (fileList != null) {
            int i = 0;
            while (i < fileList.length) {
                SegmentationAlgorithm algorithm = this.getAlgorithm(fileList[i].getName());
                if (algorithm != null) {
                    this.plugins.addElement(algorithm);
                }
                ++i;
            }
        }
    }

    private String setPath() {
        StringBuffer pathBuffer = new StringBuffer(System.getProperty("user.dir"));
        pathBuffer.append(File.separator);
        pathBuffer.append("plugins");
        pathBuffer.append(File.separator);
        pathBuffer.append("segmentation");
        return pathBuffer.toString();
    }

    private SegmentationAlgorithm getAlgorithm(String algorithmName) {
        if (algorithmName != null) {
            algorithmName = Extension.remove(algorithmName);
            try {
                return (SegmentationAlgorithm)this.loader.loadClass(algorithmName).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    DefaultComboBoxModel getModel() {
        return this.plugins;
    }

    void update() {
        this.parent.setAlgorithm((SegmentationAlgorithm)this.plugins.getSelectedItem());
    }

    public void setAbstraction(IPACAbstraction abstraction) {
        this.parent = (ModelAnalysis)abstraction;
    }
}

