/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import jp.sourceforge.sos.cytoq.analysis.IView;
import jp.sourceforge.sos.cytoq.analysis.ModelAnalysis;
import jp.sourceforge.sos.cytoq.analysis.imageColor.Animation;
import sos.pac.IPACAbstraction;
import sos.pac.IPACPresentation;
import sos.window.JImageStackFrame;

class ViewFrame
implements IPACPresentation,
ComponentListener,
IView {
    private JImageStackFrame viewer = new JImageStackFrame();
    private ModelAnalysis model;

    ViewFrame() {
    }

    public void componentResized(ComponentEvent e) {
        Rectangle bounds = e.getComponent().getBounds();
        this.viewer.setLocation(bounds.x + bounds.width, bounds.y);
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void setAbstraction(IPACAbstraction abstraction) {
        this.model = (ModelAnalysis)abstraction;
        this.model.addViewer(this);
    }

    public void init() {
        if (this.model.isVisible()) {
            Animation animation = this.model.getAnimation();
            this.viewer.setCanvasSize(this.model.getCanvasWidth(), this.model.getCanvasHeight());
            this.viewer.setTitle("Process (" + this.model.getFileName() + ")");
            this.viewer.setImage(this.viewer.createImage(animation.getProducer()));
        }
        this.viewer.setVisible(this.model.isVisible());
    }

    public void update(Color[] colors) {
        if (this.viewer.isShowing()) {
            this.model.updateAnimation();
            this.viewer.repaint();
        }
    }

    public void post() {
        this.viewer.clearImage();
        int i = 0;
        while (i < this.model.resultImagesNumber()) {
            this.viewer.addImage(this.model.getImage(i));
            ++i;
        }
        if (this.viewer.getImageNumber() > 0) {
            this.viewer.setTitle("Results(" + this.model.getFileName() + ")");
            this.viewer.setVisible(true);
        }
    }
}

