/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.analysis;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import jp.sourceforge.sos.cytoq.analysis.AbstractViewImage;
import jp.sourceforge.sos.cytoq.analysis.ColorPanelImage;
import jp.sourceforge.sos.cytoq.analysis.IView;
import jp.sourceforge.sos.cytoq.analysis.OriginalImage;
import jp.sourceforge.sos.cytoq.analysis.imageColor.Animation;
import jp.sourceforge.sos.cytoq.color.ModelColor;
import jp.sourceforge.sos.cytoq.color.PickupRandom;
import jp.sourceforge.sos.cytoq.main.AbstractVariable;
import jp.sourceforge.sos.cytoq.main.IModel;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import jp.sourceforge.sos.cytoq.main.SegmentationAlgorithm;
import jp.sourceforge.sos.cytoq.main.VariableList;
import sos.color.ColorModel;
import sos.designPattern.observer.ConcreteSubject;
import sos.designPattern.observer.IObserver;
import sos.designPattern.observer.ISubject;
import sos.image.ImageInfo;
import sos.io.Extension;
import sos.io.SOSImageIO;
import sos.pac.IPACAbstraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelAnalysis
implements IModel,
IObserver<ColorModel>,
ISubject<Color[]> {
    AbstractViewImage[] resultImages = new AbstractViewImage[3];
    private ImageInfo imageInfo = new ImageInfo();
    private ModelColor modelColor;
    private SegmentationAlgorithm algorithm;
    private AbstractVariable itemArea;
    private AbstractVariable itemName;
    private ConcreteSubject<Color[]> subject = new ConcreteSubject();
    private ArrayList<IView> viewers = new ArrayList();
    private double[][] input;
    private SpinnerModel magnificationModel;
    private boolean visible;
    private Animation animation = new Animation();

    public ModelAnalysis() {
        this.itemArea = ModelMain.getItem("Area");
        this.itemName = ModelMain.getItem("File");
        this.magnificationModel = new SpinnerNumberModel(1.0, 0.1, 2.0, 0.1);
    }

    public void saveResultImages(String dir) {
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        String savingName = Extension.replace(this.imageInfo.getName(), "png");
        int i = 0;
        while (i < this.resultImages.length) {
            if (this.resultImages[i].isVisible()) {
                String path = String.valueOf(dir) + this.resultImages[i].toString() + savingName;
                File file = new File(path);
                BufferedImage img = (BufferedImage)this.resultImages[i].createImage(this.imageInfo);
                SOSImageIO.writeImage(file, SOSImageIO.TYPE_PNG, img);
            }
            ++i;
        }
    }

    public void showResultImages() {
        for (IView viewer : this.viewers) {
            viewer.post();
        }
    }

    public void setAlgorithm(SegmentationAlgorithm plugin) {
        this.algorithm = plugin;
    }

    public void initFile(File file) {
        this.imageInfo.setFile(file);
        this.itemName.setValue(this.imageInfo.getName());
        this.modelColor.setInitColor();
        this.input = this.modelColor.convertToData(this.imageInfo.getIntRGB());
        this.initAlgorithm();
        this.animation.setSize(this.imageInfo.getWidth(), this.imageInfo.getHeight());
        for (IView viewer : this.viewers) {
            viewer.init();
        }
    }

    private void initAlgorithm() {
        this.algorithm.setInput(this.input);
        this.algorithm.setUnit(this.modelColor.toData());
        this.algorithm.setParameters(this.imageInfo);
        this.algorithm.resetEvaluatedValue();
    }

    public void doMainProcess() {
        this.algorithm.calculate();
        this.algorithm.setPixelsLabel(this.imageInfo);
        this.modelColor.update(this.algorithm.getMeanD());
        this.subject.inform(this.modelColor.getFinalColor());
    }

    public boolean isConvoluted() {
        return this.algorithm.isConvoluted();
    }

    public void updateResultData() {
        int[] order = this.modelColor.setFinalColorOrder();
        if (order.length > 0) {
            this.algorithm.sortUnits(order);
        }
        this.itemArea.setValue(this.calculateSegmentedArea());
    }

    private String calculateSegmentedArea() {
        int[] area = new int[this.modelColor.getColorNumber()];
        int[] label = this.imageInfo.getPixelsLabel();
        int i = 0;
        while (i < label.length) {
            if (label[i] >= 0) {
                int n = label[i];
                area[n] = area[n] + 1;
            }
            ++i;
        }
        StringBuilder builder = new StringBuilder();
        int i2 = 0;
        while (i2 < area.length) {
            builder.append(area[i2]);
            builder.append(" ");
            ++i2;
        }
        return builder.toString();
    }

    @Override
    public void setAbstraction(IPACAbstraction abstraction) {
        this.modelColor = (ModelColor)abstraction;
        PickupRandom randomPickup = new PickupRandom();
        randomPickup.setImageInfo(this.imageInfo);
        this.modelColor.addObserver(randomPickup);
        this.modelColor.addToPickups(randomPickup, 2);
        this.resultImages[0] = new OriginalImage("Original");
        this.resultImages[1] = new ColorPanelImage("Initial", this.modelColor.initModel);
        this.resultImages[2] = new ColorPanelImage("Final", this.modelColor.finalModel);
    }

    ComboBoxModel getColorModels() {
        return this.modelColor.getColorModels();
    }

    @Override
    public void update(ColorModel obj) {
        VariableList list = (VariableList)this.itemArea;
        if (obj == null) {
            list.remove();
        } else {
            list.add();
        }
    }

    @Override
    public void addObserver(IObserver<Color[]> observer) {
        this.subject.addObserver(observer);
    }

    public void addViewer(IView viewer) {
        this.subject.addObserver(viewer);
        this.viewers.add(viewer);
    }

    int resultImagesNumber() {
        return this.resultImages.length;
    }

    Image getImage(int i) {
        return this.resultImages[i].createImage(this.imageInfo);
    }

    public Color[] getFinalColor() {
        return this.modelColor.getFinalColor();
    }

    public int[] getColorLabel() {
        return this.algorithm.getCluster();
    }

    public double[][] getInput() {
        return this.input;
    }

    public String getFileName() {
        return this.imageInfo.getName();
    }

    public double[][] getUnits() {
        return this.algorithm.getMeanD();
    }

    public int getCanvasWidth() {
        return (int)((double)this.imageInfo.getWidth() * (Double)this.magnificationModel.getValue());
    }

    public int getCanvasHeight() {
        return (int)((double)this.imageInfo.getHeight() * (Double)this.magnificationModel.getValue());
    }

    public void setEPS(double value) {
        this.algorithm.setDesiredValue(value);
    }

    public int[] getUsedColor() {
        return this.imageInfo.getIntRGB();
    }

    public SpinnerModel getMagnificationModel() {
        return this.magnificationModel;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void updateAnimation() {
        int[] colorInts = this.modelColor.getAnimationColor();
        int[] pixels = this.animation.getPixels();
        int[] labels = this.imageInfo.getPixelsLabel();
        int pn = 0;
        while (pn < pixels.length) {
            pixels[pn] = labels[pn] >= 0 ? colorInts[labels[pn]] : 0;
            ++pn;
        }
        this.animation.update();
    }

    public Animation getAnimation() {
        return this.animation;
    }
}

