
import cytoq.AnalyzePluginGUI;
import sos.image.ImageInfo;
import sos.panel.JGenericPanel;
import sos.math.Clustering;
import sos.math.MathVector;
import sos.util.Sets;

/**
 * The abstract class for clastering algorithms.
 * @author Scientific Open Source projects (Gaku Tanaka)
 */
public class KMeans extends Clustering implements AnalyzePluginGUI{
	
	private int[] histogram;
	
	public KMeans(){
		JGenericPanel panel = new JGenericPanel();
		panel.addChoice("sampling", new String[]{"full color", "all pixels"}, 0);
		optionPanel = panel;
	}
	
	protected final void doHCM(){
		int m;
		for (int in=0; in<nInput; in++){
			m = Sets.findNearest(getMeanD(),inputD[in]);
			MathVector.add(units[m].cumInput,inputD[in]);
			units[m].nBelong++;
			cluster[in] = m;
		}
	}
	
	protected final void doHistogramHCM(){
		int m;
		for (int in=0; in<nInput; in++){
			m = Sets.findNearest(getMeanD(),inputD[in]);
			for (int d=0; d<dim; d++){
				units[m].cumInput[d] += inputD[in][d]*histogram[in];
			}
			units[m].nBelong += histogram[in];
			cluster[in] = m;
		}
	}
	
	protected final void calculate(boolean saveUnit){
		initCalculation();
		
		if (histogram==null){
			doHCM();
		}else{
			doHistogramHCM();
		}
		
		calcMean(saveUnit);
	}
	
	public void calculate() {
		calculate(true);
	}
	
	public boolean isConvoluted() {
		return (evaluatedValue<desiredValue)?true:false;
	}
	
	public void setParameters(ImageInfo imi) {
		int index = ((JGenericPanel)optionPanel).getChoiceIndex(0);
		if (index==0){
			histogram = imi.getHistogram();
		}else{
			histogram = null;
		}
	}

	public void setPixelsLabel(ImageInfo imi) {
		imi.setPixelsLabel(cluster);
	}
	
}