package cytoq;

import java.awt.Image;
import java.util.Arrays;
import sos.image.ImagePixelMediator;
import sos.math.MathMatrix;
import sos.math.MathVector;
import sos.math.Statistics;
/*
 * PointsToImage.java
 *
 * Created on 2004/08/02, 0:17
 */

/**
 *
 * @author  Administrator
 */
public class PointsToImage {
	private double[][] points = null;
	private double[][] viewMx = null;
	private double[][] location = null;
	private int[] colorsForPoints = null;
	private double minX, minY;
	private double colorWidth, colorHeight;
	private double rw, rh;
	
	/** Creates a new instance of PointsToImage */
	public PointsToImage (double[][] points) {
		this.points = points;
		Statistics stat = new Statistics(points);
		double[][] covMx = stat.getCovariance ();
		viewMx = new double[covMx.length][covMx.length];
		MathMatrix.eigenJacobi(covMx,viewMx);
		
        // Convert to the 2D feature space
		location = new double[points.length][2];
		for (int in=0; in<points.length; in++){
			location[in][0] = MathVector.dot(viewMx[0],points[in]);
			location[in][1] = MathVector.dot(viewMx[1],points[in]);
		}
		// find min and max in the feature space
		Statistics statLoc = new Statistics(location);
		double[] minPoints = statLoc.getMin();
		minX = minPoints[0];
		minY = minPoints[1];
		for (int in=0; in<points.length; in++){
			location[in][0] -= minX;
			location[in][1] -= minY;
		}
		//Calculate the size of the feature space
		double[] maxPoints = statLoc.getMax();
		colorWidth = maxPoints[0]-minX;
		colorHeight = maxPoints[1]-minY;
	}
	
	public final int getHeight(int width){
		int result = (int)((colorHeight*(width-1.0))/colorWidth);
		return result;
	}
	
	public final void setColors(int[] colors){
		checkNumbers(colors.length);
		colorsForPoints = colors;
	}
	
	public final void setColors(int[] colorIndex, int[] colors){
		checkNumbers(colorIndex.length);
		colorsForPoints = new int[colorIndex.length];
		for (int in=0; in<colorIndex.length; in++){
			colorsForPoints[in] = colors[colorIndex[in]];
		}
	}
	
	private final void checkNumbers(int n){
		if (n!=location.length){
			System.out.println("Error: points="+location.length+" and colors="+n);
		}
	}
	
	public final Image getImage(int w, int h){
		rw = (w-1)/colorWidth;
		rh = (h-1)/colorHeight;
		
		int[] pixels = new int[w*h];
		Arrays.fill(pixels,0xff000000);
		int x,y;
		for (int in=0; in<location.length; in++){
			x = (int)(rw*location[in][0]);
			y = (int)(rh*location[in][1]);
			pixels[x+y*w] = (0xff000000)+colorsForPoints[in];
		}
		
		return ImagePixelMediator.convertToImage(pixels, w,h);
	}
	
	public final Image getImage(int w, int h, boolean[] mask){
		rw = (w-1)/colorWidth;
		rh = (h-1)/colorHeight;
		
		int[] pixels = new int[w*h];
		Arrays.fill(pixels,0xff000000);		
		int x,y;
		for (int in=0; in<location.length; in++){
			if (mask[in]){
				x = (int)(rw*location[in][0]);
				y = (int)(rh*location[in][1]);
				pixels[x+y*w] = (0xff000000)+colorsForPoints[in];
			}
		}
		
		return ImagePixelMediator.convertToImage(pixels, w,h);		
	}
	
	public final int[] convert(double[] p){
		double x = MathVector.dot(viewMx[0],p)-minX;
		double y = MathVector.dot(viewMx[1],p)-minY;
		
		int[] result = new int[2];
		result[0] = (int)(rw*x);
		result[1] = (int)(rh*y);
		return result;
	}
	
	public final double[][] convert(double[][] mx){
		double[][] temp = new double[2][mx.length];
		for (int i=0; i<mx.length; i++){
			temp[0][i] = rw*MathVector.dot(viewMx[0],mx[i]);
			temp[1][i] = rh*MathVector.dot(viewMx[1],mx[i]);
		}
		double[][] result = new double[2][2];
		for (int i=0; i<2; i++){
			result[0][i] = rw*MathVector.dot(viewMx[0],temp[i]);
			result[1][i] = rh*MathVector.dot(viewMx[1],temp[i]);			
		}
		
		return result;
	}
}
