/*
 * JDialogAlgebla.java
 *
 * Created on 2005/04/24, 13:18
 */

package cytoq;

/**
 * GUI Equation editor.
 * @author Scientific Open Source projects (Gaku Tanaka, Wataru Masuda)
 */
public class JDialogAlgebla extends javax.swing.JDialog {
	String backupEquation;
	String backupUnit;
	Integer backupDecimal;
	
	/** Creates new form JDialogAlgebla */
	public JDialogAlgebla(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
		jSpinnerDecimal.setValue(new Integer(2));
	}
	
	public String getEquation(){
		return jTextEquation.getText();
	}
	
	public int getDecimalPlace(){
		return (Integer)jSpinnerDecimal.getValue();
	}
	
	public String getUnit(){
		return jTextUnit.getText();
	}
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jButtonAlgeblaOK = new javax.swing.JButton();
        jButtonAlgeblaCancel = new javax.swing.JButton();
        jTextEquation = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jTextUnit = new javax.swing.JTextField();
        jSpinnerDecimal = new javax.swing.JSpinner();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Equation Editor");
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });

        jButtonAlgeblaOK.setText("OK");
        jButtonAlgeblaOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAlgeblaOKActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(jButtonAlgeblaOK, gridBagConstraints);

        jButtonAlgeblaCancel.setText("CANCEL");
        jButtonAlgeblaCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAlgeblaCancelActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(jButtonAlgeblaCancel, gridBagConstraints);

        jTextEquation.setText("100*v3/(v2+v3)");
        jTextEquation.setMinimumSize(new java.awt.Dimension(480, 22));
        jTextEquation.setPreferredSize(new java.awt.Dimension(480, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(jTextEquation, gridBagConstraints);

        jLabel1.setForeground(new java.awt.Color(0, 0, 255));
        jLabel1.setText("EQUATION");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 3);
        getContentPane().add(jLabel1, gridBagConstraints);

        jLabel2.setForeground(new java.awt.Color(0, 0, 255));
        jLabel2.setText("UNIT");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 3);
        getContentPane().add(jLabel2, gridBagConstraints);

        jLabel3.setForeground(new java.awt.Color(0, 0, 255));
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel3.setText("DECIMAL PLACE");
        jLabel3.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 3);
        getContentPane().add(jLabel3, gridBagConstraints);

        jTextUnit.setText("%");
        jTextUnit.setMinimumSize(new java.awt.Dimension(50, 22));
        jTextUnit.setPreferredSize(new java.awt.Dimension(50, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        getContentPane().add(jTextUnit, gridBagConstraints);

        jSpinnerDecimal.setPreferredSize(new java.awt.Dimension(50, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jSpinnerDecimal, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
	
	private void jButtonAlgeblaCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAlgeblaCancelActionPerformed
		jTextEquation.setText(backupEquation);
		jTextUnit.setText(backupUnit);
		jSpinnerDecimal.setValue(backupDecimal);
		setVisible(false);
	}//GEN-LAST:event_jButtonAlgeblaCancelActionPerformed
	
	private void formComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentShown
		backupEquation = jTextEquation.getText();
		backupUnit= jTextUnit.getText();
		backupDecimal= (Integer)jSpinnerDecimal.getValue();
	}//GEN-LAST:event_formComponentShown
	
	private void jButtonAlgeblaOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAlgeblaOKActionPerformed
		setVisible(false);
	}//GEN-LAST:event_jButtonAlgeblaOKActionPerformed
	
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAlgeblaCancel;
    private javax.swing.JButton jButtonAlgeblaOK;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JSpinner jSpinnerDecimal;
    private javax.swing.JTextField jTextEquation;
    private javax.swing.JTextField jTextUnit;
    // ϐ錾̏I//GEN-END:variables
	
}
