/*
 * ComboFile.java
 *
 * Created on 2004/01/03, 16:44
 */
package cytoq;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;
import sos.io.SOSFileIO;
import sos.util.ColorVector;

/**
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2004/01/03)
 */
public class JComboColorSets extends JComboBox {
	public boolean loaded = false;
	
	private SOSFileIO fileIO = new SOSFileIO();
	private File dataFile;
	private ArrayList<int[][]> RGBSet = new ArrayList<int[][]>();
	
	public JComboColorSets() {
	}
	
	public void clear(){
		super.removeAllItems();
		RGBSet.clear();
	}
	
	public final void removeItemAt(int index){
		super.removeItemAt(index);
		RGBSet.remove(index);
	}
	
	public final void addItem(String name, int[][] data){
		addItem(name);
		RGBSet.add(data);
	}
	
	public final int[][] getSelectedRGB(){
		return RGBSet.get(getSelectedIndex());
	}
	
	public final int[] getSelectedRGBint(){
		return ColorVector.RGBtoInt(getSelectedRGB());
	}
	
	public void setRGB(int[][] data){
		RGBSet.set(getSelectedIndex(), data);
	}
	
	public void setRGB(int index, int[][] data){
		RGBSet.set(index, data);
	}	
	
	public final int[][] getRGB(int index){
		return RGBSet.get(index);
	}
	
	public final void loadItem(String path){

		dataFile = new File(path);
		ArrayList<String> args = fileIO.readStrings(dataFile);
		if (args==null){
			addItem("n3IHC",new int[][]{{255,255,255},{180,190,210},{180,160,160}});
		}else{
			for (int i=0; i<args.size(); i+=2){
				String name = args.get(i);
				String[] data = args.get(i+1).split(" ");
				int[][] currentRGB = new int[data.length][ColorVector.dim];
				for (int j=0; j<data.length; j++){
					String[] rgb = data[j].split(",");
					for (int k=0; k<rgb.length; k++){
						currentRGB[j][k] = Integer.parseInt(rgb[k]);
					}
				}
				addItem(name,currentRGB);
			}
		}
		
		loaded = true;
	}
	
	public final boolean saveItem(){
		String[] args = new String[RGBSet.size()*2];
		int index;
		for (int i=0; i<RGBSet.size(); i++){
			args[i*2] = (String)getItemAt(i);
			index = i*2+1; 
			args[index] = "";
			int[][] data = RGBSet.get(i);
			for (int j=0; j<data.length; j++){
				args[index] += data[j][0];
				for (int k=1; k<data[j].length; k++){
					args[index] += ","+data[j][k];
				}
				args[index] += " ";
			}
		}

		fileIO.writeStrings(dataFile,args);
		return true;
	}
	
	protected ArrayList<int[][]> getRGBSet(){
		return RGBSet;
	}
	
	protected void setRGBSet(ArrayList<int[][]> model){
		RGBSet = model;
	}
	
	public void copy(JComboColorSets another){
		another.setModel(getModel());
		another.setRGBSet(getRGBSet());
	}
	
}
