package cytoq;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import sos.graphics.PointRect;
/*
 * ColorViewer.java
 *
 * Created on 2005/05/10, 1:36
 */

/**
 *
 * @author  Gaku Tanaka
 */
public class ColorSpaceViewer extends javax.swing.JFrame {
	private PointsToImage pointsToImage;
	private PointRect[] pointRects;
	
	/** Creates new form ColorViewer */
	public ColorSpaceViewer() {
		initComponents();
	}
	
	public Dimension getCanvasSize(){
		return canvas.getSize();
	}	
	
	public void setCanvasSize(int width, int height){
		canvas.setSize(width,height);
		pack();
	}
	
	public PointsToImage getPointsToImage(){
		return pointsToImage;
	}
	
	public void setPointsToImage(PointsToImage pti){
		pointsToImage = pti;
		setupCanvasFromPTI();
	}

	public void setPointsToImage(double[][] input, int[] colors){
		pointsToImage = new PointsToImage(input);
		pointsToImage.setColors(colors);
		setupCanvasFromPTI();
	}
	
	private void setupCanvasFromPTI(){
		int h = pointsToImage.getHeight(canvas.getWidth());
		canvas.setSize(canvas.getWidth(),h);
		canvas.setImage(pointsToImage.getImage(canvas.getWidth(),h));
		canvas.getImageTransform().setFullSrc();
		
		pack();		
	}
	
	public void setRectsNumber(int n){
		pointRects = new PointRect[n*2]; // fill and contour
		for (int i=0; i<pointRects.length; i+=2){
			// fill (the color of the vector)
			pointRects[i] = new PointRect(0,0,10);
			pointRects[i].setDrawMode(false);
			canvas.addGraphicObject(pointRects[i]);
			// draw (contour)
			pointRects[i+1] = new PointRect(0,0,10);
			pointRects[i+1].setColor(Color.black);
			pointRects[i+1].setDrawMode(true);
			canvas.addGraphicObject(pointRects[i+1]);
		}
	}
	
	public void drawRects(double[][] rectLocations, Color[] colors){
		if (isShowing()){
			int index;
			for (int i=0; i<rectLocations.length; i++){
				int[] p = pointsToImage.convert(rectLocations[i]);
				index = i*2;
				pointRects[index].setLocation(p[0], p[1]);
				pointRects[index].setColor(colors[i]);
				pointRects[index+1].setLocation(p[0], p[1]);
				/*
				if (jComboAlgorithm.getSelectedIndex()<3){
					double[][] covMx = cl.getMx(i);
					double[][] eig = pti.convert(covMx);
					double[][] mx = new double[2][2];
					MathMx.eigenJacobi (eig,mx);
					MathVector.scale(mx[0],radius*Math.sqrt(eig[0][0]));
					MathVector.scale(mx[1],radius*Math.sqrt(eig[1][1]));
				 
					g.setColor(panelFinal.getColor (i));
					confidenceEllipse.makeOval(pr.getX(),pr.getY(),mx);
					confidenceEllipse.draw (g);
				}	*/
			}
			canvas.update(canvas.getGraphics());
		}
	}
	
	public void drawLabel(int[] colors, int[] labels){
		if (isShowing()){
			pointsToImage.setColors(labels, colors);
			canvas.setImage(pointsToImage.getImage(canvas.getWidth(),canvas.getHeight()));
			canvas.getImageTransform().setFullSrc();
			canvas.repaint();
		}
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        canvas = new sos.canvas.JObjectCanvas();

        getContentPane().add(canvas, java.awt.BorderLayout.CENTER);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private sos.canvas.JObjectCanvas canvas;
    // End of variables declaration//GEN-END:variables
	
}
