/*
 * Decompiled with CFR 0.152.
 */
package cytoq;

import java.awt.Image;
import java.util.Arrays;
import sos.image.ImagePixelMediator;
import sos.math.MathMatrix;
import sos.math.MathVector;
import sos.math.Statistics;

public class PointsToImage {
    private double[][] points = null;
    private double[][] viewMx = null;
    private double[][] location = null;
    private int[] colorsForPoints = null;
    private double minX;
    private double minY;
    private double colorWidth;
    private double colorHeight;
    private double rw;
    private double rh;

    public PointsToImage(double[][] points) {
        this.points = points;
        Statistics stat = new Statistics(points);
        double[][] covMx = stat.getCovariance();
        this.viewMx = new double[covMx.length][covMx.length];
        MathMatrix.eigenJacobi(covMx, this.viewMx);
        this.location = new double[points.length][2];
        for (int in = 0; in < points.length; ++in) {
            this.location[in][0] = MathVector.dot(this.viewMx[0], points[in]);
            this.location[in][1] = MathVector.dot(this.viewMx[1], points[in]);
        }
        Statistics statLoc = new Statistics(this.location);
        double[] minPoints = statLoc.getMin();
        this.minX = minPoints[0];
        this.minY = minPoints[1];
        for (int in = 0; in < points.length; ++in) {
            double[] dArray = this.location[in];
            dArray[0] = dArray[0] - this.minX;
            double[] dArray2 = this.location[in];
            dArray2[1] = dArray2[1] - this.minY;
        }
        double[] maxPoints = statLoc.getMax();
        this.colorWidth = maxPoints[0] - this.minX;
        this.colorHeight = maxPoints[1] - this.minY;
    }

    public final int getHeight(int width) {
        int result = (int)(this.colorHeight * ((double)width - 1.0) / this.colorWidth);
        return result;
    }

    public final void setColors(int[] colors) {
        this.checkNumbers(colors.length);
        this.colorsForPoints = colors;
    }

    public final void setColors(int[] colorIndex, int[] colors) {
        this.checkNumbers(colorIndex.length);
        this.colorsForPoints = new int[colorIndex.length];
        for (int in = 0; in < colorIndex.length; ++in) {
            this.colorsForPoints[in] = colors[colorIndex[in]];
        }
    }

    private final void checkNumbers(int n) {
        if (n != this.location.length) {
            System.out.println("Error: points=" + this.location.length + " and colors=" + n);
        }
    }

    public final Image getImage(int w, int h) {
        this.rw = (double)(w - 1) / this.colorWidth;
        this.rh = (double)(h - 1) / this.colorHeight;
        int[] pixels = new int[w * h];
        Arrays.fill(pixels, -16777216);
        for (int in = 0; in < this.location.length; ++in) {
            int x = (int)(this.rw * this.location[in][0]);
            int y = (int)(this.rh * this.location[in][1]);
            pixels[x + y * w] = -16777216 + this.colorsForPoints[in];
        }
        return ImagePixelMediator.convertToImage(pixels, w, h);
    }

    public final Image getImage(int w, int h, boolean[] mask) {
        this.rw = (double)(w - 1) / this.colorWidth;
        this.rh = (double)(h - 1) / this.colorHeight;
        int[] pixels = new int[w * h];
        Arrays.fill(pixels, -16777216);
        for (int in = 0; in < this.location.length; ++in) {
            if (!mask[in]) continue;
            int x = (int)(this.rw * this.location[in][0]);
            int y = (int)(this.rh * this.location[in][1]);
            pixels[x + y * w] = -16777216 + this.colorsForPoints[in];
        }
        return ImagePixelMediator.convertToImage(pixels, w, h);
    }

    public final int[] convert(double[] p) {
        double x = MathVector.dot(this.viewMx[0], p) - this.minX;
        double y = MathVector.dot(this.viewMx[1], p) - this.minY;
        int[] result = new int[]{(int)(this.rw * x), (int)(this.rh * y)};
        return result;
    }

    public final double[][] convert(double[][] mx) {
        double[][] temp = new double[2][mx.length];
        for (int i = 0; i < mx.length; ++i) {
            temp[0][i] = this.rw * MathVector.dot(this.viewMx[0], mx[i]);
            temp[1][i] = this.rh * MathVector.dot(this.viewMx[1], mx[i]);
        }
        double[][] result = new double[2][2];
        for (int i = 0; i < 2; ++i) {
            result[0][i] = this.rw * MathVector.dot(this.viewMx[0], temp[i]);
            result[1][i] = this.rh * MathVector.dot(this.viewMx[1], temp[i]);
        }
        return result;
    }
}

