/*
 * Decompiled with CFR 0.152.
 */
package cytoq;

import cytoq.AnalyzePluginGUI;
import cytoq.ColorSpaceViewer;
import cytoq.JComboColorSets;
import cytoq.JDialogAlgebla;
import cytoq.PointsToImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sos.canvas.JObjectCanvas;
import sos.graphics.SOSRectangle;
import sos.image.ImageInfo;
import sos.image.ImagePixelMediator;
import sos.io.Extension;
import sos.io.PluginClassLoader;
import sos.io.SOSImageIO;
import sos.math.Clustering;
import sos.math.MathMatrix;
import sos.math.MathVector;
import sos.math.RevertPolish;
import sos.panel.JColorPanel;
import sos.util.ColorVector;
import sos.util.Oval;
import sos.util.Sets;
import sos.util.SortInteger;
import sos.window.JImageFrame;
import sos.window.JImageStack;
import sos.window.JTextFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CytoQViewer
extends JFrame
implements Runnable {
    private static final String[] cpTitle = new String[]{"SOURCE", "INITIAL", "FINAL", "MERGE"};
    private static final String sep = System.getProperty("file.separator");
    private static final String pathColorPresets = System.getProperty("user.dir") + sep + "ColorPresets.dat";
    private static String pathAlgorithm;
    private static Random r;
    private static final ArrayList<String> headerBase;
    private static JTextFrame twResult;
    private int iteration;
    private int maxIteration;
    private int epsDecimal;
    private Image[] imgResult = new Image[cpTitle.length];
    private Vector<String> headings = new Vector();
    private String strStatus;
    private double eps;
    private double betaIncrement;
    private double radius = 2.0;
    private double[][] input;
    private int[] area;
    private Clustering clustering;
    private ImageInfo currentImageInfo = new ImageInfo();
    private JImageStack stackFraction;
    private PointsToImage pti = null;
    private Oval confidenceEllipse = new Oval(24);
    private volatile boolean threadSuspended;
    private long requiredTime;
    private SOSImageIO io = new SOSImageIO();
    private JDialogAlgebla algeblaDialog;
    private DecimalFormat answerFormat = new DecimalFormat();
    private ColorSpaceViewer colorDialog = new ColorSpaceViewer();
    private ColorSpaceViewer segDialog = new ColorSpaceViewer();
    private JImageFrame processFrame = new JImageFrame();
    private SOSRectangle[] rectFraction;
    private JObjectCanvas canvasFractFinal;
    private JButton jButtonAddPreset;
    private JButton jButtonAnalysis;
    private JButton jButtonBreak;
    private JButton jButtonCustomize;
    private JButton jButtonOption;
    private JButton jButtonPresetsNameOK;
    private JButton jButtonRemovePreset;
    private JButton jButtonSave;
    private JButton jButtonToInit;
    private JCheckBox jCheckColor;
    private JCheckBox jCheckProcess;
    private JCheckBox jCheckRandom;
    private JCheckBox jCheckResultFinal;
    private JCheckBox jCheckResultInit;
    private JCheckBox jCheckSeg;
    private JCheckBox jCheckSource;
    private JComboBox jComboAlgorithm;
    private JComboBox jComboAnalysis;
    private JComboBox jComboAnimationColor;
    private JComboBox jComboColorSpace;
    private JComboColorSets jComboPresets;
    private JComboBox jComboSort;
    private JFrame jFrameTextResult;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JLabel jLabelEquation;
    private JLabel jLabelResult;
    private JLabel jLabelStatus;
    private JLabel jLabelUnit;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuSaveImage;
    private JPanel jPanelColor;
    private JPanel jPanelMain;
    private JPanel jPanelOption;
    private JPanel jPanelResult;
    private JSpinner jSpinnerBatchIteration;
    private JSpinner jSpinnerColorNumber;
    private JTextField jTextEPS;
    private JTextField jTextMagnification;
    private JTextField jTextMaxIteration;
    private JTextField jTextPresetsName;
    private JDialog optionDialog;
    private JColorPanel panelFinal;
    private JColorPanel panelInit;
    private JDialog presetsDialog;

    public CytoQViewer() {
        this.initComponents();
        this.algeblaDialog = new JDialogAlgebla((Frame)this, true);
        this.setEquationFromDialog();
        this.loadAlgorithmPlugin();
        this.panelInit.init(true, 3, "Color");
        this.panelFinal.init(false, 3, "Color");
        this.jSpinnerColorNumber.setValue(3);
        this.pack();
        this.setVisible(true);
        this.optionDialog.pack();
        this.optionDialog.setSize(this.optionDialog.getWidth() + 10, this.optionDialog.getHeight() + 10);
        this.colorDialog.setCanvasSize(this.getWidth() * 2 / 3, this.getWidth() / 2);
        this.colorDialog.setVisible(true);
        this.segDialog.setSize(this.colorDialog.getWidth(), this.colorDialog.getHeight());
        twResult.setTitle("Results");
        twResult.setSize(350, 150);
        this.jComboPresets.loadItem(pathColorPresets);
        this.panelInit.updateColor(this.jComboPresets.getSelectedRGB());
        this.jLabelStatus.setText("Welcome to CytoQ !");
    }

    private void loadAlgorithmPlugin() {
        pathAlgorithm = System.getProperty("user.dir");
        pathAlgorithm = pathAlgorithm + sep + "plugins";
        File file = new File(pathAlgorithm);
        File[] fileList = file.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            String algorithmName = Extension.remove(fileList[i].getName());
            this.jComboAlgorithm.addItem(algorithmName);
        }
    }

    @Override
    public void run() {
        this.threadSuspended = false;
        this.stackFraction = null;
        switch (this.jComboAnalysis.getSelectedIndex()) {
            case 0: {
                this.analyzeSingle();
                break;
            }
            case 1: {
                this.analyzeBatch();
                break;
            }
            case 2: {
                this.analyzeEnsemble();
            }
        }
        this.jLabelStatus.setText("The analysis was finished!");
    }

    private void analyzeSingle() {
        File file = this.io.getOpenFile();
        if (file != null) {
            this.showResultWindow("");
            this.currentImageInfo.setName(file.getName());
            this.strStatus = file.getName();
            BufferedImage img = SOSImageIO.readImage(file);
            this.analyzePre(img);
            this.analyzeMain();
            this.analyzePost(img);
            this.jLabelStatus.setText("Showing...");
            if (!(this.jCheckSource.isSelected() || this.jCheckResultInit.isSelected() || this.jCheckResultFinal.isSelected())) {
                return;
            }
            JImageStack stack = new JImageStack();
            stack.setTitle("Result images");
            stack.setCanvasSize(this.currentImageInfo.getWidth(), this.currentImageInfo.getHeight());
            for (int i = 0; i < cpTitle.length; ++i) {
                if (this.imgResult[i] == null) continue;
                stack.addImage(this.imgResult[i]);
            }
            stack.setLocation(this.getWidth(), stack.getY());
            stack.setVisible(true);
        }
    }

    private final void analyzeBatch() {
        int batchMax = (Integer)this.jSpinnerBatchIteration.getValue();
        File file = this.io.getOpenDirectory();
        if (file == null) {
            this.jLabelStatus.setText("The analysis was canceled!");
            return;
        }
        Object[] fileList = file.listFiles();
        Arrays.sort(fileList);
        String saveDir = null;
        if ((this.jCheckSource.isSelected() || this.jCheckResultInit.isSelected() || this.jCheckResultFinal.isSelected()) && (saveDir = this.io.getSaveDirectory().getPath()) == null) {
            this.jLabelStatus.setText("The analysis was canceled!");
            return;
        }
        this.stackFraction.setCanvasSize(this.canvasFractFinal.getWidth(), this.canvasFractFinal.getHeight());
        this.showResultWindow("(" + (String)this.jComboPresets.getSelectedItem() + ")");
        int nImage = 0;
        int[][] sumColor = new int[this.panelInit.getColorNumber()][3];
        int cNumber = -1;
        Object intRGB = null;
        for (int t = 0; t < batchMax; ++t) {
            for (int i = 0; i < fileList.length; ++i) {
                this.currentImageInfo.setName(((File)fileList[i]).getName());
                cNumber = i + t * fileList.length;
                this.strStatus = "(" + (cNumber + 1) + "/" + batchMax * fileList.length + ") " + fileList[i];
                BufferedImage img = SOSImageIO.readImage((File)fileList[i]);
                if (img == null) continue;
                this.analyzePre(img);
                this.analyzeMain();
                this.analyzePost(img);
                if (saveDir != null) {
                    this.jLabelStatus.setText("Saving images...");
                    this.saveResultImages(saveDir, t + 1);
                }
                MathMatrix.add(sumColor, this.panelFinal.getColorArray());
                ++nImage;
            }
        }
        if (this.jCheckRandom.isSelected()) {
            this.panelInit.clearColor();
        }
        MathMatrix.scaleDivide(sumColor, nImage);
        this.panelFinal.updateColor(sumColor);
        this.stackFraction.setVisible(true);
    }

    private final void analyzeEnsemble() {
    }

    private final void showResultWindow(String data) {
        if (!twResult.isVisible()) {
            int i;
            this.headings.clear();
            this.headings.addAll(headerBase);
            for (i = 0; i < this.panelInit.getColorNumber(); ++i) {
                this.headings.add("#" + (i + 1) + "(area)");
            }
            for (i = 0; i < this.panelInit.getColorNumber(); ++i) {
                this.headings.add("#" + (i + 1) + "(color)");
            }
            for (i = 0; i < this.panelInit.getColorNumber(); ++i) {
                this.headings.add("#" + (i + 1) + "(volume)");
            }
            for (i = 0; i < this.panelInit.getColorNumber(); ++i) {
                this.headings.add("\tRGB" + (i + 1));
            }
            twResult.setHeadings(this.headings);
            twResult.setLocation(this.colorDialog.getX(), this.colorDialog.getY() + this.colorDialog.getHeight());
            twResult.setVisible(true);
        }
    }

    private void analyzePre(Image img) {
        this.jLabelStatus.setText(this.strStatus + ": Correcting background...");
        this.currentImageInfo.setImage(img);
        this.currentImageInfo.clearLabel();
        this.jLabelStatus.setText(this.strStatus + ": Extracting colors...");
        int[] pixels = this.currentImageInfo.getPixels();
        this.currentImageInfo.setColor(pixels);
    }

    private void analyzeMain() {
        this.input = this.jComboColorSpace.getSelectedIndex() == 0 ? this.currentImageInfo.getRGB() : this.currentImageInfo.getLAB();
        this.showColorDialogs();
        this.iteration = 0;
        this.area = new int[this.panelFinal.getColorNumber()];
        for (int i = 0; i < cpTitle.length; ++i) {
            this.imgResult[i] = null;
        }
        if (this.jCheckRandom.isSelected()) {
            this.panelInit.setRandomColor(this.currentImageInfo);
        } else {
            this.panelInit.updateColor(this.jComboPresets.getSelectedRGB());
        }
        this.requiredTime = System.currentTimeMillis();
        this.selectAlgorithm();
        this.requiredTime -= System.currentTimeMillis();
        this.jLabelStatus.setText(this.strStatus + ": Sorting colors...");
        switch (this.jComboSort.getSelectedIndex()) {
            case 0: {
                break;
            }
            case 1: {
                int[][] unit = this.panelFinal.getColorArray();
                int[] luminance = new int[this.panelInit.getColorNumber()];
                for (int un = 0; un < this.panelInit.getColorNumber(); ++un) {
                    luminance[un] = ColorVector.RGBtoL(unit[un]);
                }
                SortInteger si = new SortInteger(luminance);
                this.panelFinal.updateColor((int[][])si.sort((Object[])unit));
                this.panelInit.updateColor((int[][])si.sort((Object[])this.panelInit.getColorArray()));
                for (int i = 0; i < luminance.length; ++i) {
                    System.out.println(i + "=" + si.getOrder(i));
                }
                this.clustering.sortUnits(si.getOrder());
                break;
            }
            case 2: {
                this.matchColorSet();
            }
        }
    }

    private final void analyzePost(Image img) {
        if (this.stackFraction != null) {
            this.stackFraction.addImage(this.canvasFractFinal.getScreenImage());
        }
        if (this.currentImageInfo.getPixelsLabel(0) == -1) {
            this.currentImageInfo.setPixelsLabel(this.clustering.getCluster());
        }
        if (this.jCheckSource.isSelected()) {
            this.imgResult[0] = img;
        }
        if (this.jCheckResultInit.isSelected()) {
            this.imgResult[1] = this.jCheckRandom.isSelected() ? this.drawSegmentation(this.jComboPresets.getSelectedRGBint()) : this.drawSegmentation(this.panelInit.getColorInt());
        }
        if (this.jCheckResultFinal.isSelected()) {
            this.imgResult[2] = this.drawSegmentation(this.panelFinal.getColorInt());
        }
        twResult.append(this.makeResultString());
    }

    private void showColorDialogs() {
        if (this.jCheckProcess.isSelected()) {
            double m = Double.parseDouble(this.jTextMagnification.getText());
            int w = (int)((double)this.currentImageInfo.getWidth() * m);
            int h = (int)((double)this.currentImageInfo.getHeight() * m);
            this.processFrame.setCanvasSize(w, h);
            if (!this.processFrame.isVisible()) {
                this.processFrame.setLocation(this.getWidth(), this.getY());
                this.processFrame.setVisible(true);
            }
        }
        this.pti = new PointsToImage(this.input);
        this.pti.setColors(this.currentImageInfo.getIntRGB());
        this.colorDialog.setPointsToImage(this.pti);
        this.colorDialog.setTitle("Distribution map (" + this.currentImageInfo.getName() + ")");
        if (this.segDialog.isShowing()) {
            this.segDialog.setPointsToImage(this.pti);
            this.segDialog.setTitle("Segmentation map (" + this.currentImageInfo.getName() + ")");
            this.segDialog.pack();
        }
    }

    private final double[][] colorToUnit(int[][] data) {
        int un;
        double[][] unit = new double[this.panelFinal.getColorNumber()][3];
        if (this.jComboColorSpace.getSelectedIndex() == 0) {
            for (un = 0; un < this.panelInit.getColorNumber(); ++un) {
                for (int d = 0; d < 3; ++d) {
                    unit[un][d] = data[un][d];
                }
            }
        } else {
            for (un = 0; un < this.panelInit.getColorNumber(); ++un) {
                ColorVector.RGBtoLAB(data[un], unit[un]);
            }
        }
        if (unit.length > this.panelInit.getColorNumber()) {
            int tempNumber = this.panelInit.getColorNumber();
            do {
                int index = tempNumber % this.panelInit.getColorNumber();
                System.arraycopy(unit[index], 0, unit[tempNumber], 0, 3);
            } while (++tempNumber < unit.length);
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAlgorithm() {
        this.clustering.setInput(this.input);
        this.clustering.setUnit(this.colorToUnit(this.panelInit.getColorArray()));
        this.clustering.setParameters(this.currentImageInfo);
        this.epsDecimal = Integer.parseInt(this.jTextEPS.getText());
        this.eps = Math.pow(0.1, this.epsDecimal);
        this.clustering.setDesiredValue(this.eps);
        this.maxIteration = Integer.parseInt(this.jTextMaxIteration.getText());
        do {
            this.clustering.calculate();
            ((AnalyzePluginGUI)((Object)this.clustering)).setPixelsLabel(this.currentImageInfo);
            this.updateComponentsForUnit();
            ++this.iteration;
            try {
                Thread.currentThread();
                Thread.sleep(10L);
                if (!this.threadSuspended) continue;
                CytoQViewer cytoQViewer = this;
                synchronized (cytoQViewer) {
                    while (this.threadSuspended) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (!this.clustering.isConvoluted() && this.iteration < this.maxIteration);
    }

    private final boolean hasUnchangedColor() {
        int[] clusterOfColor = this.clustering.getCluster();
        int[] size = new int[this.panelInit.getColorNumber()];
        for (int pn = 0; pn < clusterOfColor.length; ++pn) {
            int n = clusterOfColor[pn];
            size[n] = size[n] + 1;
        }
        for (int i = 0; i < this.panelInit.getColorNumber(); ++i) {
            if (size[i] != 0) continue;
            return true;
        }
        return false;
    }

    private void updateComponentsForUnit() {
        int[][] newColor = new int[this.panelFinal.getColorNumber()][3];
        switch (this.jComboColorSpace.getSelectedIndex()) {
            case 0: {
                newColor = this.clustering.getMean();
                break;
            }
            case 1: {
                for (int un = 0; un < this.panelFinal.getColorNumber(); ++un) {
                    ColorVector.LABtoRGB(this.clustering.getMeanD(un), newColor[un]);
                }
                break;
            }
        }
        this.panelFinal.updateColor(newColor);
        this.colorDialog.drawRects(this.clustering.getMeanD(), this.panelFinal.getColor());
        this.segDialog.drawLabel(this.clustering.getCluster(), this.panelFinal.getColorInt());
        this.drawFraction();
        if (this.processFrame.isShowing()) {
            int[] color = this.jComboAnimationColor.getSelectedIndex() == 0 ? this.panelInit.getColorInt() : this.panelFinal.getColorInt();
            Image img = this.drawSegmentation(color);
            this.processFrame.setImage(img);
        }
    }

    private final void matchColorSet() {
        double[][] unitD = this.colorToUnit(this.jComboPresets.getSelectedRGB());
        if (unitD.length != this.panelInit.getColorNumber()) {
            this.jLabelStatus.setText("Could NOT sort because of the invalid preset!");
        } else {
            int i;
            int[] order = Sets.match(this.input, this.currentImageInfo.getHistogram(), unitD, this.clustering.getMeanD(), this.clustering.getCluster());
            this.clustering.sortUnits(order);
            int[][] orderedUnit = new int[this.panelInit.getColorNumber()][];
            for (i = 0; i < this.panelInit.getColorNumber(); ++i) {
                orderedUnit[i] = this.panelFinal.getColorArray(order[i]);
            }
            this.panelFinal.updateColor(orderedUnit);
            if (this.jCheckRandom.isSelected()) {
                for (i = 0; i < this.panelInit.getColorNumber(); ++i) {
                    orderedUnit[i] = this.panelInit.getColorArray(order[i]);
                }
                this.panelInit.updateColor(orderedUnit);
            }
        }
    }

    private final void drawFraction() {
        Arrays.fill(this.area, 0);
        if (this.currentImageInfo.getPixelsLabel(0) == -1) {
            int[] histogram = this.currentImageInfo.getHistogram();
            int[] cluster = this.clustering.getCluster();
            for (int i = 0; i < histogram.length; ++i) {
                int n = cluster[i];
                this.area[n] = this.area[n] + histogram[i];
            }
        } else {
            for (int pn = 0; pn < this.currentImageInfo.getImageSize(); ++pn) {
                int n = this.currentImageInfo.getPixelsLabel(pn);
                this.area[n] = this.area[n] + 1;
            }
        }
        int cumX = 1;
        for (int un = 0; un < this.panelFinal.getColorNumber(); ++un) {
            int fract = this.canvasFractFinal.getWidth() * this.area[un] / this.currentImageInfo.getImageSize();
            this.rectFraction[un].setColor(this.panelFinal.getColor(un));
            this.rectFraction[un].setBounds(cumX, 0, fract + 1, this.canvasFractFinal.getHeight());
            cumX += fract;
        }
        this.canvasFractFinal.repaint();
    }

    private final Vector<String> makeResultString() {
        Vector<String> result = new Vector<String>();
        result.add(this.currentImageInfo.getName());
        String equation = this.jLabelEquation.getText();
        double calc = RevertPolish.calc(RevertPolish.convert(equation), this.area);
        result.add(Double.toString(calc));
        this.jLabelResult.setText(this.answerFormat.format(calc));
        result.add(Long.toString(-this.requiredTime / 1000L));
        result.add(Integer.toString(this.iteration));
        result.add(Integer.toString(this.currentImageInfo.getUsedColorNumber()));
        result.add(Double.toString(this.clustering.getEvaluatedValue()));
        for (int un = 0; un < this.area.length; ++un) {
            result.add(Integer.toString(this.area[un]));
        }
        int[] clusterOfColor = this.clustering.getCluster();
        int[] colorSize = new int[this.panelFinal.getColorNumber()];
        for (int in = 0; in < clusterOfColor.length; ++in) {
            int n = clusterOfColor[in];
            colorSize[n] = colorSize[n] + 1;
        }
        for (int un = 0; un < this.panelFinal.getColorNumber(); ++un) {
            result.add(Integer.toString(colorSize[un]));
        }
        double[][][] intraCovMx = MathVector.covariance(this.input, clusterOfColor, this.panelFinal.getColorNumber());
        double[][] w = new double[3][3];
        for (int i = 0; i < this.panelFinal.getColorNumber(); ++i) {
            MathMatrix.eigenJacobi(intraCovMx[i], w);
            double volume = 4.1887902047863905;
            for (int d = 0; d < 3; ++d) {
                volume *= 2.0 * Math.sqrt(intraCovMx[i][d][d]);
            }
            result.add(Double.toString(volume));
        }
        String argColor = this.panelFinal.getColorString(" ");
        String[] strColors = argColor.split(" ");
        for (int i = 0; i < strColors.length; ++i) {
            result.add(strColors[i]);
        }
        return result;
    }

    private final Image drawSegmentation(int[] rgb) {
        int[] pixels = new int[this.currentImageInfo.getImageSize()];
        for (int pn = 0; pn < this.currentImageInfo.getImageSize(); ++pn) {
            pixels[pn] = this.currentImageInfo.getPixelsLabel(pn) >= 0 ? rgb[this.currentImageInfo.getPixelsLabel(pn)] : 0;
        }
        return ImagePixelMediator.convertToImage(pixels, this.currentImageInfo.getWidth(), this.currentImageInfo.getHeight());
    }

    private void saveResultImages(String dir, int t) {
        String savingName = Extension.remove(this.currentImageInfo.getName());
        savingName = savingName + ".png";
        for (int i = 0; i < cpTitle.length; ++i) {
            if (this.imgResult[i] == null) continue;
            this.io.writeImage(SOSImageIO.TYPE_PNG, (BufferedImage)this.imgResult[i]);
        }
    }

    private void setNewColorPanel(int n) {
        this.panelInit.setColorNumber(n);
        this.panelFinal.setColorNumber(n);
        this.pack();
    }

    private void setEquationFromDialog() {
        this.jLabelEquation.setText(this.algeblaDialog.getEquation());
        this.jLabelUnit.setText(this.algeblaDialog.getUnit());
        this.answerFormat.setMaximumFractionDigits(this.algeblaDialog.getDecimalPlace());
    }

    private String getPresetsName() {
        this.presetsDialog.pack();
        this.presetsDialog.setVisible(true);
        return this.jTextPresetsName.getText();
    }

    private void initComponents() {
        this.optionDialog = new JDialog();
        this.jLabel7 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jComboColorSpace = new JComboBox();
        this.jLabel13 = new JLabel();
        this.jTextEPS = new JTextField();
        this.jLabel18 = new JLabel();
        this.jComboSort = new JComboBox();
        this.jLabel12 = new JLabel();
        this.jTextMaxIteration = new JTextField();
        this.jPanelOption = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jSpinnerBatchIteration = new JSpinner();
        this.presetsDialog = new JDialog();
        this.jLabel14 = new JLabel();
        this.jTextPresetsName = new JTextField();
        this.jButtonPresetsNameOK = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuSaveImage = new JMenuItem();
        this.jFrameTextResult = new JFrame();
        this.jPanelMain = new JPanel();
        this.jLabel20 = new JLabel();
        this.jComboAnalysis = new JComboBox();
        this.jLabel21 = new JLabel();
        this.jCheckSource = new JCheckBox();
        this.jCheckResultInit = new JCheckBox();
        this.jCheckResultFinal = new JCheckBox();
        this.jLabel22 = new JLabel();
        this.jCheckColor = new JCheckBox();
        this.jCheckSeg = new JCheckBox();
        this.jButtonOption = new JButton();
        this.jButtonAnalysis = new JButton();
        this.jLabel5 = new JLabel();
        this.jComboAlgorithm = new JComboBox();
        this.jCheckProcess = new JCheckBox();
        this.jLabel26 = new JLabel();
        this.jComboAnimationColor = new JComboBox();
        this.jLabel17 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jTextMagnification = new JTextField();
        this.jButtonBreak = new JButton();
        this.jPanelColor = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonToInit = new JButton();
        this.jCheckRandom = new JCheckBox();
        this.jLabel19 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jButtonRemovePreset = new JButton();
        this.jButtonAddPreset = new JButton();
        this.jSpinnerColorNumber = new JSpinner();
        this.jButtonSave = new JButton();
        this.panelInit = new JColorPanel();
        this.panelFinal = new JColorPanel();
        this.canvasFractFinal = new JObjectCanvas();
        this.jComboPresets = new JComboColorSets();
        this.jPanelResult = new JPanel();
        this.jButtonCustomize = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabelResult = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabelEquation = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabelUnit = new JLabel();
        this.jLabelStatus = new JLabel();
        this.optionDialog.getContentPane().setLayout(new GridBagLayout());
        this.optionDialog.setTitle("Options");
        this.optionDialog.setModal(true);
        this.jLabel7.setForeground(new Color(0, 0, 255));
        this.jLabel7.setText("PREPROCESSING");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.optionDialog.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel9.setForeground(new Color(0, 0, 255));
        this.jLabel9.setText("ALGORITHMs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.optionDialog.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setForeground(new Color(102, 102, 102));
        this.jLabel10.setText("color space: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.optionDialog.getContentPane().add((Component)this.jLabel10, gridBagConstraints);
        this.jComboColorSpace.setModel(new DefaultComboBoxModel<String>(new String[]{"RGB", "CIE L*a*b*"}));
        this.jComboColorSpace.setSelectedIndex(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.optionDialog.getContentPane().add((Component)this.jComboColorSpace, gridBagConstraints);
        this.jLabel13.setForeground(new Color(102, 102, 102));
        this.jLabel13.setText("EPS (decimal): ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.optionDialog.getContentPane().add((Component)this.jLabel13, gridBagConstraints);
        this.jTextEPS.setText("5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.optionDialog.getContentPane().add((Component)this.jTextEPS, gridBagConstraints);
        this.jLabel18.setForeground(new Color(102, 102, 102));
        this.jLabel18.setText("sort: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        this.optionDialog.getContentPane().add((Component)this.jLabel18, gridBagConstraints);
        this.jComboSort.setModel(new DefaultComboBoxModel<String>(new String[]{"nothing", "luminance", "preset"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.optionDialog.getContentPane().add((Component)this.jComboSort, gridBagConstraints);
        this.jLabel12.setForeground(new Color(102, 102, 102));
        this.jLabel12.setText("max iteration: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.optionDialog.getContentPane().add((Component)this.jLabel12, gridBagConstraints);
        this.jTextMaxIteration.setText("500");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.optionDialog.getContentPane().add((Component)this.jTextMaxIteration, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.optionDialog.getContentPane().add((Component)this.jPanelOption, gridBagConstraints);
        this.jLabel4.setForeground(new Color(0, 0, 255));
        this.jLabel4.setText("OPTIONS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.optionDialog.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel11.setForeground(new Color(0, 0, 255));
        this.jLabel11.setText("RESULTS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.optionDialog.getContentPane().add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel25.setForeground(new Color(102, 102, 102));
        this.jLabel25.setText("batch iteration:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.optionDialog.getContentPane().add((Component)this.jLabel25, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.optionDialog.getContentPane().add((Component)this.jSpinnerBatchIteration, gridBagConstraints);
        this.presetsDialog.getContentPane().setLayout(new GridBagLayout());
        this.presetsDialog.setModal(true);
        this.jLabel14.setText("Name: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.presetsDialog.getContentPane().add((Component)this.jLabel14, gridBagConstraints);
        this.jTextPresetsName.setPreferredSize(new Dimension(150, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.presetsDialog.getContentPane().add((Component)this.jTextPresetsName, gridBagConstraints);
        this.jButtonPresetsNameOK.setText("OK");
        this.jButtonPresetsNameOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CytoQViewer.this.jButtonPresetsNameOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.presetsDialog.getContentPane().add((Component)this.jButtonPresetsNameOK, gridBagConstraints);
        this.jMenu1.setText("File");
        this.jMenuSaveImage.setText("Save image");
        this.jMenuSaveImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CytoQViewer.this.jMenuSaveImageActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuSaveImage);
        this.jMenuBar1.add(this.jMenu1);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(3);
        this.setTitle("CytoQ");
        this.setCursor(new Cursor(0));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                CytoQViewer.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CytoQViewer.this.formWindowClosing(evt);
            }
        });
        this.jPanelMain.setLayout(new GridBagLayout());
        this.jPanelMain.setBorder(new TitledBorder("MAIN"));
        this.jLabel20.setText("ANALYSIS");
        this.jLabel20.setForeground(new Color(0, 0, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanelMain.add((Component)this.jLabel20, gridBagConstraints);
        this.jComboAnalysis.setModel(new DefaultComboBoxModel<String>(new String[]{"Single", "Batch"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelMain.add((Component)this.jComboAnalysis, gridBagConstraints);
        this.jLabel21.setText("ANIMATION");
        this.jLabel21.setForeground(new Color(0, 0, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelMain.add((Component)this.jLabel21, gridBagConstraints);
        this.jCheckSource.setText("SOURCE");
        this.jCheckSource.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelMain.add((Component)this.jCheckSource, gridBagConstraints);
        this.jCheckResultInit.setText("Result (INITIAL)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelMain.add((Component)this.jCheckResultInit, gridBagConstraints);
        this.jCheckResultFinal.setText("Result (FINAL)");
        this.jCheckResultFinal.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelMain.add((Component)this.jCheckResultFinal, gridBagConstraints);
        this.jLabel22.setForeground(new Color(0, 0, 255));
        this.jLabel22.setText("COLOR MAPS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelMain.add((Component)this.jLabel22, gridBagConstraints);
        this.jCheckColor.setSelected(true);
        this.jCheckColor.setText("Distribution");
        this.jCheckColor.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CytoQViewer.this.jCheckColorItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelMain.add((Component)this.jCheckColor, gridBagConstraints);
        this.jCheckSeg.setText("Segmentation");
        this.jCheckSeg.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CytoQViewer.this.jCheckSegItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelMain.add((Component)this.jCheckSeg, gridBagConstraints);
        this.jButtonOption.setText("OPTIONS");
        this.jButtonOption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CytoQViewer.this.jButtonOptionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelMain.add((Component)this.jButtonOption, gridBagConstraints);
        this.jButtonAnalysis.setForeground(new Color(255, 0, 0));
        this.jButtonAnalysis.setText("START");
        this.jButtonAnalysis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CytoQViewer.this.jButtonAnalysisActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelMain.add((Component)this.jButtonAnalysis, gridBagConstraints);
        this.jLabel5.setText("ALGORITHM");
        this.jLabel5.setForeground(new Color(0, 0, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanelMain.add((Component)this.jLabel5, gridBagConstraints);
        this.jComboAlgorithm.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CytoQViewer.this.jComboAlgorithmItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelMain.add((Component)this.jComboAlgorithm, gridBagConstraints);
        this.jCheckProcess.setSelected(true);
        this.jCheckProcess.setText("show");
        this.jCheckProcess.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CytoQViewer.this.jCheckProcessItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelMain.add((Component)this.jCheckProcess, gridBagConstraints);
        this.jLabel26.setText("SHOW IMAGES");
        this.jLabel26.setForeground(new Color(0, 0, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelMain.add((Component)this.jLabel26, gridBagConstraints);
        this.jComboAnimationColor.setModel(new DefaultComboBoxModel<String>(new String[]{"INITIAL", "FINAL"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.jPanelMain.add((Component)this.jComboAnimationColor, gridBagConstraints);
        this.jLabel17.setText("magnification: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelMain.add((Component)this.jLabel17, gridBagConstraints);
        this.jLabel27.setText("colors: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelMain.add((Component)this.jLabel27, gridBagConstraints);
        this.jTextMagnification.setText("1.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.jPanelMain.add((Component)this.jTextMagnification, gridBagConstraints);
        this.jButtonBreak.setForeground(new Color(255, 0, 0));
        this.jButtonBreak.setText("SUSPEND");
        this.jButtonBreak.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CytoQViewer.this.jButtonBreakActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelMain.add((Component)this.jButtonBreak, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanelMain, gridBagConstraints);
        this.jPanelColor.setLayout(new GridBagLayout());
        this.jPanelColor.setBorder(new TitledBorder("COLORS"));
        this.jLabel1.setForeground(new Color(0, 0, 255));
        this.jLabel1.setText("INITIAL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanelColor.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setForeground(new Color(0, 0, 255));
        this.jLabel2.setText("FINAL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 2, 0);
        this.jPanelColor.add((Component)this.jLabel2, gridBagConstraints);
        this.jButtonToInit.setText("COPY TO INITIAL");
        this.jButtonToInit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CytoQViewer.this.jButtonToInitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelColor.add((Component)this.jButtonToInit, gridBagConstraints);
        this.jCheckRandom.setText("random colors");
        this.jCheckRandom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CytoQViewer.this.jCheckRandomItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelColor.add((Component)this.jCheckRandom, gridBagConstraints);
        this.jLabel19.setForeground(new Color(0, 0, 255));
        this.jLabel19.setText("PIXELS");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.jPanelColor.add((Component)this.jLabel19, gridBagConstraints);
        this.jLabel15.setText("color number:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanelColor.add((Component)this.jLabel15, gridBagConstraints);
        this.jButtonRemovePreset.setForeground(new Color(0, 0, 255));
        this.jButtonRemovePreset.setText("REMOVE");
        this.jButtonRemovePreset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CytoQViewer.this.jButtonRemovePresetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelColor.add((Component)this.jButtonRemovePreset, gridBagConstraints);
        this.jButtonAddPreset.setForeground(new Color(0, 0, 255));
        this.jButtonAddPreset.setText("ADD");
        this.jButtonAddPreset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CytoQViewer.this.jButtonAddPresetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.jPanelColor.add((Component)this.jButtonAddPreset, gridBagConstraints);
        this.jSpinnerColorNumber.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CytoQViewer.this.jSpinnerColorNumberStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanelColor.add((Component)this.jSpinnerColorNumber, gridBagConstraints);
        this.jButtonSave.setForeground(new Color(0, 0, 255));
        this.jButtonSave.setText("SAVE");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CytoQViewer.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.jPanelColor.add((Component)this.jButtonSave, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanelColor.add((Component)this.panelInit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanelColor.add((Component)this.panelFinal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanelColor.add((Component)this.canvasFractFinal, gridBagConstraints);
        this.jComboPresets.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CytoQViewer.this.jComboPresetsItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelColor.add((Component)this.jComboPresets, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.getContentPane().add((Component)this.jPanelColor, gridBagConstraints);
        this.jPanelResult.setLayout(new GridBagLayout());
        this.jPanelResult.setBorder(new TitledBorder("RESULT"));
        this.jButtonCustomize.setText("CUSTOMIZE");
        this.jButtonCustomize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CytoQViewer.this.jButtonCustomizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelResult.add((Component)this.jButtonCustomize, gridBagConstraints);
        this.jLabel3.setForeground(new Color(0, 0, 255));
        this.jLabel3.setText("EQUATION");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanelResult.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabelResult.setHorizontalAlignment(4);
        this.jLabelResult.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.jPanelResult.add((Component)this.jLabelResult, gridBagConstraints);
        this.jLabel16.setText("=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanelResult.add((Component)this.jLabel16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelResult.add((Component)this.jLabelEquation, gridBagConstraints);
        this.jLabel23.setForeground(new Color(0, 0, 255));
        this.jLabel23.setText("ANSWER");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanelResult.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel24.setText("=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanelResult.add((Component)this.jLabel24, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.jPanelResult.add((Component)this.jLabelUnit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.getContentPane().add((Component)this.jPanelResult, gridBagConstraints);
        this.jLabelStatus.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jLabelStatus, gridBagConstraints);
        this.pack();
    }

    private void jButtonPresetsNameOKActionPerformed(ActionEvent evt) {
        this.presetsDialog.setVisible(false);
    }

    private void jSpinnerColorNumberStateChanged(ChangeEvent evt) {
        int i;
        int newNumber = (Integer)this.jSpinnerColorNumber.getValue();
        int oldNumber = this.panelInit.getColorNumber();
        int difference = Math.abs(newNumber - oldNumber);
        for (i = 0; i < difference; ++i) {
            if (oldNumber < newNumber) {
                this.panelInit.addColor();
                this.panelFinal.addColor();
                continue;
            }
            this.panelInit.removeColor();
            this.panelFinal.removeColor();
        }
        this.pack();
        this.colorDialog.setRectsNumber(newNumber);
        this.canvasFractFinal.clearGraphicObject();
        this.rectFraction = new SOSRectangle[newNumber];
        for (i = 0; i < this.rectFraction.length; ++i) {
            this.rectFraction[i] = new SOSRectangle();
            this.canvasFractFinal.addGraphicObject(this.rectFraction[i]);
        }
    }

    private void jButtonCustomizeActionPerformed(ActionEvent evt) {
        this.algeblaDialog.pack();
        this.algeblaDialog.setVisible(true);
        this.setEquationFromDialog();
    }

    private void jMenuSaveImageActionPerformed(ActionEvent evt) {
    }

    private void jComboAlgorithmItemStateChanged(ItemEvent evt) {
        PluginClassLoader loader = new PluginClassLoader(pathAlgorithm);
        try {
            String algorithmName = (String)this.jComboAlgorithm.getSelectedItem();
            this.clustering = (Clustering)loader.loadClass(algorithmName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.clustering.getOptionPanel() != null) {
            this.optionDialog.getContentPane().remove(this.jPanelOption);
            this.jPanelOption = this.clustering.getOptionPanel();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 10;
            constraints.gridwidth = 2;
            this.optionDialog.getContentPane().add((Component)this.jPanelOption, constraints);
            this.optionDialog.pack();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.colorDialog.setLocation(0, this.getHeight());
        this.segDialog.setLocation(this.getWidth() * 2 / 3, this.getHeight());
    }

    private void jCheckSegItemStateChanged(ItemEvent evt) {
        this.segDialog.setVisible(this.jCheckSeg.isSelected());
    }

    private void jCheckColorItemStateChanged(ItemEvent evt) {
        if (this.jCheckColor.isSelected()) {
            this.colorDialog.setVisible(true);
            this.segDialog.setLocation(this.colorDialog.getWidth(), this.segDialog.getY());
        } else {
            this.colorDialog.setVisible(false);
            this.segDialog.setLocation(0, this.segDialog.getY());
        }
    }

    private void jCheckRandomItemStateChanged(ItemEvent evt) {
        if (this.jCheckRandom.isSelected()) {
            this.jComboPresets.setEnabled(true);
        } else {
            this.jComboPresets.setEnabled(false);
        }
    }

    private void jComboPresetsItemStateChanged(ItemEvent evt) {
        int index = this.jComboPresets.getSelectedIndex();
        if (index > -1 && this.jComboPresets.loaded) {
            int[][] currentColor = this.jComboPresets.getRGB(index);
            this.setNewColorPanel(currentColor.length);
            this.panelInit.updateColor(currentColor);
        }
    }

    private void jCheckProcessItemStateChanged(ItemEvent evt) {
        boolean enabled = this.jCheckProcess.isSelected();
        this.jTextMagnification.setEnabled(enabled);
        this.jComboAnimationColor.setEnabled(enabled);
    }

    private void jButtonOptionActionPerformed(ActionEvent evt) {
        this.optionDialog.setVisible(true);
    }

    private void jButtonAnalysisActionPerformed(ActionEvent evt) {
        Thread threadAnalysis = new Thread(this);
        threadAnalysis.start();
    }

    private void jButtonToInitActionPerformed(ActionEvent evt) {
        this.panelInit.updateColor(this.panelFinal.getColorArray());
    }

    private void jButtonAddPresetActionPerformed(ActionEvent evt) {
        String name = this.getPresetsName();
        if (name.length() == 0) {
            name = "UNTITLED";
        }
        this.jComboPresets.addItem(name, this.panelInit.getColorArray());
        this.jComboPresets.setSelectedIndex(this.jComboPresets.getItemCount() - 1);
    }

    private void jButtonRemovePresetActionPerformed(ActionEvent evt) {
        int removeIndex = this.jComboPresets.getSelectedIndex();
        this.jComboPresets.removeItemAt(removeIndex);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.jComboPresets.setRGB(this.panelInit.getColorArray());
        this.jComboPresets.saveItem();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.colorDialog.dispose();
        this.segDialog.dispose();
        this.optionDialog.dispose();
        if (twResult != null) {
            twResult.dispose();
        }
        this.jLabelStatus.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonBreakActionPerformed(ActionEvent evt) {
        CytoQViewer cytoQViewer = this;
        synchronized (cytoQViewer) {
            boolean bl = this.threadSuspended = !this.threadSuspended;
            if (!this.threadSuspended) {
                this.notify();
                this.jButtonBreak.setText("SUSPEND");
            } else {
                this.jButtonBreak.setText("RESUME");
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CytoQViewer();
            }
        });
    }

    static {
        r = new Random();
        twResult = new JTextFrame();
        headerBase = new ArrayList();
        headerBase.add("File");
        headerBase.add("Calculation");
        headerBase.add("Time(s)");
        headerBase.add("Iteration");
        headerBase.add("Colors");
        headerBase.add("Likelihood");
    }
}

