/*
 * Decompiled with CFR 0.152.
 */
package cytoq;

import cytoq.PointsToImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import sos.canvas.JObjectCanvas;
import sos.graphics.PointRect;

public class ColorSpaceViewer
extends JFrame {
    private PointsToImage pointsToImage;
    private PointRect[] pointRects;
    private JObjectCanvas canvas;

    public ColorSpaceViewer() {
        this.initComponents();
    }

    public Dimension getCanvasSize() {
        return this.canvas.getSize();
    }

    public void setCanvasSize(int width, int height) {
        this.canvas.setSize(width, height);
        this.pack();
    }

    public PointsToImage getPointsToImage() {
        return this.pointsToImage;
    }

    public void setPointsToImage(PointsToImage pti) {
        this.pointsToImage = pti;
        this.setupCanvasFromPTI();
    }

    public void setPointsToImage(double[][] input, int[] colors) {
        this.pointsToImage = new PointsToImage(input);
        this.pointsToImage.setColors(colors);
        this.setupCanvasFromPTI();
    }

    private void setupCanvasFromPTI() {
        int h = this.pointsToImage.getHeight(this.canvas.getWidth());
        this.canvas.setSize(this.canvas.getWidth(), h);
        this.canvas.setImage(this.pointsToImage.getImage(this.canvas.getWidth(), h));
        this.canvas.getImageTransform().setFullSrc();
        this.pack();
    }

    public void setRectsNumber(int n) {
        this.pointRects = new PointRect[n * 2];
        for (int i = 0; i < this.pointRects.length; i += 2) {
            this.pointRects[i] = new PointRect(0, 0, 10);
            this.pointRects[i].setDrawMode(false);
            this.canvas.addGraphicObject(this.pointRects[i]);
            this.pointRects[i + 1] = new PointRect(0, 0, 10);
            this.pointRects[i + 1].setColor(Color.black);
            this.pointRects[i + 1].setDrawMode(true);
            this.canvas.addGraphicObject(this.pointRects[i + 1]);
        }
    }

    public void drawRects(double[][] rectLocations, Color[] colors) {
        if (this.isShowing()) {
            for (int i = 0; i < rectLocations.length; ++i) {
                int[] p = this.pointsToImage.convert(rectLocations[i]);
                int index = i * 2;
                this.pointRects[index].setLocation(p[0], p[1]);
                this.pointRects[index].setColor(colors[i]);
                this.pointRects[index + 1].setLocation(p[0], p[1]);
            }
            this.canvas.update(this.canvas.getGraphics());
        }
    }

    public void drawLabel(int[] colors, int[] labels) {
        if (this.isShowing()) {
            this.pointsToImage.setColors(labels, colors);
            this.canvas.setImage(this.pointsToImage.getImage(this.canvas.getWidth(), this.canvas.getHeight()));
            this.canvas.getImageTransform().setFullSrc();
            this.canvas.repaint();
        }
    }

    private void initComponents() {
        this.canvas = new JObjectCanvas();
        this.getContentPane().add((Component)this.canvas, "Center");
        this.pack();
    }
}

