/*
 * Decompiled with CFR 0.152.
 */
import cytoq.AnalyzePluginGUI;
import java.util.Arrays;
import sos.image.ImageInfo;
import sos.math.Clustering;
import sos.math.MathVector;
import sos.panel.JGenericPanel;
import sos.process.NeighborFrame;
import sos.util.MinMaxDouble;
import sos.util.Sets;

public class MarkovMeans
extends Clustering
implements AnalyzePluginGUI {
    private ImageInfo imi;
    double beta = 0.0;
    double betaDelta;
    double[] neighborBeta;
    double sentinel;
    double[][] preConvolutedUnit;
    int[] oldLabel;
    double[][] oldUnitMean;

    public MarkovMeans() {
        JGenericPanel panel = new JGenericPanel();
        panel.addNumericField("beta ", 1.0, 1);
        this.optionPanel = panel;
    }

    public void calculate() {
        int[] table = this.imi.getPixelColorTable();
        int[] nSameLabeledNeighbor = new int[this.nUnit];
        double[] preP = new double[this.nUnit];
        NeighborFrame nf = this.imi.getNeighborFrame();
        nf.set8();
        MinMaxDouble mmd = new MinMaxDouble();
        this.initCalculation();
        for (int pn = 0; pn < this.imi.getImageSize(); ++pn) {
            int un;
            int[] neighbors = nf.getExist(pn);
            Arrays.fill(nSameLabeledNeighbor, 0);
            for (int n = 0; n < neighbors.length; ++n) {
                int n2 = this.imi.getPixelsLabel(pn + neighbors[n]);
                nSameLabeledNeighbor[n2] = nSameLabeledNeighbor[n2] + 1;
            }
            double sumP = 0.0;
            for (un = 0; un < this.nUnit; ++un) {
                preP[un] = this.neighborBeta[nSameLabeledNeighbor[un]];
                sumP += preP[un];
            }
            un = 0;
            while (un < this.nUnit) {
                int n = un++;
                preP[n] = preP[n] / sumP;
            }
            double[] inp = this.inputD[table[pn]];
            mmd.setInit(Math.sqrt(MathVector.norm(inp, this.units[0].mean)) / preP[0]);
            for (un = 1; un < this.nUnit; ++un) {
                mmd.compareMin(Math.sqrt(MathVector.norm(inp, this.units[un].mean)) / preP[un]);
            }
            this.imi.setPixelsLabel(pn, mmd.getIndex());
            for (int d = 0; d < this.dim; ++d) {
                int n = d;
                this.units[mmd.getIndex()].cumInput[n] = this.units[mmd.getIndex()].cumInput[n] + inp[d];
            }
            this.units[mmd.getIndex()].nBelong += 1.0;
        }
        this.calcMean(true);
        this.imi.setClusterFromLabel(this.nUnit, this.cluster);
    }

    private void backupConvolution() {
        this.preConvolutedUnit = new double[this.nUnit][this.dim];
        for (int un = 0; un < this.nUnit; ++un) {
            System.arraycopy(this.units[un].mean, 0, this.preConvolutedUnit[un], 0, this.dim);
        }
    }

    public boolean isConvoluted() {
        return this.evaluatedValue < this.desiredValue;
    }

    private void setClusterAndLabel() {
        for (int in = 0; in < this.nInput; ++in) {
            this.cluster[in] = Sets.findNearest(this.getMeanD(), this.inputD[in]);
        }
        int[] table = this.imi.getPixelColorTable();
        for (int pn = 0; pn < this.imi.getImageSize(); ++pn) {
            this.imi.setPixelsLabel(pn, this.cluster[table[pn]]);
        }
    }

    public void setParameters(ImageInfo imi) {
        this.imi = imi;
        this.moveUnitsToNearestInputs();
        this.setClusterAndLabel();
        if (this.optionPanel != null) {
            this.beta = ((JGenericPanel)this.optionPanel).getFieldNumber(0);
            this.betaDelta = this.beta / 10.0;
            NeighborFrame nf = imi.getNeighborFrame();
            nf.set8();
            this.neighborBeta = new double[nf.getNumber() + 1];
            this.setBetaArray();
            this.oldLabel = new int[imi.getImageSize()];
            this.oldUnitMean = new double[this.nUnit][this.dim];
            this.backup();
            this.sentinel = Double.NEGATIVE_INFINITY;
        }
    }

    private void setBetaArray() {
        for (int i = 0; i < this.neighborBeta.length; ++i) {
            this.neighborBeta[i] = Math.exp((double)i * this.beta);
        }
    }

    private void backup() {
        for (int pn = 0; pn < this.imi.getImageSize(); ++pn) {
            this.oldLabel[pn] = this.imi.getPixelsLabel(pn);
        }
        for (int i = 0; i < this.oldUnitMean.length; ++i) {
            double[] current = this.getMeanD(i);
            System.arraycopy(current, 0, this.oldUnitMean[i], 0, this.dim);
        }
    }

    private void revertToBest() {
        for (int pn = 0; pn < this.imi.getImageSize(); ++pn) {
            this.imi.setPixelsLabel(pn, this.oldLabel[pn]);
        }
        this.setUnit(this.oldUnitMean);
    }

    public void setPixelsLabel(ImageInfo imi) {
    }
}

