/*
 * Decompiled with CFR 0.152.
 */
import cytoq.AnalyzePluginGUI;
import sos.image.ImageInfo;
import sos.math.Clustering;
import sos.math.MathVector;
import sos.panel.JGenericPanel;
import sos.util.Sets;

public class KMeans
extends Clustering
implements AnalyzePluginGUI {
    private int[] histogram;

    public KMeans() {
        JGenericPanel panel = new JGenericPanel();
        panel.addChoice("sampling", new String[]{"full color", "all pixels"}, 0);
        this.optionPanel = panel;
    }

    protected final void doHCM() {
        for (int in = 0; in < this.nInput; ++in) {
            int m = Sets.findNearest(this.getMeanD(), this.inputD[in]);
            MathVector.add(this.units[m].cumInput, this.inputD[in]);
            this.units[m].nBelong += 1.0;
            this.cluster[in] = m;
        }
    }

    protected final void doHistogramHCM() {
        for (int in = 0; in < this.nInput; ++in) {
            int m = Sets.findNearest(this.getMeanD(), this.inputD[in]);
            for (int d = 0; d < this.dim; ++d) {
                int n = d;
                this.units[m].cumInput[n] = this.units[m].cumInput[n] + this.inputD[in][d] * (double)this.histogram[in];
            }
            this.units[m].nBelong += (double)this.histogram[in];
            this.cluster[in] = m;
        }
    }

    protected final void calculate(boolean saveUnit) {
        this.initCalculation();
        if (this.histogram == null) {
            this.doHCM();
        } else {
            this.doHistogramHCM();
        }
        this.calcMean(saveUnit);
    }

    public void calculate() {
        this.calculate(true);
    }

    public boolean isConvoluted() {
        return this.evaluatedValue < this.desiredValue;
    }

    public void setParameters(ImageInfo imi) {
        int index = ((JGenericPanel)this.optionPanel).getChoiceIndex(0);
        this.histogram = (int[])(index == 0 ? imi.getHistogram() : null);
    }

    public void setPixelsLabel(ImageInfo imi) {
        imi.setPixelsLabel(this.cluster);
    }
}

