/*
 * Decompiled with CFR 0.152.
 */
package sos.window;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import sos.io.SOSImageIO;
import sos.window.JImageFrame;

public class JImageStack
extends JImageFrame {
    private ArrayList<Image> imageArray = new ArrayList();
    private SOSImageIO imageIO = new SOSImageIO();
    private JMenuBar jMenuBarMain;
    private JMenu jMenuFile;
    private JMenuItem jMenuSaveAll;
    private JMenuItem jMenuSaveCurrent;
    private JScrollBar jScrollBar;

    public JImageStack() {
        this.initComponents();
    }

    public void addImage(Image img) {
        this.imageArray.add(img);
        this.jScrollBar.setMaximum(this.imageArray.size());
    }

    public void removeImage(int index) {
        if (0 <= index && index < this.imageArray.size()) {
            this.imageArray.remove(index);
            this.jScrollBar.setMaximum(this.imageArray.size());
        }
    }

    private void initComponents() {
        this.jScrollBar = new JScrollBar();
        this.jMenuBarMain = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuSaveCurrent = new JMenuItem();
        this.jMenuSaveAll = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Image stack");
        this.jScrollBar.setOrientation(0);
        this.jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent evt) {
                JImageStack.this.jScrollBarAdjustmentValueChanged(evt);
            }
        });
        this.getContentPane().add((Component)this.jScrollBar, "South");
        this.jMenuFile.setText("File");
        this.jMenuSaveCurrent.setText("save current image");
        this.jMenuSaveCurrent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JImageStack.this.jMenuSaveCurrentActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveCurrent);
        this.jMenuSaveAll.setText("save all images");
        this.jMenuSaveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JImageStack.this.jMenuSaveAllActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveAll);
        this.jMenuBarMain.add(this.jMenuFile);
        this.setJMenuBar(this.jMenuBarMain);
        this.pack();
    }

    private void jMenuSaveAllActionPerformed(ActionEvent evt) {
        File parent = this.imageIO.getSaveDirectory();
        int type = this.imageIO.getFileType();
        for (int i = 0; i < this.imageArray.size(); ++i) {
            BufferedImage img;
            try {
                img = (BufferedImage)this.imageArray.get(i);
            }
            catch (ClassCastException e) {
                Image tempImage = this.imageArray.get(i);
                img = new BufferedImage(tempImage.getWidth(null), tempImage.getHeight(null), 2);
                Graphics g = img.getGraphics();
                g.drawImage(tempImage, 0, 0, null);
            }
            File file = new File(parent.getPath() + SOSImageIO.separator + i);
            SOSImageIO.writeImage(file, type, img);
        }
    }

    private void jMenuSaveCurrentActionPerformed(ActionEvent evt) {
        Image img = this.imageArray.get(this.jScrollBar.getValue());
        if (img instanceof BufferedImage) {
            this.imageIO.writeImage((BufferedImage)img);
        } else {
            BufferedImage bImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
            Graphics g = bImage.getGraphics();
            g.drawImage(img, 0, 0, null);
            this.imageIO.writeImage(bImage);
        }
    }

    private void jScrollBarAdjustmentValueChanged(AdjustmentEvent evt) {
        Image img = this.imageArray.get(this.jScrollBar.getValue());
        this.setImage(img);
    }
}

