/*
 * GunmetryViewer.java
 *
 * Created on 2005/02/19, 13:24
 */

package gunmetry;
import gunmetry.region.RegionGraphics;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import sos.image.ImageInfo;
import sos.image.ImagePixelMediator;
import sos.image.ROIRectangle;
import sos.io.Extension;
import sos.io.ExtensionFilter;
import sos.io.PluginClassLoader;
import sos.io.SOSFileIO;
import sos.io.SOSImageIO;
import sos.process.Morphology;
import sos.process.NeighborFrame;
import sos.process.Watershed;
import sos.util.ColorVector;
import sos.util.MinMaxDouble;
import sos.graphics.PointRect;
import gunmetry.region.RegionSet;

/**
 * Created on 2005/02/19
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 2.1 (2005/06/05)
 */
public class GunmetryViewer extends javax.swing.JFrame {
	
	static final private String	sep = System.getProperty("file.separator");
	static final private String pathExtractMarker = "extractMarker";
	static final private String pathAnalyze = "analysis";
	static final private ExtensionFilter filterImg;
	static final private ExtensionFilter filterGifPng;
	
	static private ImageIcon iconObject;
	static private ImageIcon iconBackground;
	
	static private Cursor cursorObject;
	static private Cursor cursorBackground;
	
	static private int BACKGROUND = 0;
	
	private File fileOriginal = null;
	private File fileCluster = null;
	private BufferedImage imgBackground;
	private Image imgResult;
	private BufferedImage imgOverlap;
	private BufferedImage imgBase;
	private BufferedImage imgFinal;
	
	private Markers markersObject = new Markers();
	private Markers markersBackground = new Markers();
	private FocusedMarker focusedMarker;
	private boolean[] analyzeMask;
	private ImageInfo imiAnalyze = new ImageInfo();
	private double[] gradient;
	private RegionSet nuclei = new RegionSet();
	private RegionSet skiz = new RegionSet();
	
	private Point dragStartPoint = new Point();
	private ROIRectangle selectionRect = new ROIRectangle();
	private PointRect pointRect = new PointRect(0,0,5);
	private boolean objectFocused;
	
	private SOSImageIO imageFileIO = new SOSImageIO();
	private SOSFileIO textFileIO = new SOSFileIO();
	
	private int preWidth;
	private int preHeight;
	
	private BufferedImage imgCursor = new BufferedImage(32,32,BufferedImage.TYPE_INT_ARGB);
	private boolean isObjectActive = true;
	
	private ExtractMarkerPlugin pluginMarkerObject;
	private ExtractMarkerPlugin pluginMarkerBackground;
	
	static{
		String[] exts = ImageIO.getReaderFormatNames();
		String description = "Image Files (ImageI/O readable)";
		filterImg = new ExtensionFilter(exts, description);
		filterGifPng = new ExtensionFilter(new String[]{"gif","png"}, "GIF or PNG");
	}
	
	/** Creates new form GunmetryViewer */
	public GunmetryViewer() {
		iconObject = new ImageIcon(getClass().getResource("resources/opBtn1.gif"));
		iconBackground = new ImageIcon(getClass().getResource("resources/opBtn2.gif"));
		RegionGraphics.setGunmetryViewer(this);
		
		setupKeyInput();
		
		initComponents();
		
		jCanvasColorMask.setColor(Color.black);
		jCanvasColorObj.setColor(Color.red);
		jCanvasColorBack.setColor(Color.yellow);
		regionContour.init(nuclei, new ImageIcon(getClass().getResource("resources/reBtn1.gif")),Color.black);
		skizContour.init(skiz, new ImageIcon(getClass().getResource("resources/reBtn2.gif")),Color.black);
		regionCentroid.init(nuclei, new ImageIcon(getClass().getResource("resources/reBtn3.gif")),Color.cyan);
		skizCentroid.init(skiz, new ImageIcon(getClass().getResource("resources/reBtn4.gif")),Color.blue);
		regionPath.init(nuclei, new ImageIcon(getClass().getResource("resources/reBtn5.gif")),Color.black);
		
		SpinnerNumberModel modelMarkerSize = new SpinnerNumberModel(5,1,1000,1);
		jSpinnerMarkerSize.setModel(modelMarkerSize);
		
		pack();
		
		cursorObject = createCursor(jCanvasColorObj.getColor());
		cursorBackground = createCursor(jCanvasColorBack.getColor());
		
		// setting up for jDialogSelectColor
		loadExtractMarkerPlugin();
		jDialogMarker.pack();
		
		jDialogMask.pack();
		
		loadAnalysisPlugin();
		jDialogAnalyze.pack();
		DefaultTableColumnModel columnModel =(DefaultTableColumnModel)jTableAnalyze.getColumnModel();
		columnModel.getColumn(1).setPreferredWidth(50);
		
		jCanvasMain.addGraphicObject(selectionRect);
		
		markersObject.setColor(jCanvasColorObj.getColor());
		markersObject.setPointRect(pointRect);
		markersBackground.setColor(jCanvasColorBack.getColor());
		markersBackground.setPointRect(pointRect);
		
		focusedMarker = new FocusedMarker(markersObject,markersBackground);
	}
	
	private Cursor createCursor(Color color){
		int size = imgCursor.getWidth();
		int hSize = size/2;
		int fqSize = size/4;
		Graphics g = imgCursor.getGraphics();
		Color colorClear = new Color(0,0,0,0);
		g.setColor(colorClear);
		g.fillRect(0,0,size,size);
		
		g.setColor(Color.black);
		g.fillRect(fqSize,hSize-1, hSize+1,3);
		g.fillRect(hSize-1,fqSize, 3,hSize+1);
		
		g.setColor(color);
		g.drawLine(fqSize,hSize, size-fqSize,hSize);
		g.drawLine(hSize,fqSize, hSize,size-fqSize);
		
		return Toolkit.getDefaultToolkit().createCustomCursor(imgCursor, new Point(hSize,hSize),"object");
	}
	
	private void setupKeyInput(){
		// setup for key inputs
		KeyboardFocusManager keyboardManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
		keyboardManager.addKeyEventPostProcessor(new KeyEventPostProcessor(){
			public boolean postProcessKeyEvent(KeyEvent evt){
				switch(evt.getID()){
					case KeyEvent.KEY_PRESSED:
						int keyCode = evt.getKeyCode();
						if (keyCode==KeyEvent.VK_DELETE){
							removeSelectedMarkers();
						}else if (keyCode==KeyEvent.VK_X){
							switchEditableMarkerType();
						}else if (keyCode==KeyEvent.VK_TAB){
							changeOperationButton();
						}else if (KeyEvent.VK_LEFT<=keyCode && keyCode<=KeyEvent.VK_DOWN){
							moveMarker(keyCode);
						}
						break;
					case KeyEvent.KEY_RELEASED:
						break;
					case KeyEvent.KEY_TYPED:
						break;
				}
				return false;
			}
		});
	}
	
	private void moveMarker(int keyCode){
		int dx = 0;
		int dy = 0;
		switch (keyCode){
			case KeyEvent.VK_LEFT:
				dx = -1;
				break;
			case KeyEvent.VK_UP:
				dy = -1;
				break;
			case KeyEvent.VK_RIGHT:
				dx = 1;
				break;
			case KeyEvent.VK_DOWN:
				dy = 1;
				break;
		}
		
		markersObject.translateSelected(dx,dy);
		markersBackground.translateSelected(dx,dy);
		updateFinalImage();
	}
	
	private void switchEditableMarkerType(){
		isObjectActive = !isObjectActive;
		if (isObjectActive){
			jToggleMarker.setIcon(iconObject);
			if (jToggleMarker.isSelected()){
				jCanvasMain.setCursor(cursorObject);
			}
		}else{
			jToggleMarker.setIcon(iconBackground);
			if (jToggleMarker.isSelected()){
				jCanvasMain.setCursor(cursorBackground);
			}
		}
	}
	
	private void changeOperationButton(){
		if (jToggleMarker.isSelected()){
			jToggleImage.setSelected(true);
		}else{
			jToggleMarker.setSelected(true);
		}
	}
	
	private void loadExtractMarkerPlugin(){
		File file = new File(pathExtractMarker);
		File[] fileList = file.listFiles();
		for (int i=0; i<fileList.length; i++){
			String algorithmName = Extension.remove(fileList[i].getName());
			jComboObjAlgorithm.addItem(algorithmName);
			jComboBackAlgorithm.addItem(algorithmName);
		}
		
		jComboObjAlgorithm.setSelectedItem("HDoom");
		jComboBackAlgorithm.setSelectedItem("HDoom");
	}
	
	private ExtractMarkerPlugin setMarkerOption(JPanel panel, String algorithmName){
		PluginClassLoader loader = new PluginClassLoader(pathExtractMarker);
		ExtractMarkerPlugin plugin = null;
		try{
			plugin = (ExtractMarkerPlugin)loader.loadClass(algorithmName).newInstance();
			JPanel optionPanel = plugin.getOptionPanel();
			if (2==panel.getComponentCount()){
				panel.remove(1);
			}
			if (optionPanel!=null){
				panel.add(optionPanel, BorderLayout.CENTER);
			}
			jDialogMarker.pack();
		}catch(Exception e){
			e.printStackTrace();
		}
		return plugin;
	}
	
	private void loadAnalysisPlugin(){
		File file = new File(pathAnalyze);
		File[] fileList = file.listFiles();
		DefaultTableModel model = (DefaultTableModel)jTableAnalyze.getModel();
		model.setRowCount(fileList.length);
		for (int i=0; i<fileList.length; i++){
			String algorithmName = Extension.remove(fileList[i].getName());
			model.setValueAt(algorithmName, i, 0);
			model.setValueAt(false,i,1);
		}
	}
	
	private void showResultImage(){
		if (imgResult!=null){
			double value = jSliderAlpha.getValue()/100.0;
			imgResult = ImagePixelMediator.setAlpha(imgResult, value);
			updateBaseImage();
			updateFinalImage();
		}
	}
	
	private boolean checkBackgroundImageSize(Dimension size){
		if (imgBackground==null || (size.width!=imgBackground.getWidth() || size.height!=imgBackground.getHeight())){
			return false;
		}
		
		return true;
	}
	
	private void showBackgroundImage(BufferedImage img){
		if (img==null){
			return;
		}
		imgBackground = img;
		updateBaseImage();
		updateFinalImage();
	}
	
	private BufferedImage createGradientImage(){
		// make a BufferedImage as result
		BufferedImage img = new BufferedImage(imgBackground.getWidth(),imgBackground.getHeight(),BufferedImage.TYPE_BYTE_GRAY);
		DataBufferByte buffer = (DataBufferByte)img.getRaster().getDataBuffer();
		
		MinMaxDouble mmd = new MinMaxDouble();
		mmd.compareMax(gradient);
		double maxGradient = mmd.getValue();
		int[] pixels = new int[gradient.length];
		int value;
		int alpha = 255<<24;
		for (int i=0; i<gradient.length; i++){
			value = (byte)(255*gradient[i]/maxGradient);
			buffer.setElem(i, value);
		}
		
		return img;
	}
	
	private void createResultImage2(){
		/*// make a BufferedImage as result
		imgResult = new BufferedImage(imgBackground.getWidth(),imgBackground.getHeight(),BufferedImage.TYPE_INT_ARGB);
		DataBufferInt buffer = (DataBufferInt)imgResult.getRaster().getDataBuffer();
		 
		// make result image
		int label;
		for (int i=0; i<buffer.getSize(); i++){
			label = imiAnalyze.getPixelsLabel(i);
			if (label>BACKGROUND){
				buffer.setElem(i, jCanvasColorObj.getColorInt());
			}else{
				if (label==BACKGROUND){
					buffer.setElem(i, jCanvasColorBack.getColorInt());
				}else{
					buffer.setElem(i, jCanvasColorMask.getColorInt());
				}
			}
		}
		 
		imgOverlap = new BufferedImage(imiAnalyze.getWidth(), imiAnalyze.getHeight(), BufferedImage.TYPE_INT_RGB);*/
	}
	
	private void createResultImage(){
		// make result image
		int[] result = new int[imiAnalyze.getImageSize()];
		int label;
		for (int i=0; i<result.length; i++){
			label = imiAnalyze.getPixelsLabel(i);
			if (label>BACKGROUND){
				result[i] = jCanvasColorObj.getColorInt();
			}else{
				if (label==BACKGROUND){
					result[i] = jCanvasColorBack.getColorInt();
				}else{
					result[i] = jCanvasColorMask.getColorInt();
				}
			}
		}
		imgResult = ImagePixelMediator.convertToImage(result, imiAnalyze.getWidth(), imiAnalyze.getHeight());
		imgOverlap = new BufferedImage(imiAnalyze.getWidth(), imiAnalyze.getHeight(), BufferedImage.TYPE_INT_RGB);
	}
	
	private void updateBaseImage(){
		imgBase = imgBackground;
		if(imgResult!=null){
			Graphics2D g = (Graphics2D)imgOverlap.getGraphics();
			g.drawImage(imgBackground,0,0,this);
			g.drawImage(imgResult,0,0,this);
			
			regionCentroid.draw(g);
			regionContour.draw(g);
			skizCentroid.draw(g);
			skizContour.draw(g);
			regionPath.draw(g);
			
			g.dispose();
			imgBase = imgOverlap;
		}
		
		if (jCheckMask.isSelected()){
			Graphics g = imgBase.getGraphics();
			g.setColor(jCanvasColorMask.getColor());
			int x,y;
			for (int i=0; i<analyzeMask.length; i++){
				if (analyzeMask[i]){
					x = i%imgOverlap.getWidth();
					y = i/imgOverlap.getWidth();
					g.drawLine(x,y, x, y);
				}
			}
		}
	}
	
	public void overlapImage(){
		updateBaseImage();
		updateFinalImage();
		jCanvasMain.repaint();
	}
	
	public int getCurrentImageWidth(){
		return imgFinal.getWidth();
	}
	
	private void updateFinalImage(){
		if (imgFinal!=null){
			Graphics g = imgFinal.getGraphics();
			g.drawImage(imgBase,0,0,null);
			markersObject.draw(g);
			markersBackground.draw(g);
			g.dispose();
			
			jCanvasMain.repaint();
		}
	}
	
	private ArrayList<Point> extractMarker(ExtractMarkerPlugin plugin, boolean[] binaryMap, String algorithmName){
		NeighborFrame nf = new NeighborFrame(imgBackground.getWidth(),imgBackground.getHeight());
		Morphology mo = new Morphology(nf);
		
		return plugin.extractMarker(mo,binaryMap);
	}
	
	private void removeSelectedMarkers(){
		markersObject.removeSelected();
		markersBackground.removeSelected();
		
		jCanvasMain.repaint();//repaintDirtyRegion();
		updateMarkerNumber();
		checkReadyToAnalyze();
	}
	
	private void checkSelectionType(int modifier){
		if ((modifier&InputEvent.SHIFT_MASK)==0){
			markersObject.clearSelection();
			markersBackground.clearSelection();
		}
	}
	
	private boolean[] getBinaryMap(boolean[] flag, int[] cluster){
		boolean[] result = new boolean[cluster.length];
		for (int i=0; i<cluster.length; i++){
			result[i] = flag[cluster[i]];
		}
		
		return result;
	}
	
	private void setMarkers(boolean[] flag, int[] colorCluster){
		boolean[] binaryMap = getBinaryMap(flag, colorCluster);
		markersObject.setAll(extractMarker(pluginMarkerObject, binaryMap, (String)jComboObjAlgorithm.getSelectedItem()));
		
		// reverse binaryMap to extract background markers
		for (int i=0; i<binaryMap.length; i++){
			binaryMap[i] = !binaryMap[i];
		}
		markersBackground.setAll(extractMarker(pluginMarkerBackground, binaryMap, (String)jComboBackAlgorithm.getSelectedItem()));
		
		updateMarkerNumber();
		checkReadyToAnalyze();
		updateFinalImage();
	}
	
	private void checkReadyToAnalyze(){
		boolean isReady = false;
		if (0<markersObject.size() && 0<markersBackground.size()){
			isReady = true;
		}
		
		jMenuSaveMarkers.setEnabled(isReady);
		jCheckMask.setEnabled(isReady);
		jButtonAnalyze.setEnabled(isReady);
		if (isReady){
			jLabelInfo.setText("Seed setting is done.");
		}else{
			jLabelInfo.setText("Inproper seed setting");
		}
	}
	
	private void removeMaskedMarkers(ArrayList<Point> markers){
		HashSet<Point> removeSet = new HashSet<Point>();
		for (Point p: markers){
			if (analyzeMask[pointToOffset(p)]){
				removeSet.add(p);
			}
		}
		markers.removeAll(removeSet);
	}
	
	private int pointToOffset(Point p){
		return p.x+p.y*imiAnalyze.getWidth();
	}
	
	private void convertMaskToWatershed(int indexWatershed){
		if (jCheckMask.isSelected()){
			for (int pn=0; pn<imiAnalyze.getImageSize(); pn++){
				if (analyzeMask[pn]){
					imiAnalyze.setPixelsLabel(pn, indexWatershed);
				}
			}
		}
	}
	
	private int[] deleteMaskedContour(int[] contour){
		ArrayList<Integer> notMaskedContour = new ArrayList<Integer>();
		for (int i=0; i<contour.length; i++){
			if (!analyzeMask[contour[i]]){
				notMaskedContour.add(contour[i]);
			}
		}
		int[] result = new int[notMaskedContour.size()];
		for (int i=0; i<notMaskedContour.size(); i++){
			result[i] = notMaskedContour.get(i);
		}
		return result;
	}
	
	private void initializeAnalysis(){
		// properties
		imgResult = null;
		imgOverlap = null;
		fileCluster = null;
		markersObject.clear();
		markersBackground.clear();
		
		// controls
		jMenuFile.setEnabled(false);
		jMenuSaveMarkers.setEnabled(false);
		jMenuResult.setEnabled(false);
		
		jCheckMask.setEnabled(false);
		
		jRadioCluster.setEnabled(false);
		jButtonSetCluster.setEnabled(false);
		
		jButtonAnalyze.setEnabled(false);
	}
	
	private void setNearestNeighbor(int[] distanceMap){
		NeighborFrame nf = imiAnalyze.getNeighborFrame();
		nf.set8();
		skiz.initMinDistance();
		int[] contourSkiz = skiz.getContour();
		for (int i=0; i<contourSkiz.length; i++){
			int pn = contourSkiz[i];
			int[] neighbor = nf.getDir(pn);
			for (int n=0; n<neighbor.length; n++){
				if (neighbor[n]!=0){
					int label = imiAnalyze.getPixelsLabel(pn+neighbor[n])-BACKGROUND-1;
					if (0<=label && distanceMap[pn+neighbor[n]]<skiz.getMinDistance(label)){
						int contraNeighbor = pn+neighbor[(n+4)%neighbor.length];
						int contraLabel = imiAnalyze.getPixelsLabel(contraNeighbor)-BACKGROUND-1;
						if (pn!=contraNeighbor && 0<=contraLabel){
							skiz.setMinDistance(label,distanceMap[pn+neighbor[n]]);
							skiz.setNearestNeighbor(label,skiz.getRegion(contraLabel));
							nuclei.setNearestNeighbor(label,nuclei.getRegion(contraLabel));
						}
					}
				}
			}
		}
	}
	
	private void updateMarkerNumber(){
		jLabelNObject.setText(Integer.toString(markersObject.size()));
		jLabelNBackground.setText(Integer.toString(markersBackground.size()));
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroupImage = new javax.swing.ButtonGroup();
        buttonGroupOperation = new javax.swing.ButtonGroup();
        jDialogMarker = new javax.swing.JDialog();
        jScrollPaneMarker = new javax.swing.JScrollPane();
        imageColorPickerMarker = new gunmetry.ImageColorPicker();
        jPanelObject = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jComboObjAlgorithm = new javax.swing.JComboBox();
        jPanelBackground = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jComboBackAlgorithm = new javax.swing.JComboBox();
        jPanelButtons = new javax.swing.JPanel();
        jButtonSetMarker = new javax.swing.JButton();
        jButtonCancelMarker = new javax.swing.JButton();
        jDialogMask = new javax.swing.JDialog();
        jScrollPaneMask = new javax.swing.JScrollPane();
        imageColorPickerMask = new gunmetry.ImageColorPicker();
        jPanelButtons1 = new javax.swing.JPanel();
        jButtonSetMask = new javax.swing.JButton();
        jButtonCancelMask = new javax.swing.JButton();
        jDialogAnalyze = new javax.swing.JDialog();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTableAnalyze = new javax.swing.JTable();
        jButtonOKResult = new javax.swing.JButton();
        jButtonCancelResult = new javax.swing.JButton();
        jPopupMenuDelete = new javax.swing.JPopupMenu();
        jMenuDeleteSelection = new javax.swing.JMenuItem();
        jLabelInfo = new javax.swing.JLabel();
        jPanelMain = new javax.swing.JPanel();
        jPanelImage = new javax.swing.JPanel();
        jRadioCluster = new javax.swing.JRadioButton();
        jRadioOriginal = new javax.swing.JRadioButton();
        jButtonSetOriginal = new javax.swing.JButton();
        jButtonSetCluster = new javax.swing.JButton();
        jCheckMask = new javax.swing.JCheckBox();
        jRadioGradient = new javax.swing.JRadioButton();
        jCanvasColorMask = new sos.canvas.JCanvasColor();
        jPanelMarkers = new javax.swing.JPanel();
        jButtonAssignColorsToMarkers = new javax.swing.JButton();
        jToggleObject = new javax.swing.JToggleButton();
        jToggleBackground = new javax.swing.JToggleButton();
        jLabel1 = new javax.swing.JLabel();
        jSpinnerMarkerSize = new javax.swing.JSpinner();
        jLabel7 = new javax.swing.JLabel();
        jLabelNObject = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabelNBackground = new javax.swing.JLabel();
        jCanvasColorObj = new sos.canvas.JCanvasColor();
        jCanvasColorBack = new sos.canvas.JCanvasColor();
        jPanelOeration = new javax.swing.JPanel();
        jButtonAnalyze = new javax.swing.JButton();
        jToggleMarker = new javax.swing.JToggleButton();
        jToggleImage = new javax.swing.JToggleButton();
        jButtonSwitchMarker = new javax.swing.JButton();
        jPanelResult = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jSliderAlpha = new javax.swing.JSlider();
        regionCentroid = new gunmetry.region.RegionCentroid();
        skizCentroid = new gunmetry.region.RegionCentroid();
        regionContour = new gunmetry.region.RegionContour();
        skizContour = new gunmetry.region.RegionContour();
        regionPath = new gunmetry.region.RegionPath();
        jCanvasMain = new sos.canvas.JObjectCanvas();
        jMenuBarMain = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuOpenMarkers = new javax.swing.JMenuItem();
        jMenuSaveMarkers = new javax.swing.JMenuItem();
        jMenuResult = new javax.swing.JMenu();
        jMenuSaveData = new javax.swing.JMenuItem();
        jMenuSaveImage = new javax.swing.JMenuItem();

        jDialogMarker.getContentPane().setLayout(new java.awt.GridBagLayout());

        jDialogMarker.setTitle("Set Maker");
        jDialogMarker.setModal(true);
        jScrollPaneMarker.setBorder(new javax.swing.border.TitledBorder("Select colors as OBJECT"));
        jScrollPaneMarker.setViewportView(imageColorPickerMarker);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jDialogMarker.getContentPane().add(jScrollPaneMarker, gridBagConstraints);

        jPanelObject.setLayout(new java.awt.BorderLayout());

        jPanelObject.setBorder(new javax.swing.border.TitledBorder("Object"));
        jLabel4.setText("algorithm: ");
        jPanel1.add(jLabel4);

        jComboObjAlgorithm.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboObjAlgorithmItemStateChanged(evt);
            }
        });

        jPanel1.add(jComboObjAlgorithm);

        jPanelObject.add(jPanel1, java.awt.BorderLayout.NORTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jDialogMarker.getContentPane().add(jPanelObject, gridBagConstraints);

        jPanelBackground.setLayout(new java.awt.BorderLayout());

        jPanelBackground.setBorder(new javax.swing.border.TitledBorder("Background"));
        jLabel5.setText("algorithm: ");
        jPanel2.add(jLabel5);

        jComboBackAlgorithm.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBackAlgorithmItemStateChanged(evt);
            }
        });

        jPanel2.add(jComboBackAlgorithm);

        jPanelBackground.add(jPanel2, java.awt.BorderLayout.NORTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jDialogMarker.getContentPane().add(jPanelBackground, gridBagConstraints);

        jButtonSetMarker.setText("SET");
        jButtonSetMarker.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSetMarkerActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonSetMarker);

        jButtonCancelMarker.setText("CANCEL");
        jButtonCancelMarker.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelMarkerActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonCancelMarker);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jDialogMarker.getContentPane().add(jPanelButtons, gridBagConstraints);

        jDialogMask.getContentPane().setLayout(new java.awt.GridBagLayout());

        jDialogMask.setTitle("Set Mask");
        jDialogMask.setModal(true);
        jScrollPaneMask.setBorder(new javax.swing.border.TitledBorder("Select color as MASK"));
        jScrollPaneMask.setViewportView(imageColorPickerMask);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jDialogMask.getContentPane().add(jScrollPaneMask, gridBagConstraints);

        jButtonSetMask.setText("SET");
        jButtonSetMask.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSetMaskActionPerformed(evt);
            }
        });

        jPanelButtons1.add(jButtonSetMask);

        jButtonCancelMask.setText("CANCEL");
        jButtonCancelMask.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelMaskActionPerformed(evt);
            }
        });

        jPanelButtons1.add(jButtonCancelMask);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jDialogMask.getContentPane().add(jPanelButtons1, gridBagConstraints);

        jDialogAnalyze.getContentPane().setLayout(new java.awt.GridBagLayout());

        jDialogAnalyze.setTitle("RESULT");
        jScrollPane1.setMinimumSize(new java.awt.Dimension(300, 300));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 300));
        jTableAnalyze.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Variable", "Output"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.Boolean.class
            };
            boolean[] canEdit = new boolean [] {
                false, true
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane1.setViewportView(jTableAnalyze);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        jDialogAnalyze.getContentPane().add(jScrollPane1, gridBagConstraints);

        jButtonOKResult.setText("OK");
        jButtonOKResult.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKResultActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jDialogAnalyze.getContentPane().add(jButtonOKResult, gridBagConstraints);

        jButtonCancelResult.setText("CANCEL");
        jButtonCancelResult.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelResultActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        jDialogAnalyze.getContentPane().add(jButtonCancelResult, gridBagConstraints);

        jMenuDeleteSelection.setText("Delete Selected");
        jMenuDeleteSelection.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuDeleteSelectionActionPerformed(evt);
            }
        });

        jPopupMenuDelete.add(jMenuDeleteSelection);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Gunmetry Ver. 2.0");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        jLabelInfo.setText(" ");
        getContentPane().add(jLabelInfo, java.awt.BorderLayout.SOUTH);

        jPanelMain.setLayout(new java.awt.GridBagLayout());

        jPanelImage.setLayout(new java.awt.GridBagLayout());

        jPanelImage.setBorder(new javax.swing.border.TitledBorder("Image"));
        buttonGroupImage.add(jRadioCluster);
        jRadioCluster.setText("cluster");
        jRadioCluster.setEnabled(false);
        jRadioCluster.setFocusable(false);
        jRadioCluster.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jRadioClusterItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelImage.add(jRadioCluster, gridBagConstraints);

        buttonGroupImage.add(jRadioOriginal);
        jRadioOriginal.setSelected(true);
        jRadioOriginal.setText("original");
        jRadioOriginal.setFocusable(false);
        jRadioOriginal.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jRadioOriginalItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelImage.add(jRadioOriginal, gridBagConstraints);

        jButtonSetOriginal.setText("Load");
        jButtonSetOriginal.setFocusCycleRoot(true);
        jButtonSetOriginal.setFocusPainted(false);
        jButtonSetOriginal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSetOriginalActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelImage.add(jButtonSetOriginal, gridBagConstraints);

        jButtonSetCluster.setText("Load");
        jButtonSetCluster.setEnabled(false);
        jButtonSetCluster.setFocusable(false);
        jButtonSetCluster.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSetClusterActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelImage.add(jButtonSetCluster, gridBagConstraints);

        jCheckMask.setText("mask");
        jCheckMask.setEnabled(false);
        jCheckMask.setFocusable(false);
        jCheckMask.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCheckMaskItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelImage.add(jCheckMask, gridBagConstraints);

        buttonGroupImage.add(jRadioGradient);
        jRadioGradient.setText("gradient");
        jRadioGradient.setEnabled(false);
        jRadioGradient.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jRadioGradientItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanelImage.add(jRadioGradient, gridBagConstraints);

        jCanvasColorMask.setLayout(null);

        jCanvasColorMask.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jCanvasColorMaskMousePressed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        jPanelImage.add(jCanvasColorMask, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 5;
        jPanelMain.add(jPanelImage, gridBagConstraints);

        jPanelMarkers.setLayout(new java.awt.GridBagLayout());

        jPanelMarkers.setBorder(new javax.swing.border.TitledBorder("Markers"));
        jButtonAssignColorsToMarkers.setText("RESETTING");
        jButtonAssignColorsToMarkers.setEnabled(false);
        jButtonAssignColorsToMarkers.setFocusable(false);
        jButtonAssignColorsToMarkers.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAssignColorsToMarkersActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        jPanelMarkers.add(jButtonAssignColorsToMarkers, gridBagConstraints);

        jToggleObject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/gunmetry/resources/mkBtn1.gif")));
        jToggleObject.setSelected(true);
        jToggleObject.setFocusable(false);
        jToggleObject.setMargin(new java.awt.Insets(1, 1, 1, 1));
        jToggleObject.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleObjectActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        jPanelMarkers.add(jToggleObject, gridBagConstraints);

        jToggleBackground.setIcon(new javax.swing.ImageIcon(getClass().getResource("/gunmetry/resources/mkBtn2.gif")));
        jToggleBackground.setSelected(true);
        jToggleBackground.setFocusable(false);
        jToggleBackground.setMargin(new java.awt.Insets(1, 1, 1, 1));
        jToggleBackground.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleBackgroundActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        jPanelMarkers.add(jToggleBackground, gridBagConstraints);

        jLabel1.setText("size: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelMarkers.add(jLabel1, gridBagConstraints);

        jSpinnerMarkerSize.setFocusable(false);
        jSpinnerMarkerSize.setRequestFocusEnabled(false);
        jSpinnerMarkerSize.setVerifyInputWhenFocusTarget(false);
        jSpinnerMarkerSize.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerMarkerSizeStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelMarkers.add(jSpinnerMarkerSize, gridBagConstraints);

        jLabel7.setText("n =");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 30, 0, 0);
        jPanelMarkers.add(jLabel7, gridBagConstraints);

        jLabelNObject.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelNObject.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelMarkers.add(jLabelNObject, gridBagConstraints);

        jLabel9.setText("n =");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 30, 0, 0);
        jPanelMarkers.add(jLabel9, gridBagConstraints);

        jLabelNBackground.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelNBackground.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelMarkers.add(jLabelNBackground, gridBagConstraints);

        jCanvasColorObj.setLayout(null);

        jCanvasColorObj.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jCanvasColorObjMousePressed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 0);
        jPanelMarkers.add(jCanvasColorObj, gridBagConstraints);

        jCanvasColorBack.setLayout(null);

        jCanvasColorBack.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jCanvasColorBackMousePressed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 0, 0);
        jPanelMarkers.add(jCanvasColorBack, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 6;
        jPanelMain.add(jPanelMarkers, gridBagConstraints);

        jPanelOeration.setLayout(new java.awt.GridBagLayout());

        jPanelOeration.setBorder(new javax.swing.border.TitledBorder("Operation"));
        jButtonAnalyze.setText("ANALYZE");
        jButtonAnalyze.setEnabled(false);
        jButtonAnalyze.setFocusable(false);
        jButtonAnalyze.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAnalyzeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelOeration.add(jButtonAnalyze, gridBagConstraints);

        buttonGroupOperation.add(jToggleMarker);
        jToggleMarker.setIcon(new javax.swing.ImageIcon(getClass().getResource("/gunmetry/resources/opBtn1.gif")));
        jToggleMarker.setSelected(true);
        jToggleMarker.setFocusPainted(false);
        jToggleMarker.setFocusable(false);
        jToggleMarker.setMargin(new java.awt.Insets(1, 1, 1, 1));
        jToggleMarker.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleMarkerItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelOeration.add(jToggleMarker, gridBagConstraints);

        buttonGroupOperation.add(jToggleImage);
        jToggleImage.setIcon(new javax.swing.ImageIcon(getClass().getResource("/gunmetry/resources/opBtn3.gif")));
        jToggleImage.setFocusPainted(false);
        jToggleImage.setFocusable(false);
        jToggleImage.setMargin(new java.awt.Insets(1, 1, 1, 1));
        jToggleImage.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleImageItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanelOeration.add(jToggleImage, gridBagConstraints);

        jButtonSwitchMarker.setText("SWITCH MARKER");
        jButtonSwitchMarker.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSwitchMarkerActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelOeration.add(jButtonSwitchMarker, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelMain.add(jPanelOeration, gridBagConstraints);

        jPanelResult.setLayout(new java.awt.GridBagLayout());

        jPanelResult.setBorder(new javax.swing.border.TitledBorder("Result"));
        jLabel3.setText("alpha: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanelResult.add(jLabel3, gridBagConstraints);

        jSliderAlpha.setMajorTickSpacing(50);
        jSliderAlpha.setMinorTickSpacing(10);
        jSliderAlpha.setPaintTicks(true);
        jSliderAlpha.setEnabled(false);
        jSliderAlpha.setPreferredSize(new java.awt.Dimension(100, 24));
        jSliderAlpha.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSliderAlphaStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanelResult.add(jSliderAlpha, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelResult.add(regionCentroid, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelResult.add(skizCentroid, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelResult.add(regionContour, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelResult.add(skizContour, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelResult.add(regionPath, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanelMain.add(jPanelResult, gridBagConstraints);

        getContentPane().add(jPanelMain, java.awt.BorderLayout.WEST);

        jCanvasMain.setOpaque(false);
        jCanvasMain.setPreferredSize(new java.awt.Dimension(640, 10));
        jCanvasMain.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jCanvasMainMouseDragged(evt);
            }
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                jCanvasMainMouseMoved(evt);
            }
        });
        jCanvasMain.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jCanvasMainMouseClicked(evt);
            }
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jCanvasMainMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jCanvasMainMouseReleased(evt);
            }
        });

        getContentPane().add(jCanvasMain, java.awt.BorderLayout.CENTER);

        jMenuBarMain.setDoubleBuffered(true);
        jMenuFile.setText("File");
        jMenuFile.setEnabled(false);
        jMenuOpenMarkers.setText("Open Markers");
        jMenuOpenMarkers.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuOpenMarkersActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuOpenMarkers);

        jMenuSaveMarkers.setText("Save Markers");
        jMenuSaveMarkers.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSaveMarkersActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuSaveMarkers);

        jMenuBarMain.add(jMenuFile);

        jMenuResult.setText("Result");
        jMenuResult.setEnabled(false);
        jMenuSaveData.setText("Save Data");
        jMenuSaveData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSaveDataActionPerformed(evt);
            }
        });

        jMenuResult.add(jMenuSaveData);

        jMenuSaveImage.setText("Save Image");
        jMenuSaveImage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSaveImageActionPerformed(evt);
            }
        });

        jMenuResult.add(jMenuSaveImage);

        jMenuBarMain.add(jMenuResult);

        setJMenuBar(jMenuBarMain);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents
	
	private void jCanvasMainMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasMainMousePressed
		if (jToggleImage.isSelected()){
			jCanvasMain.mousePressed(evt);
			return;
		}
		
		if (evt.getModifiers()!=4){ // NOT pressed the shift key
			checkSelectionType(evt.getModifiers());
			selectionRect.handleMousePressed(evt.getPoint());
			
			Point2D p = jCanvasMain.getImageTransform().inverseTransform(evt.getPoint());
			dragStartPoint.setLocation(p);
		}
		
		if (focusedMarker.isActive()){
			focusedMarker.removeFromMarkers();
			updateFinalImage();
		}else{
			selectionRect.setVisible(true);
		}
	}//GEN-LAST:event_jCanvasMainMousePressed
	
	private void jCanvasMainMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasMainMouseDragged
		if (jToggleImage.isSelected()){
			jCanvasMain.mouseDragged(evt);
			jCanvasMain.repaint();
			return;
		}
		
		if (!focusedMarker.isActive()){
			selectionRect.handleMouseDragged(evt.getPoint());
			jCanvasMain.repaint();
		}
		
	}//GEN-LAST:event_jCanvasMainMouseDragged
	
	private void jButtonSwitchMarkerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSwitchMarkerActionPerformed
		switchEditableMarkerType();
	}//GEN-LAST:event_jButtonSwitchMarkerActionPerformed
	
	private void jComboBackAlgorithmItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBackAlgorithmItemStateChanged
		pluginMarkerBackground = setMarkerOption(jPanelBackground, (String)jComboBackAlgorithm.getSelectedItem());
	}//GEN-LAST:event_jComboBackAlgorithmItemStateChanged
	
	private void jComboObjAlgorithmItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboObjAlgorithmItemStateChanged
		pluginMarkerObject = setMarkerOption(jPanelObject, (String)jComboObjAlgorithm.getSelectedItem());
	}//GEN-LAST:event_jComboObjAlgorithmItemStateChanged
	
	private void jButtonCancelMaskActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelMaskActionPerformed
		jDialogMask.setVisible(false);
	}//GEN-LAST:event_jButtonCancelMaskActionPerformed
	
	private void jButtonSetMaskActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSetMaskActionPerformed
		int nChecked = imageColorPickerMask.getCheckedNumber();
		if (nChecked==0 || nChecked==imageColorPickerMask.getColorNumber()){
			jLabelInfo.setText("Invalid color selections");
			return;
		}
		
		jDialogMask.setVisible(false);
	}//GEN-LAST:event_jButtonSetMaskActionPerformed
	
	private void jRadioGradientItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jRadioGradientItemStateChanged
		if (jRadioGradient.isSelected() && gradient!=null){
			showBackgroundImage(createGradientImage());
		}
	}//GEN-LAST:event_jRadioGradientItemStateChanged
	
	private void jToggleImageItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleImageItemStateChanged
		if (jToggleImage.isSelected()){
			jCanvasMain.setCursor(new Cursor(Cursor.HAND_CURSOR));
			jCanvasMain.setComponentPopupMenu(null);
		}
	}//GEN-LAST:event_jToggleImageItemStateChanged
	
	private void jToggleMarkerItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleMarkerItemStateChanged
		if (jToggleMarker.isSelected()){
			jCanvasMain.setCursor(cursorObject);
			jCanvasMain.setComponentPopupMenu(jPopupMenuDelete);
		}
	}//GEN-LAST:event_jToggleMarkerItemStateChanged
	
	private void jMenuDeleteSelectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuDeleteSelectionActionPerformed
		removeSelectedMarkers();
	}//GEN-LAST:event_jMenuDeleteSelectionActionPerformed
	
	private void jMenuSaveImageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSaveImageActionPerformed
		BufferedImage img = jCanvasMain.getScreenImage();
		imageFileIO.writeImage(img);
	}//GEN-LAST:event_jMenuSaveImageActionPerformed
	
	private void jCanvasColorMaskMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasColorMaskMousePressed
		overlapImage();
	}//GEN-LAST:event_jCanvasColorMaskMousePressed
	
	private void jCheckMaskItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckMaskItemStateChanged
		if (jCheckMask.isSelected()){
			imageFileIO.resetChoosableFileFilters();
			imageFileIO.setFileFilter(filterGifPng);
			File fileMask = imageFileIO.getOpenFile("Select a GIF file for mask...");
			if (fileMask==null){
				jCheckMask.setSelected(false);
				return;
			}
			
			BufferedImage img = imageFileIO.readImage(fileMask);
			ImageInfo imiMask = new ImageInfo(img);
			int[] maskCluster = imiMask.getPixelsLabel();
			imageColorPickerMask.setColorTable(imiMask.getPixels(), imiMask.getPixelsLabel());
			jDialogMask.setVisible(true);
			
			// after dialog operation
			boolean[] flag = imageColorPickerMask.getFlag();
			analyzeMask = getBinaryMap(flag, maskCluster);
			overlapImage();
		}else{
			analyzeMask = null;
		}
		
		jCanvasColorMask.setEnabled(jCheckMask.isSelected());
	}//GEN-LAST:event_jCheckMaskItemStateChanged
	
	private void jButtonOKResultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKResultActionPerformed
		
		ArrayList<ArrayList<Double>> result = new ArrayList<ArrayList<Double>>();
		ArrayList<String> variableName = new ArrayList<String>();
		PluginClassLoader loader = new PluginClassLoader(pathAnalyze);
		for (int i=0; i<jTableAnalyze.getRowCount(); i++){
			if ((Boolean)jTableAnalyze.getValueAt(i,1)){
				String algorithmName = (String)jTableAnalyze.getValueAt(i,0);
				try{
					AnalysisPlugin plugin = (AnalysisPlugin)loader.loadClass(algorithmName).newInstance();
					result.add(plugin.analyze(nuclei.getRegion(),skiz.getRegion()));
				}catch(Exception e){
					e.printStackTrace();
					return;
				}
				variableName.add(algorithmName);
			}
		}
		
		String[] strResult = new String[markersObject.size()+1];
		strResult[0] = "";
		for (int j=0; j<variableName.size(); j++){
			strResult[0] += variableName.get(j)+",";
		}
		for (int i=1; i<strResult.length; i++){
			strResult[i] = "";
			for (int j=0; j<result.size(); j++){
				strResult[i] += result.get(j).get(i-1)+",";
			}
		}
		
		textFileIO.resetChoosableFileFilters();
		textFileIO.writeStrings(strResult);
		
		jDialogAnalyze.setVisible(false);
	}//GEN-LAST:event_jButtonOKResultActionPerformed
	
	private void jButtonCancelResultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelResultActionPerformed
		jDialogAnalyze.setVisible(false);
	}//GEN-LAST:event_jButtonCancelResultActionPerformed
	
	private void jMenuSaveDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSaveDataActionPerformed
		jDialogAnalyze.setVisible(true);
	}//GEN-LAST:event_jMenuSaveDataActionPerformed
	
	private void jCanvasColorBackMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasColorBackMousePressed
		markersBackground.setColor(jCanvasColorBack.getColor());
		cursorBackground = createCursor(jCanvasColorBack.getColor());
		if (jToggleMarker.isSelected() && !isObjectActive){
			jCanvasMain.setCursor(cursorBackground);
		}
		updateFinalImage();
	}//GEN-LAST:event_jCanvasColorBackMousePressed
	
	private void jCanvasColorObjMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasColorObjMousePressed
		markersObject.setColor(jCanvasColorObj.getColor());
		cursorObject = createCursor(jCanvasColorObj.getColor());
		if (jToggleMarker.isSelected() && isObjectActive){
			jCanvasMain.setCursor(cursorObject);
		}
		updateFinalImage();
	}//GEN-LAST:event_jCanvasColorObjMousePressed
	
	private void jMenuOpenMarkersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuOpenMarkersActionPerformed
		ArrayList<String> data = textFileIO.readStrings();
		if (data==null){
			return;
		}
		
		// get the image size at when save the data
		String[] size = data.get(0).split(",");
		double ratioX = 1.0*imgBackground.getWidth()/Integer.valueOf(size[0]);
		double ratioY = 1.0*imgBackground.getHeight()/Integer.valueOf(size[1]);
		
		// String to Point and add to markersObject
		int nObject = Integer.valueOf(data.get(1));
		markersObject.clear();
		for (int i=2; i<nObject; i++){
			markersObject.add(data.get(i), ratioX,ratioY);
		}
		// String to Point and add to markersBackground
		markersBackground.clear();
		for (int i=nObject; i<data.size(); i++){
			markersBackground.add(data.get(i), ratioX,ratioY);
		}
		
		jRadioCluster.setEnabled(false);
		imiAnalyze = new ImageInfo(imgBackground);
		
		updateMarkerNumber();
		checkReadyToAnalyze();
		updateFinalImage();
	}//GEN-LAST:event_jMenuOpenMarkersActionPerformed
	
	private void jMenuSaveMarkersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSaveMarkersActionPerformed
		ArrayList<String> data = new ArrayList<String>();
		data.add(imgBackground.getWidth()+","+imgBackground.getHeight());
		data.add(Integer.toString(markersObject.size()+2));
		for (Point p: markersObject){
			String arg = p.x+","+p.y;
			data.add(arg);
		}
		for (Point p: markersBackground){
			String arg = p.x+","+p.y;
			data.add(arg);
		}
		textFileIO.resetChoosableFileFilters();
		textFileIO.writeStrings(data);
	}//GEN-LAST:event_jMenuSaveMarkersActionPerformed
	
	private void jButtonCancelMarkerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelMarkerActionPerformed
		jDialogMarker.setVisible(false);
	}//GEN-LAST:event_jButtonCancelMarkerActionPerformed
	
	private void jSliderAlphaStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSliderAlphaStateChanged
		showResultImage();
	}//GEN-LAST:event_jSliderAlphaStateChanged
	
	private void jCanvasMainMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasMainMouseReleased
		if (!focusedMarker.isActive()){
			if (selectionRect.isVisible()){
				// add PointRects which is inside of selectionRect to selectedMarkers
				Shape rect = jCanvasMain.getImageTransform().inverseTransform(selectionRect);
				markersObject.select(rect);
				markersBackground.select(rect);
				selectionRect.setVisible(false);
				updateFinalImage();
			}
		}else{
			Point2D p = jCanvasMain.getImageTransform().inverseTransform(evt.getPoint());
			focusedMarker.setLocation((int)p.getX(),(int)p.getY());
			focusedMarker.addToMarkers();
			updateFinalImage();
		}
	}//GEN-LAST:event_jCanvasMainMouseReleased
	
	private void jCanvasMainMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasMainMouseClicked
		if (jToggleImage.isSelected()){
			jCanvasMain.mouseClicked(evt);
			jCanvasMain.repaint();
			return;
		}
		
		Point2D p2D = jCanvasMain.getImageTransform().inverseTransform(evt.getPoint());
		if (focusedMarker.isActive()){
			markersObject.select(focusedMarker.get());
			markersBackground.select(focusedMarker.get());
		}else{Point p = new Point((int)p2D.getX(),(int)p2D.getY());
		if(jToggleMarker.isSelected()){
			if (isObjectActive){	// add a marker to markers as object
				markersObject.add(p);
			}else{	// add a marker to markers as background
				markersBackground.add(p);
			}
			if (!jMenuSaveMarkers.isEnabled()){
				jMenuSaveMarkers.setEnabled(true);
			}
		}
		checkReadyToAnalyze();
		updateMarkerNumber();
		}
		updateFinalImage();
	}//GEN-LAST:event_jCanvasMainMouseClicked
	
	private void jButtonAnalyzeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAnalyzeActionPerformed
		
		if (jCheckMask.isSelected()){
			removeMaskedMarkers(markersObject);
			removeMaskedMarkers(markersBackground);
		}
		
		Watershed watershed = new Watershed(imiAnalyze, BACKGROUND);
		int INIT = watershed.getIndexInitial();
		Arrays.fill(imiAnalyze.getPixelsLabel(),INIT);
		int offset;
		int count = BACKGROUND+1;
		for (Point p: markersObject){
			imiAnalyze.setPixelsLabel(pointToOffset(p), count);
			count++;
		}
		for (Point p: markersBackground){
			imiAnalyze.setPixelsLabel(pointToOffset(p), BACKGROUND);
		}
		Morphology mo = new Morphology(imiAnalyze.getNeighborFrame());
		watershed.setOrder(gradient);
		
		do{
			watershed.setFIFOMarker();
			watershed.flood4();
		}while(!watershed.isConvergence());
		watershed.undeterminedToWatershed();
		nuclei.setContour(watershed.getWatershed());
		convertMaskToWatershed(watershed.getIndexWatershed());
		nuclei.setRegion(markersObject, imiAnalyze, BACKGROUND);
		createResultImage();
		
		// make skiz
		boolean[] backgroundMap = new boolean[imiAnalyze.getImageSize()];
		for (int pn=0; pn<imiAnalyze.getImageSize(); pn++){
			if (imiAnalyze.getPixelsLabel(pn)>BACKGROUND){
				backgroundMap[pn] = false;
			}else{
				imiAnalyze.setPixelsLabel(pn,INIT);
				backgroundMap[pn] = true;
			}
		}
		watershed = new Watershed(imiAnalyze, BACKGROUND+1);
		int[] dist = mo.geodesicDistance4(backgroundMap);
		watershed.setOrder(dist);
		do{
			watershed.flood4();
		}while(!watershed.isConvergence());
		watershed.undeterminedToWatershed();
		if (jCheckMask.isSelected()){
			skiz.setContour(deleteMaskedContour(watershed.getWatershed()));
		}else{
			skiz.setContour(watershed.getWatershed());
		}
		convertMaskToWatershed(watershed.getIndexWatershed());
		skiz.setRegion(markersObject, imiAnalyze, BACKGROUND);
		
		setNearestNeighbor(dist);
		
		// show result image
		jSliderAlpha.setEnabled(true);
		showResultImage();
		
		// set up the conditions of controls
		jMenuResult.setEnabled(true);
	}//GEN-LAST:event_jButtonAnalyzeActionPerformed
	
	private void jSpinnerMarkerSizeStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerMarkerSizeStateChanged
		int value = (Integer)jSpinnerMarkerSize.getValue();
		pointRect.setSize(value);
		updateFinalImage();
	}//GEN-LAST:event_jSpinnerMarkerSizeStateChanged
	
	private void jCanvasMainMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasMainMouseMoved
		if (!jToggleImage.isSelected()){
			Point2D mousePoint2D = jCanvasMain.getImageTransform().inverseTransform(evt.getPoint());
			Point preFocus = focusedMarker.get();
			focusedMarker.set(mousePoint2D);
			
			if (!focusedMarker.equals(preFocus)){
				if (focusedMarker.isActive()){
					jCanvasMain.setCursor(new Cursor(Cursor.MOVE_CURSOR));
				}else{
					if (isObjectActive){
						jCanvasMain.setCursor(cursorObject);
					}else{
						jCanvasMain.setCursor(cursorBackground);
					}
				}
			}
		}
		jLabelInfo.setText("mouse(x,y)="+evt.getX()+","+evt.getY());
	}//GEN-LAST:event_jCanvasMainMouseMoved
	
	private void jToggleBackgroundActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleBackgroundActionPerformed
		jCanvasMain.repaint();
	}//GEN-LAST:event_jToggleBackgroundActionPerformed
	
	private void jToggleObjectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleObjectActionPerformed
		jCanvasMain.repaint();
	}//GEN-LAST:event_jToggleObjectActionPerformed
	
	private void jRadioClusterItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jRadioClusterItemStateChanged
		if (jRadioCluster.isSelected() && fileCluster!=null){
			showBackgroundImage(imageFileIO.readImage(fileCluster));
		}
	}//GEN-LAST:event_jRadioClusterItemStateChanged
	
	private void jRadioOriginalItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jRadioOriginalItemStateChanged
		if (jRadioOriginal.isSelected() && fileOriginal!=null){
			showBackgroundImage(imageFileIO.readImage(fileOriginal));
		}
	}//GEN-LAST:event_jRadioOriginalItemStateChanged
	
	private void jButtonSetMarkerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSetMarkerActionPerformed
		// check if any color is selected
		int nChecked = imageColorPickerMarker.getCheckedNumber();
		if (nChecked==0 || nChecked==imageColorPickerMarker.getColorNumber()){
			jLabelInfo.setText("Invalid selections for seed");
			return;
		}
		
		jDialogMarker.setVisible(false);
		
	}//GEN-LAST:event_jButtonSetMarkerActionPerformed
	
	private void jButtonAssignColorsToMarkersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAssignColorsToMarkersActionPerformed
		jDialogMarker.setVisible(true);
	}//GEN-LAST:event_jButtonAssignColorsToMarkersActionPerformed
	
	private void jButtonSetClusterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSetClusterActionPerformed
		imageFileIO.resetChoosableFileFilters();
		imageFileIO.setFileFilter(filterGifPng);
		fileCluster = imageFileIO.getOpenFile("Select a file for cluster image...");
		if (fileCluster==null){
			return;
		}
		
		Dimension size = imageFileIO.getImageSize(fileCluster);
		if (!checkBackgroundImageSize(size)){
			return;
		}
		
		ImageInfo imiCluster = new ImageInfo(imageFileIO.readImage(fileCluster));
		int[] colorCluster = imiCluster.getPixelsLabel();
		imageColorPickerMarker.setColorTable(imiCluster.getPixels(), imiCluster.getPixelsLabel());
		jDialogMarker.setVisible(true);
		
		// after dialog operation
		boolean[] flag = imageColorPickerMarker.getFlag();
		setMarkers(flag, colorCluster);
		
		jRadioCluster.setEnabled(true);
		jButtonAssignColorsToMarkers.setEnabled(true);
	}//GEN-LAST:event_jButtonSetClusterActionPerformed
	
	private void jButtonSetOriginalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSetOriginalActionPerformed
		initializeAnalysis();
		
		imageFileIO.resetChoosableFileFilters();
		imageFileIO.setFileFilter(filterImg);
		fileOriginal = imageFileIO.getOpenFile("Select the original image...");
		if (fileOriginal==null){
			return;
		}
		
		Dimension size = imageFileIO.getImageSize(fileOriginal);
		if (!checkBackgroundImageSize(size)){
			jCanvasMain.setSize(size.width,size.height);
			pack();
		}
		if (jRadioOriginal.isSelected()){
			imgBackground = imageFileIO.readImage(fileOriginal);
			updateBaseImage();
		}else{
			jRadioOriginal.setSelected(true);
		}
		
		imiAnalyze = new ImageInfo(imgBackground);
		Morphology mo = new Morphology(imiAnalyze.getNeighborFrame());
		double[][] LAB = new double[imiAnalyze.getImageSize()][3];
		ColorVector.getLAB(imiAnalyze.getPixels(),LAB);
		gradient = mo.calcSobel(LAB);
		
		jMenuFile.setEnabled(true);
		jRadioGradient.setEnabled(true);
		jButtonSetCluster.setEnabled(true);
		
		imgFinal = new BufferedImage(size.width,size.height,BufferedImage.TYPE_INT_ARGB);
		jCanvasMain.setImage(imgFinal);
		jCanvasMain.getImageTransform().setFullSrc();
		updateFinalImage();
		
		setTitle("Gunmetry Ver2.0 ("+fileOriginal.getName()+")");
	}//GEN-LAST:event_jButtonSetOriginalActionPerformed
	
	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new GunmetryViewer().setVisible(true);
			}
		});
	}
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupImage;
    private javax.swing.ButtonGroup buttonGroupOperation;
    private gunmetry.ImageColorPicker imageColorPickerMarker;
    private gunmetry.ImageColorPicker imageColorPickerMask;
    private javax.swing.JButton jButtonAnalyze;
    private javax.swing.JButton jButtonAssignColorsToMarkers;
    private javax.swing.JButton jButtonCancelMarker;
    private javax.swing.JButton jButtonCancelMask;
    private javax.swing.JButton jButtonCancelResult;
    private javax.swing.JButton jButtonOKResult;
    private javax.swing.JButton jButtonSetCluster;
    private javax.swing.JButton jButtonSetMarker;
    private javax.swing.JButton jButtonSetMask;
    private javax.swing.JButton jButtonSetOriginal;
    private javax.swing.JButton jButtonSwitchMarker;
    private sos.canvas.JCanvasColor jCanvasColorBack;
    private sos.canvas.JCanvasColor jCanvasColorMask;
    private sos.canvas.JCanvasColor jCanvasColorObj;
    private sos.canvas.JObjectCanvas jCanvasMain;
    private javax.swing.JCheckBox jCheckMask;
    private javax.swing.JComboBox jComboBackAlgorithm;
    private javax.swing.JComboBox jComboObjAlgorithm;
    private javax.swing.JDialog jDialogAnalyze;
    private javax.swing.JDialog jDialogMarker;
    private javax.swing.JDialog jDialogMask;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabelInfo;
    private javax.swing.JLabel jLabelNBackground;
    private javax.swing.JLabel jLabelNObject;
    private javax.swing.JMenuBar jMenuBarMain;
    private javax.swing.JMenuItem jMenuDeleteSelection;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenuItem jMenuOpenMarkers;
    private javax.swing.JMenu jMenuResult;
    private javax.swing.JMenuItem jMenuSaveData;
    private javax.swing.JMenuItem jMenuSaveImage;
    private javax.swing.JMenuItem jMenuSaveMarkers;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanelBackground;
    private javax.swing.JPanel jPanelButtons;
    private javax.swing.JPanel jPanelButtons1;
    private javax.swing.JPanel jPanelImage;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JPanel jPanelMarkers;
    private javax.swing.JPanel jPanelObject;
    private javax.swing.JPanel jPanelOeration;
    private javax.swing.JPanel jPanelResult;
    private javax.swing.JPopupMenu jPopupMenuDelete;
    private javax.swing.JRadioButton jRadioCluster;
    private javax.swing.JRadioButton jRadioGradient;
    private javax.swing.JRadioButton jRadioOriginal;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPaneMarker;
    private javax.swing.JScrollPane jScrollPaneMask;
    private javax.swing.JSlider jSliderAlpha;
    private javax.swing.JSpinner jSpinnerMarkerSize;
    private javax.swing.JTable jTableAnalyze;
    private javax.swing.JToggleButton jToggleBackground;
    private javax.swing.JToggleButton jToggleImage;
    private javax.swing.JToggleButton jToggleMarker;
    private javax.swing.JToggleButton jToggleObject;
    private gunmetry.region.RegionCentroid regionCentroid;
    private gunmetry.region.RegionContour regionContour;
    private gunmetry.region.RegionPath regionPath;
    private gunmetry.region.RegionCentroid skizCentroid;
    private gunmetry.region.RegionContour skizContour;
    // End of variables declaration//GEN-END:variables
	
}
