/*
 * Decompiled with CFR 0.152.
 */
package gunmetry.region;

import gunmetry.Markers;
import gunmetry.region.Region;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import sos.image.ImageInfo;

public class RegionSet {
    private Region[] regions;
    private int[] contour;
    private Color colorCentroid;
    private Color colorContour;
    private Color colorLine;
    private boolean drawCentroid;
    private boolean drawContour;
    private boolean drawLine;

    public int size() {
        return this.regions.length;
    }

    public Point2D getCentroid(int index) {
        return this.regions[index].getCentroid();
    }

    public void initMinDistance() {
        for (int i = 0; i < this.regions.length; ++i) {
            this.regions[i].setMinDistance(Integer.MAX_VALUE);
        }
    }

    public int getMinDistance(int index) {
        return this.regions[index].getMinDistance();
    }

    public void setMinDistance(int index, int value) {
        this.regions[index].setMinDistance(value);
    }

    public Region getNearestNeighbor(int index) {
        return this.regions[index].getNearestNeighbor();
    }

    public void setNearestNeighbor(int index, Region neighbor) {
        this.regions[index].setNearestNeighbor(neighbor);
    }

    public Region getRegion(int index) {
        return this.regions[index];
    }

    public Region[] getRegion() {
        return this.regions;
    }

    public void setRegion(Markers markers, ImageInfo imi, int backgroundIndex) {
        int offset;
        this.regions = new Region[markers.size()];
        for (int n = 0; n < this.regions.length; ++n) {
            this.regions[n] = new Region();
        }
        int count = 0;
        for (int i = 0; i < this.regions.length; ++i) {
            Point p = (Point)markers.get(i);
            this.regions[count].expandRegion(p.x, p.y);
            ++count;
        }
        int FIRST_LABEL = backgroundIndex + 1;
        for (int y = 0; y < imi.getHeight(); ++y) {
            offset = y * imi.getWidth();
            for (int x = 0; x < imi.getWidth(); ++x) {
                int pn = x + offset;
                int index = imi.getPixelsLabel(pn) - FIRST_LABEL;
                if (0 > index) continue;
                this.regions[index].expandRegion(x, y);
            }
        }
        for (int n = 0; n < this.regions.length; ++n) {
            this.regions[n].initMask();
            Rectangle bounds = this.regions[n].getBounds();
            for (int y = 0; y < bounds.height; ++y) {
                offset = (y + bounds.y) * imi.getWidth();
                for (int x = 0; x < bounds.width; ++x) {
                    int pn = x + bounds.x + offset;
                    if (imi.getPixelsLabel(pn) - FIRST_LABEL != n) continue;
                    this.regions[n].setMask(x, y);
                }
            }
        }
    }

    public int[] getContour() {
        return this.contour;
    }

    public void setContour(int[] contour) {
        this.contour = contour;
    }
}

