/*
 * Decompiled with CFR 0.152.
 */
package gunmetry.region;

import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class Region {
    private int size;
    private Rectangle bounds;
    private boolean[] mask;
    private int minDistance;
    private Region nearestNeighbor;

    public void expandRegion(int x, int y) {
        if (this.bounds == null) {
            this.bounds = new Rectangle(x, y, 1, 1);
        } else {
            this.bounds.add(x, y);
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void initMask() {
        this.mask = new boolean[this.bounds.width * this.bounds.height];
        this.size = 0;
    }

    public void setMask(int x, int y) {
        int index = x + y * this.bounds.width;
        this.mask[index] = true;
        ++this.size;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Point2D.Double getCentroid() {
        int cumY;
        int cumX;
        if (this.bounds != null) {
            cumX = this.bounds.x * this.size;
            cumY = this.bounds.y * this.size;
            for (int y = 0; y < this.bounds.height; ++y) {
                int offset = y * this.bounds.width;
                for (int x = 0; x < this.bounds.width; ++x) {
                    if (!this.mask[offset + x]) continue;
                    cumX += x;
                    cumY += y;
                }
            }
        } else {
            return null;
        }
        return new Point2D.Double(1.0 * (double)cumX / (double)this.size, 1.0 * (double)cumY / (double)this.size);
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(int minDistance) {
        this.minDistance = minDistance;
    }

    public Region getNearestNeighbor() {
        return this.nearestNeighbor;
    }

    public void setNearestNeighbor(Region nearestNeighbor) {
        this.nearestNeighbor = nearestNeighbor;
    }

    public boolean getMask(int index) {
        return this.mask[index];
    }

    public int getSize() {
        return this.size;
    }
}

