/*
 * Decompiled with CFR 0.152.
 */
package sos.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ImageTransform {
    private Image sourceImage;
    private AffineTransform affineTransform = new AffineTransform();
    private AffineTransform inverseTransform = null;
    private double magnification;
    private transient Dimension dest;
    private transient Point2D.Double pointAtImage;
    private transient Point2D.Double pointAtScreen;
    private transient Point2D.Double canvasCenter;
    private transient Point2D.Double screenOffset;
    private transient AffineTransform screenMx;

    public ImageTransform() {
        this.initTransient();
    }

    public ImageTransform(int width, int height, Image srcImg) {
        this.initTransient();
        this.setDestSize(width, height);
        this.setImage(srcImg);
        if (srcImg != null) {
            this.setFullSrc();
        }
    }

    public void initTransient() {
        this.dest = new Dimension();
        this.pointAtImage = new Point2D.Double();
        this.pointAtScreen = new Point2D.Double();
        this.canvasCenter = new Point2D.Double();
        this.screenOffset = new Point2D.Double();
        this.screenMx = new AffineTransform();
    }

    public void setImage(Image img) {
        if (img != null) {
            this.sourceImage = img;
        }
    }

    public void setDestSize(int width, int height) {
        this.dest.setSize(width, height);
        this.canvasCenter.x = (double)width / 2.0;
        this.canvasCenter.y = (double)height / 2.0;
    }

    public Dimension getDestSize() {
        return this.dest;
    }

    public void scaleImage(double newRatio) {
        this.scaleImage(newRatio, this.canvasCenter.x, this.canvasCenter.y);
    }

    public void scaleImage(double rate, double screenX, double screenY) {
        this.magnification *= rate;
        this.transformScreenToImage(screenX, screenY);
        this.affineTransform.translate(this.pointAtImage.x, this.pointAtImage.y);
        this.affineTransform.scale(rate, rate);
        this.affineTransform.translate(-this.pointAtImage.x, -this.pointAtImage.y);
        this.inverseTransform = null;
    }

    public void locateCenter() {
        this.magnification = 1.0;
        this.affineTransform.setToTranslation(this.canvasCenter.x - (double)this.getImageWidth() / 2.0, this.canvasCenter.y - (double)this.getImageHeight() / 2.0);
        this.screenOffset.setLocation(this.canvasCenter.x, this.canvasCenter.y);
        this.inverseTransform = null;
    }

    public void setFullSrc() {
        this.locateCenter();
        double rw = 1.0 * this.dest.getWidth() / (double)this.getImageWidth();
        double rh = 1.0 * this.dest.getHeight() / (double)this.getImageHeight();
        this.scaleImage(Math.min(rw, rh));
    }

    public int getImageWidth() {
        return this.sourceImage.getWidth(null);
    }

    public int getImageHeight() {
        return this.sourceImage.getHeight(null);
    }

    public void drawImage(Graphics g) {
        if (g != null && this.sourceImage != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(this.sourceImage, this.affineTransform, null);
        }
    }

    public void drawImage(Graphics g, Rectangle bounds) {
        g.setClip(bounds);
        this.drawImage(g);
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double value) {
        this.magnification = value;
        this.transformScreenToImage(this.canvasCenter.x, this.canvasCenter.y);
        this.affineTransform.setToTranslation(this.canvasCenter.x - this.pointAtImage.x, this.canvasCenter.y - this.pointAtImage.y);
        this.screenOffset.setLocation(this.pointAtImage.x, this.pointAtImage.y);
        this.scaleImage(value);
    }

    public void translateScreen(double dx, double dy) {
        this.screenMx.setToTranslation(dx, dy);
        this.affineTransform.preConcatenate(this.screenMx);
        this.screenOffset.x += dx;
        this.screenOffset.y += dy;
        this.inverseTransform = null;
    }

    private void transformScreenToImage(double screenX, double screenY) {
        this.pointAtScreen.x = screenX;
        this.pointAtScreen.y = screenY;
        try {
            this.affineTransform.inverseTransform(this.pointAtScreen, this.pointAtImage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Point2D inverseTransform(Point source) {
        try {
            this.affineTransform.inverseTransform(source, this.pointAtImage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.pointAtImage;
    }

    public Shape inverseTransform(Shape src) {
        if (this.inverseTransform == null) {
            try {
                this.inverseTransform = this.affineTransform.createInverse();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.inverseTransform.createTransformedShape(src);
    }

    public void rotateImage(double theta) {
        this.transformScreenToImage(this.canvasCenter.x, this.canvasCenter.y);
        this.affineTransform.rotate(theta, this.pointAtImage.x, this.pointAtImage.y);
        this.inverseTransform = null;
    }

    public void deformImage(double theta, double scaleRatio) {
        this.transformScreenToImage(this.canvasCenter.x, this.canvasCenter.y);
        this.affineTransform.translate(this.pointAtImage.x, this.pointAtImage.y);
        this.affineTransform.scale(scaleRatio, scaleRatio);
        this.affineTransform.rotate(theta);
        this.affineTransform.translate(-this.pointAtImage.x, -this.pointAtImage.y);
        this.inverseTransform = null;
    }

    public Point2D.Double getScreenOffset() {
        return this.screenOffset;
    }

    public boolean hasImage() {
        return this.sourceImage != null;
    }

    public Rectangle2D.Double getVisibleBounds() {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        this.transformScreenToImage(0.0, 0.0);
        rect.x = this.pointAtImage.x;
        rect.y = this.pointAtImage.y;
        rect.width = this.dest.getWidth() / this.magnification;
        rect.height = this.dest.getHeight() / this.magnification;
        return rect;
    }

    public Rectangle getVisibleBounds(int scale) {
        Rectangle rect = new Rectangle();
        this.transformScreenToImage(0.0, 0.0);
        rect.x = (int)((double)scale * this.pointAtImage.x);
        rect.y = (int)((double)scale * this.pointAtImage.y);
        rect.width = (int)((double)scale * this.dest.getWidth() / this.magnification);
        rect.height = (int)((double)scale * this.dest.getHeight() / this.magnification);
        return rect;
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public void setAffineTransform(AffineTransform affineTransform) {
        this.affineTransform = affineTransform;
    }

    public void calcMagnification() {
        this.magnification = this.affineTransform.getScaleX();
    }
}

