
/*
 * NuclearSize.java
 *
 * Created on 2005/03/07, 1:25
 */

import gunmetry.AnalyzePlugin;
import java.util.ArrayList;
import sos.process.ROI;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/03/07)
 */
public class NearestFormFactorDifference extends RegionFormFactor{
	
	private ArrayList<Double> result = null;

	public ArrayList<Double> analyze(ROI[] nuclei, ROI[] skiz) {
		if (result==null){
			result = new ArrayList<Double>();
			double value = 0.0;
			for (int i=0; i<nuclei.length; i++){
				value = calcFormFactor(nuclei[i]);
				value -= calcFormFactor(nuclei[i].getNearestNeighbor());
				result.add(Math.abs(value));
			}
		}
		return result;
	}
	
}
