/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

import java.awt.geom.Rectangle2D;

public final class MathVector {
    private static int distance;
    private static double distanceD;

    public static final void add(int[] vec1, int[] vec2) {
        for (int d = 0; d < vec1.length; ++d) {
            int n = d;
            vec1[n] = vec1[n] + vec2[d];
        }
    }

    public static final void add(double[] vec1, double[] vec2) {
        for (int d = 0; d < vec1.length; ++d) {
            int n = d;
            vec1[n] = vec1[n] + vec2[d];
        }
    }

    public static final void add(double[] vec1, int[] vec2) {
        for (int d = 0; d < vec1.length; ++d) {
            int n = d;
            vec1[n] = vec1[n] + (double)vec2[d];
        }
    }

    public static final void subtract(int[] vec1, int[] vec2) {
        for (int d = 0; d < vec1.length; ++d) {
            int n = d;
            vec1[n] = vec1[n] - vec2[d];
        }
    }

    public static final void subtract(double[] vec1, double[] vec2) {
        for (int d = 0; d < vec1.length; ++d) {
            int n = d;
            vec1[n] = vec1[n] - vec2[d];
        }
    }

    public static final void subtract(int[] vec1, int[] vec2, int[] result) {
        for (int d = 0; d < vec1.length; ++d) {
            result[d] = vec1[d] - vec2[d];
        }
    }

    public static final void subtract(double[] vec1, double[] vec2, double[] result) {
        for (int d = 0; d < vec1.length; ++d) {
            result[d] = vec1[d] - vec2[d];
        }
    }

    public static final void subtract(int[] vec1, double[] vec2, double[] result) {
        for (int d = 0; d < vec1.length; ++d) {
            result[d] = (double)vec1[d] - vec2[d];
        }
    }

    public static final int[] diff(int[] vec1, int[] vec2) {
        int[] result = new int[vec1.length];
        for (int d = 0; d < vec1.length; ++d) {
            result[d] = vec1[d] - vec2[d];
        }
        return result;
    }

    public static final double[] diff(double[] vec1, double[] vec2) {
        double[] result = new double[vec1.length];
        for (int d = 0; d < vec1.length; ++d) {
            result[d] = vec1[d] - vec2[d];
        }
        return result;
    }

    public static final double[] diff(int[] vec1, double[] vec2) {
        double[] result = new double[vec1.length];
        for (int d = 0; d < vec1.length; ++d) {
            result[d] = (double)vec1[d] - vec2[d];
        }
        return result;
    }

    public static final void scale(int[] vec, int value) {
        for (int d = 0; d < vec.length; ++d) {
            vec[d] = vec[d] * value;
        }
    }

    public static final void scale(int[] vec, double value) {
        for (int d = 0; d < vec.length; ++d) {
            vec[d] = (int)Math.round((double)vec[d] * value);
        }
    }

    public static final void scale(double[] vec, double value) {
        for (int d = 0; d < vec.length; ++d) {
            vec[d] = vec[d] * value;
        }
    }

    public static final int[] scaleD2I(double[] vec, double value) {
        int[] result = new int[vec.length];
        for (int d = 0; d < vec.length; ++d) {
            result[d] = (int)Math.round(vec[d] * value);
        }
        return result;
    }

    public static final double[] scaleI2D(int[] vec, double value) {
        double[] result = new double[vec.length];
        for (int d = 0; d < vec.length; ++d) {
            result[d] = (double)vec[d] * value;
        }
        return result;
    }

    public static final int[] divide(int[] vec, int value) {
        int[] result = new int[vec.length];
        for (int d = 0; d < vec.length; ++d) {
            result[d] = (int)Math.round(1.0 * (double)vec[d] / (double)value);
        }
        return result;
    }

    public static final int[] divide(int[] vec, double value) {
        int[] result = new int[vec.length];
        for (int d = 0; d < vec.length; ++d) {
            result[d] = (int)Math.round((double)vec[d] / value);
        }
        return result;
    }

    public static final double[] divide(double[] vec, double value) {
        double[] result = new double[vec.length];
        for (int d = 0; d < vec.length; ++d) {
            result[d] = vec[d] / value;
        }
        return result;
    }

    public static final int[] divideD2I(double[] vec, double value) {
        int[] result = new int[vec.length];
        for (int d = 0; d < vec.length; ++d) {
            result[d] = (int)Math.round(vec[d] / value);
        }
        return result;
    }

    public static final double[] divideI2D(int[] vec, double value) {
        double[] result = new double[vec.length];
        for (int d = 0; d < vec.length; ++d) {
            result[d] = (double)vec[d] / value;
        }
        return result;
    }

    public static final int dot(int[] vec1, int[] vec2) {
        int result = 0;
        for (int d = 0; d < vec1.length; ++d) {
            result += vec1[d] * vec2[d];
        }
        return result;
    }

    public static final double dot(double[] vec1, double[] vec2) {
        double result = 0.0;
        for (int d = 0; d < vec1.length; ++d) {
            result += vec1[d] * vec2[d];
        }
        return result;
    }

    public static final double dot(double[] vec1, int[] vec2) {
        double result = 0.0;
        for (int d = 0; d < vec1.length; ++d) {
            result += vec1[d] * (double)vec2[d];
        }
        return result;
    }

    public static final double length(int[] vec) {
        double result = 0.0;
        for (int d = 0; d < vec.length; ++d) {
            result += (double)(vec[d] * vec[d]);
        }
        return Math.sqrt(result);
    }

    public static final double length(double[] vec) {
        double result = 0.0;
        for (int d = 0; d < vec.length; ++d) {
            result += vec[d] * vec[d];
        }
        return Math.sqrt(result);
    }

    public static final int cross2d(int[] vec1, int[] vec2) {
        return vec1[0] * vec2[1] - vec1[1] * vec2[0];
    }

    public static final double cross2d(double[] vec1, double[] vec2) {
        return vec1[0] * vec2[1] - vec1[1] * vec2[0];
    }

    public static final double[] cross3d(double[] vec1, double[] vec2) {
        double[] result = new double[]{vec1[1] * vec2[2] - vec1[2] * vec2[1], vec1[2] * vec2[0] - vec1[0] * vec2[2], vec1[0] * vec2[1] - vec1[1] * vec2[0]};
        return result;
    }

    public static final double[] normalize(double[] vec) {
        return MathVector.divide(vec, MathVector.length(vec));
    }

    public static final int[] mean(int[][] vec) {
        int[] result = new int[vec[0].length];
        for (int n = 0; n < vec.length; ++n) {
            for (int d = 0; d < vec[0].length; ++d) {
                int n2 = d;
                result[n2] = result[n2] + vec[n][d];
            }
        }
        for (int d = 0; d < vec[0].length; ++d) {
            result[d] = (int)Math.round(1.0 * (double)result[d] / (double)vec.length);
        }
        return result;
    }

    public static final double[] meanI2D(int[][] vec) {
        double[] result = new double[vec[0].length];
        for (int n = 0; n < vec.length; ++n) {
            for (int d = 0; d < vec[0].length; ++d) {
                int n2 = d;
                result[n2] = result[n2] + (double)vec[n][d];
            }
        }
        for (int d = 0; d < vec[0].length; ++d) {
            result[d] = result[d] / (double)vec.length;
        }
        return result;
    }

    public static final double[] mean(double[][] vec) {
        double[] result = new double[vec[0].length];
        for (int n = 0; n < vec.length; ++n) {
            for (int d = 0; d < vec[0].length; ++d) {
                int n2 = d;
                result[n2] = result[n2] + vec[n][d];
            }
        }
        int d = 0;
        while (d < vec[0].length) {
            int n = d++;
            result[n] = result[n] / (double)vec.length;
        }
        return result;
    }

    public static final double[] mean(double[][] vec, int[] histogram) {
        double[] result = new double[vec[0].length];
        int total = 0;
        for (int n = 0; n < vec.length; ++n) {
            for (int d = 0; d < vec[0].length; ++d) {
                int n2 = d;
                result[n2] = result[n2] + vec[n][d];
            }
            total += histogram[n];
        }
        int d = 0;
        while (d < vec[0].length) {
            int n = d++;
            result[n] = result[n] / (double)total;
        }
        return result;
    }

    public static final double[] weightMean(double[][] vec, double[] alpha) {
        double[] result = new double[vec[0].length];
        for (int n = 0; n < vec.length; ++n) {
            for (int d = 0; d < result.length; ++d) {
                int n2 = d;
                result[n2] = result[n2] + alpha[n] * vec[n][d];
            }
        }
        return result;
    }

    public static final double[] weightMean(double[] vec1, double[] vec2, double r1, double r2) {
        double[] result = new double[vec1.length];
        double r = r1 + r2;
        for (int d = 0; d < vec1.length; ++d) {
            result[d] = (r1 * vec1[d] + r2 * vec2[d]) / r;
        }
        return result;
    }

    public static final int[] weightMean(int[] vec1, int[] vec2, double r1, double r2) {
        int[] result = new int[vec1.length];
        double r = r1 + r2;
        for (int d = 0; d < vec1.length; ++d) {
            result[d] = (int)Math.round((r1 * (double)vec1[d] + r2 * (double)vec2[d]) / r);
        }
        return result;
    }

    public static final int blockDistance(int[] vec1, int[] vec2) {
        distance = 0;
        for (int d = 0; d < vec1.length; ++d) {
            distance += Math.abs(vec1[d] - vec2[d]);
        }
        return distance;
    }

    public static final double blockDistance(double[] vec1, double[] vec2) {
        distanceD = 0.0;
        for (int d = 0; d < vec1.length; ++d) {
            distanceD += Math.abs(vec1[d] - vec2[d]);
        }
        return distanceD;
    }

    public static final int norm(int[] vec1, int[] vec2) {
        distance = 0;
        for (int d = 0; d < vec1.length; ++d) {
            distance += (vec1[d] - vec2[d]) * (vec1[d] - vec2[d]);
        }
        return distance;
    }

    public static final double norm(double[] vec1, double[] vec2) {
        distanceD = 0.0;
        for (int d = 0; d < vec1.length; ++d) {
            distanceD += (vec1[d] - vec2[d]) * (vec1[d] - vec2[d]);
        }
        return distanceD;
    }

    public static final int normSum(int[][] vec1, int[][] vec2) {
        distance = 0;
        for (int n = 0; n < vec1.length; ++n) {
            for (int d = 0; d < vec1[0].length; ++d) {
                distance += (vec1[n][d] - vec2[n][d]) * (vec1[n][d] - vec2[n][d]);
            }
        }
        return distance;
    }

    public static final double normSum(double[][] vec1, double[][] vec2) {
        distanceD = 0.0;
        for (int n = 0; n < vec1.length; ++n) {
            for (int d = 0; d < vec1[0].length; ++d) {
                distanceD += (vec1[n][d] - vec2[n][d]) * (vec1[n][d] - vec2[n][d]);
            }
        }
        return distanceD;
    }

    public static final double normSum(double[][] vec1, double[] vec2) {
        distanceD = 0.0;
        for (int n = 0; n < vec1.length; ++n) {
            for (int d = 0; d < vec2.length; ++d) {
                distanceD += (vec1[n][d] - vec2[d]) * (vec1[n][d] - vec2[d]);
            }
        }
        return distanceD;
    }

    public static final double cos(int[] vec1, int[] vec2) {
        int d1 = MathVector.dot(vec1, vec1);
        int d2 = MathVector.dot(vec2, vec2);
        double result = (double)MathVector.dot(vec1, vec2) / (Math.sqrt(d1) * Math.sqrt(d2));
        return result;
    }

    public static final double cos(int[] vec1, int[] vec2, int[] center1, int[] center2) {
        return MathVector.cos(MathVector.diff(vec1, center1), MathVector.diff(vec2, center2));
    }

    public static final double cos(double[] vec1, double[] vec2) {
        double d1 = MathVector.dot(vec1, vec1);
        double d2 = MathVector.dot(vec2, vec2);
        double result = MathVector.dot(vec1, vec2) / (Math.sqrt(d1) * Math.sqrt(d2));
        return result;
    }

    public static final double cos(double[] vec1, double[] vec2, double[] center) {
        return MathVector.cos(MathVector.diff(vec1, center), MathVector.diff(vec2, center));
    }

    public static final int[][] zeroSet(int[][] vec1, int[] vec2) {
        int[][] result = new int[vec1.length][vec2.length];
        for (int n = 0; n < vec1.length; ++n) {
            for (int d = 0; d < vec2.length; ++d) {
                result[n][d] = vec1[n][d] - vec2[d];
            }
        }
        return result;
    }

    public static final double[][] zeroSet(double[][] vec1, double[] vec2) {
        double[][] result = new double[vec1.length][vec2.length];
        for (int n = 0; n < vec1.length; ++n) {
            for (int d = 0; d < vec2.length; ++d) {
                result[n][d] = vec1[n][d] - vec2[d];
            }
        }
        return result;
    }

    public static final int[] merge(int[] vec1, int[] vec2) {
        int[] result = new int[vec1.length + vec2.length];
        System.arraycopy(vec1, 0, result, 0, vec1.length);
        System.arraycopy(vec2, 0, result, vec1.length, vec2.length);
        return result;
    }

    public static final int[] doubleToInt(double[] vec) {
        int[] result = new int[vec.length];
        for (int d = 0; d < vec.length; ++d) {
            result[d] = (int)Math.round(vec[d]);
        }
        return result;
    }

    public static final double[][] covariance(double[][] vec) {
        int x;
        int y;
        int dim = vec[0].length;
        double[] mean = MathVector.mean(vec);
        double[] difVec = new double[dim];
        double[][] covMx = new double[dim][dim];
        for (int n = 0; n < vec.length; ++n) {
            for (int d = 0; d < dim; ++d) {
                difVec[d] = vec[n][d] - mean[d];
            }
            for (int y2 = 0; y2 < dim; ++y2) {
                for (int x2 = y2; x2 < dim; ++x2) {
                    double[] dArray = covMx[y2];
                    int n2 = x2;
                    dArray[n2] = dArray[n2] + difVec[y2] * difVec[x2];
                }
            }
        }
        for (y = 0; y < dim; ++y) {
            x = y;
            while (x < dim) {
                double[] dArray = covMx[y];
                int n = x++;
                dArray[n] = dArray[n] / (double)vec.length;
            }
        }
        for (y = 0; y < dim; ++y) {
            for (x = y + 1; x < dim; ++x) {
                covMx[x][y] = covMx[y][x];
            }
        }
        return covMx;
    }

    public static final double[][][] covariance(double[][] vec, int[] cluster, int nCluster) {
        int x;
        int y;
        int n;
        int dim = vec[0].length;
        double[][] mean = new double[nCluster][dim];
        int[] nBelongs = new int[nCluster];
        for (int n2 = 0; n2 < cluster.length; ++n2) {
            MathVector.add(mean[cluster[n2]], vec[n2]);
            int n3 = cluster[n2];
            nBelongs[n3] = nBelongs[n3] + 1;
        }
        for (int i = 0; i < nCluster; ++i) {
            mean[i] = MathVector.divide(mean[i], (double)nBelongs[i]);
        }
        double[] difVec = new double[dim];
        double[][][] covMx = new double[nCluster][dim][dim];
        for (n = 0; n < vec.length; ++n) {
            for (int d = 0; d < dim; ++d) {
                difVec[d] = vec[n][d] - mean[cluster[n]][d];
            }
            for (y = 0; y < dim; ++y) {
                for (x = y; x < dim; ++x) {
                    double[] dArray = covMx[cluster[n]][y];
                    int n4 = x;
                    dArray[n4] = dArray[n4] + difVec[y] * difVec[x];
                }
            }
        }
        for (n = 0; n < nCluster; ++n) {
            for (y = 0; y < dim; ++y) {
                x = y;
                while (x < dim) {
                    double[] dArray = covMx[n][y];
                    int n5 = x++;
                    dArray[n5] = dArray[n5] / (double)nBelongs[n];
                }
            }
        }
        for (n = 0; n < nCluster; ++n) {
            for (y = 0; y < dim; ++y) {
                for (x = y + 1; x < dim; ++x) {
                    covMx[n][x][y] = covMx[n][y][x];
                }
            }
        }
        return covMx;
    }

    public static final double[][] covariance(double[] vec, int dim) {
        int x;
        int y;
        int length = vec.length / dim;
        double[] mean = new double[dim];
        for (int n = 0; n < vec.length; n += dim) {
            for (int d = 0; d < dim; ++d) {
                int n2 = d;
                mean[n2] = mean[n2] + vec[n + d];
            }
        }
        int d = 0;
        while (d < dim) {
            int n = d++;
            mean[n] = mean[n] / (double)length;
        }
        double[] difVec = new double[dim];
        double[][] covMx = new double[dim][dim];
        for (int n = 0; n < vec.length; n += dim) {
            for (int d2 = 0; d2 < dim; ++d2) {
                difVec[d2] = vec[n + d2] - mean[d2];
            }
            for (int y2 = 0; y2 < dim; ++y2) {
                for (int x2 = y2; x2 < dim; ++x2) {
                    double[] dArray = covMx[y2];
                    int n3 = x2;
                    dArray[n3] = dArray[n3] + difVec[y2] * difVec[x2];
                }
            }
        }
        for (y = 0; y < dim; ++y) {
            x = y;
            while (x < dim) {
                double[] dArray = covMx[y];
                int n = x++;
                dArray[n] = dArray[n] / (double)length;
            }
        }
        for (y = 0; y < dim; ++y) {
            for (x = y + 1; x < dim; ++x) {
                covMx[x][y] = covMx[y][x];
            }
        }
        return covMx;
    }

    public static final double[][] corelations(double[] vec, int dim) {
        int x;
        int y;
        int length = vec.length / dim;
        double[] mean = new double[dim];
        for (int n = 0; n < vec.length; n += dim) {
            for (int d = 0; d < dim; ++d) {
                int n2 = d;
                mean[n2] = mean[n2] + vec[n + d];
            }
        }
        int d = 0;
        while (d < dim) {
            int n = d++;
            mean[n] = mean[n] / (double)length;
        }
        double[] difVec = new double[dim];
        double[][] covMx = new double[dim][dim];
        for (int n = 0; n < vec.length; n += dim) {
            for (int d2 = 0; d2 < dim; ++d2) {
                difVec[d2] = vec[n + d2] - mean[d2];
            }
            for (int y2 = 0; y2 < dim; ++y2) {
                for (int x2 = y2; x2 < dim; ++x2) {
                    double[] dArray = covMx[y2];
                    int n3 = x2;
                    dArray[n3] = dArray[n3] + difVec[y2] * difVec[x2];
                }
            }
        }
        for (y = 0; y < dim; ++y) {
            for (x = y; x < dim; ++x) {
                if (y == x) continue;
                double[] dArray = covMx[y];
                int n = x;
                dArray[n] = dArray[n] / ((double)length * Math.sqrt(covMx[y][y]) * Math.sqrt(covMx[x][x]));
            }
        }
        for (int i = 0; i < dim; ++i) {
            covMx[i][i] = 1.0;
        }
        for (y = 0; y < dim; ++y) {
            for (x = y + 1; x < dim; ++x) {
                covMx[x][y] = covMx[y][x];
            }
        }
        return covMx;
    }

    public static final double[][] covariance(int[][] vec) {
        int x;
        int y;
        int dim = vec[0].length;
        double[] mean = MathVector.meanI2D(vec);
        double[] difVec = new double[dim];
        double[][] covMx = new double[dim][dim];
        for (int n = 0; n < vec.length; ++n) {
            for (int d = 0; d < dim; ++d) {
                difVec[d] = (double)vec[n][d] - mean[d];
            }
            for (int y2 = 0; y2 < dim; ++y2) {
                for (int x2 = y2; x2 < dim; ++x2) {
                    double[] dArray = covMx[y2];
                    int n2 = x2;
                    dArray[n2] = dArray[n2] + difVec[y2] * difVec[x2];
                }
            }
        }
        for (y = 0; y < dim; ++y) {
            x = y;
            while (x < dim) {
                double[] dArray = covMx[y];
                int n = x++;
                dArray[n] = dArray[n] / (double)vec.length;
            }
        }
        for (y = 0; y < dim; ++y) {
            for (x = y + 1; x < dim; ++x) {
                covMx[x][y] = covMx[y][x];
            }
        }
        return covMx;
    }

    public static final Rectangle2D.Double getBounds(double[][] data) {
        double[][] rect = new double[2][2];
        for (int xy = 0; xy < 2; ++xy) {
            rect[xy][0] = data[xy][0];
            rect[xy][1] = data[xy][0];
            for (int pn = 1; pn < data[xy].length; ++pn) {
                if (data[xy][pn] < rect[xy][0]) {
                    rect[xy][0] = data[xy][pn];
                    continue;
                }
                if (!(data[xy][pn] > rect[xy][1])) continue;
                rect[xy][1] = data[xy][pn];
            }
        }
        return new Rectangle2D.Double(rect[0][0], rect[1][0], rect[0][1] - rect[0][0], rect[1][1] - rect[1][0]);
    }

    public static final double radian(double[] vec) {
        double theta = Math.acos(vec[0] / Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1]));
        if (vec[1] < 0.0) {
            theta = Math.PI * 2 - theta;
        }
        return theta;
    }
}

