/*
 * Decompiled with CFR 0.152.
 */
import gunmetry.AnalyzePlugin;
import java.util.ArrayList;
import sos.process.NeighborFrame;
import sos.process.ROI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NuclearFormFactor
implements AnalyzePlugin {
    private ArrayList<Double> result = null;

    protected double calcFormFactor(ROI roi) {
        int width = roi.getWidth();
        int height = roi.getHeight();
        boolean[] textureCircle = new boolean[(width + 2) * (height + 2)];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                if (!roi.getMask(x + offset)) continue;
                textureCircle[x + 1 + offset + width] = true;
            }
        }
        NeighborFrame nf = new NeighborFrame(width + 2, height + 2);
        nf.set4();
        block2: for (int pn = 0; pn < textureCircle.length; ++pn) {
            if (textureCircle[pn]) continue;
            int[] neighbor = nf.getExist(pn);
            for (int n = 0; n < neighbor.length; ++n) {
                if (!textureCircle[pn + neighbor[n]]) continue;
                textureCircle[pn] = true;
                continue block2;
            }
        }
        int index = width + 2;
        while (!textureCircle[index]) {
            ++index;
        }
        int cp = index;
        int direction = -1;
        int perimeter = 0;
        nf.set8();
        block5: do {
            int[] neighbor = nf.getDir(cp);
            for (int i = 0; i < 8; ++i) {
                int cn = cp + neighbor[direction = (direction + 1) % 8];
                if (cn == cp || !textureCircle[cn]) continue;
                cp = cn;
                direction += 4;
                ++perimeter;
                continue block5;
            }
        } while (cp != index);
        return Math.PI * 4 * (double)roi.getSize() / (double)(perimeter * perimeter);
    }

    @Override
    public ArrayList<Double> analyze(ROI[] nuclei, ROI[] skiz) {
        if (this.result == null) {
            this.result = new ArrayList();
            for (int i = 0; i < nuclei.length; ++i) {
                this.result.add(this.calcFormFactor(nuclei[i]));
            }
        }
        return this.result;
    }
}

