/*
 * Decompiled with CFR 0.152.
 */
import gunmetry.ExtractMarkerPlugin;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import sos.gui.JGenericPanel;
import sos.process.Morphology;
import sos.process.ROI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDoom
implements ExtractMarkerPlugin {
    int h;
    JGenericPanel optionPanel = new JGenericPanel();

    public HDoom() {
        this.optionPanel.addNumericSpinner("min distance = ", new SpinnerNumberModel(2, 1, Integer.MAX_VALUE, 1));
        this.optionPanel.addNumericSpinner("h = ", new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
    }

    private ROI[] makeROI(int[] label, int width, int height, int nROI, int FIRST_LABEL) {
        int pn;
        int offset;
        ROI[] result = new ROI[nROI];
        for (int n = 0; n < result.length; ++n) {
            result[n] = new ROI();
        }
        int BACKGROUND = FIRST_LABEL - 1;
        for (int y = 0; y < height; ++y) {
            offset = y * width;
            for (int x = 0; x < width; ++x) {
                pn = x + offset;
                if (label[pn] <= BACKGROUND) continue;
                int index = label[pn] - FIRST_LABEL;
                result[index].expandRegion(x, y);
            }
        }
        for (int n = 0; n < result.length; ++n) {
            result[n].initMask();
            Rectangle bounds = result[n].getBounds();
            for (int y = 0; y < bounds.height; ++y) {
                offset = (y + bounds.y) * width;
                for (int x = 0; x < bounds.width; ++x) {
                    pn = x + bounds.x + offset;
                    if (label[pn] - FIRST_LABEL != n) continue;
                    result[n].setMask(x, y);
                }
            }
        }
        return result;
    }

    @Override
    public JPanel getOptionPanel() {
        return this.optionPanel;
    }

    @Override
    public ArrayList<Point> extractMarker(Morphology mo, boolean[] binaryMap) {
        int minDistance = (Integer)this.optionPanel.getSpinnerNumber(0);
        this.h = (Integer)this.optionPanel.getSpinnerNumber(1);
        int[] distanceMap = mo.geodesicDistance8(binaryMap);
        int[] distanceMarker = new int[distanceMap.length];
        for (int i = 0; i < binaryMap.length; ++i) {
            distanceMarker[i] = minDistance <= distanceMap[i] ? distanceMap[i] - this.h : distanceMap[i];
        }
        mo.reconstruct8(distanceMap, distanceMarker);
        boolean[] topMap = new boolean[distanceMap.length];
        for (int i = 0; i < binaryMap.length; ++i) {
            topMap[i] = 0 < distanceMap[i] - distanceMarker[i];
        }
        int nRegion = mo.extractRegion8(topMap, distanceMarker);
        ROI[] rois = this.makeROI(distanceMarker, mo.getWidth(), mo.getHeight(), nRegion, 0);
        ArrayList<Point> result = new ArrayList<Point>();
        for (int i = 0; i < rois.length; ++i) {
            Point2D.Double p2D = rois[i].getCentroid();
            Point p = new Point((int)Math.round(p2D.x), (int)Math.round(p2D.y));
            result.add(p);
        }
        return result;
    }
}

