/*
 * ActiveSearchMatching.java
 *
 * Created on 2005/01/31, 1:43
 */

package orch.plugin;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import orch.ImagePiece;
import sos.util.MinMaxDouble;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/02/15)
 */
public class ActiveSearchMatching extends Matching {
	
	protected Rectangle getSearchBounds(ImagePiece ipUnmove, ImagePiece ipMove, boolean isHorizontal){
		boolean reverseUnion = (ipUnmove.getIndex()<ipMove.getIndex())?false:true;
		
		Rectangle rect = ipUnmove.getBounds();
		Rectangle result = new Rectangle();
		
		double overlapRatio = 0.6;
		int range;
		if (isHorizontal){
			ipUnmove.setPartialSize(0.05,1.0-overlapRatio);
			ipMove.setPartialSize(0.05,1.0-overlapRatio);
			Rectangle partial = ipUnmove.getPartialBounds();
			
			range = (int)(overlapRatio*rect.width);
			if (reverseUnion){
				result.setLocation(0, rect.y);
			}else{
				result.setLocation(rect.x+rect.width-range, rect.y);
			}
			result.setSize(range-partial.width, rect.height-partial.height);
		}else{
			ipUnmove.setPartialSize(1.0-overlapRatio,0.05);
			ipMove.setPartialSize(1.0-overlapRatio,0.05);
			Rectangle partial = ipUnmove.getPartialBounds();
			
			range = (int)(overlapRatio*rect.height);
			if (reverseUnion){
				result.setLocation(rect.x, 0);
			}else{
				result.setLocation(rect.x, rect.y+rect.height-range);
			}
			result.setSize(rect.width-partial.width, range-partial.height);
		}
		
		return result;
	}
	
	protected void matchThreeImage(orch.ImagePiece ipUnmove, orch.ImagePiece ipMove, orch.ImagePiece ipSub, boolean isHorizontal) {
		matchTwoImage(ipUnmove,ipMove,isHorizontal);
	}
	
	protected void matchTwoImage(orch.ImagePiece ipUnmove, orch.ImagePiece ipMove, boolean isHorizontal) {
		Point p = new Point();
		int direction = 0;
		if (isHorizontal){
			if (ipUnmove.getIndex()<ipMove.getIndex()){
				direction = 1;
				p.setLocation(0,-searchBounds.height);
			}else{
				direction = 3;
			}
		}else{
			if (ipUnmove.getIndex()<ipMove.getIndex()){
				direction = 0;
				p.setLocation(-searchBounds.width,0);
			}else{
				direction = 2;
			}
		}
		int[][] reference = ipMove.getReferenceHistogram(direction);
		CollatedPoint[] best = new CollatedPoint[2];
		double maxCandidate = 0.8;
		best[0] = findBestCollatedPoint(ipUnmove, ipMove, reference[0], maxCandidate);
		maxCandidate = best[0].value;
		best[1] = findBestCollatedPoint(ipUnmove, ipMove, reference[1],maxCandidate);
		
		matchedPoint = best[0].rect.getLocation();
		if (best[0].value<best[1].value){
			matchedPoint = best[1].rect.getLocation();
			matchedPoint.x += p.x;
			matchedPoint.y += p.y;
		}
	}
	
	private CollatedPoint findBestCollatedPoint(ImagePiece ipUnmove, ImagePiece ipMove, int[] reference, double maxCandidate){
		
		// declaration
		boolean[] searched = new boolean[searchBounds.width*searchBounds.height];
		LinkedList<Rectangle> expandRegion = new LinkedList<Rectangle>();
		LinkedList<CollatedPoint> collations = new LinkedList<CollatedPoint>();
		int maxX = searchBounds.x+searchBounds.width;
		int maxY = searchBounds.y+searchBounds.height;
		Rectangle matched = null;
		
		// initialize
		ipUnmove.setPartialLocation(searchBounds.x,searchBounds.y);
		double currentSimilarity = ipUnmove.collate(reference);
		System.out.println(currentSimilarity);
		collations.add(new CollatedPoint(ipUnmove.getPartialBounds(),currentSimilarity,0));
		MinMaxDouble mmd = new MinMaxDouble();
		mmd.setInit(currentSimilarity);
		int	searchCount = 0;
		
		// main loop
		do{
			CollatedPoint cp = collations.removeFirst();
			Rectangle currentRefRect = cp.rect;
			currentSimilarity = cp.value;
			expandRegion.add(currentRefRect);
			do{
				Rectangle rect = expandRegion.removeFirst();
				for (int j=0; j<4; j++){
					int x = rect.x+dX[j];
					int y = rect.y+dY[j];
					if (!pauseFlag && searchBounds.x<=x && x<maxX && searchBounds.y<=y && y<maxY){
						int index = x-searchBounds.x+(y-searchBounds.y)*searchBounds.width;
						if(!searched[index]){
							searched[index] = true;
							ipUnmove.setPartialLocation(x,y);
							if (ipUnmove.canSkip(currentRefRect,currentSimilarity,maxCandidate)){
								expandRegion.add(ipUnmove.getPartialBounds());
							}else{
								searchCount++;
								double similarity = ipUnmove.collate(reference);
								collations.add(new CollatedPoint(ipUnmove.getPartialBounds(),similarity,index));
								if (mmd.compareMax(similarity)){
									maxCandidate = mmd.getValue();
									matched = ipUnmove.getPartialBounds();
									matchedPoint = matched.getLocation();
									drawRects(ipUnmove,ipMove,null,null,null);
								}
							}
						}
					}
				}
			}while(0<expandRegion.size());
		}while(0<collations.size());
		
		System.out.println(searchCount+"/"+searched.length);
		System.out.println("MAX="+mmd.getValue());
		
		return new CollatedPoint(matched, mmd.getValue(),0);
	}
}
