/*
 * Decompiled with CFR 0.152.
 */
package sos.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.VolatileImage;
import javax.swing.JComponent;
import sos.awt.SosCanvas;

public class JCanvas
extends JComponent
implements SosCanvas {
    private VolatileImage offScreenImage;
    private Dimension preSize = new Dimension();
    protected double deltaWidth = 0.0;
    protected double deltaHeight = 0.0;

    public void paintComponent(Graphics g) {
        if (this.offScreenImage != null) {
            g.drawImage(this.offScreenImage, 0, 0, this);
        }
    }

    public boolean createOffScreenImage() {
        try {
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.preSize.width != w || this.preSize.height != h) {
                this.deltaWidth = (double)(w - this.preSize.width) / 2.0;
                this.deltaHeight = (double)(h - this.preSize.height) / 2.0;
                this.offScreenImage = this.createVolatileImage(w, h);
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public Image getOffScreenImage() {
        return this.offScreenImage;
    }

    public Graphics getOffGraphics() {
        if (this.offScreenImage == null) {
            return null;
        }
        return this.offScreenImage.getGraphics();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.preSize.width = this.getWidth();
        this.preSize.height = this.getHeight();
        super.setBounds(x, y, width, height);
        this.createOffScreenImage();
    }

    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.setPreferredSize(new Dimension(x, y));
    }

    public void clearCanvas() {
        Graphics g = this.getOffGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public Dimension getPreSize() {
        return this.preSize;
    }
}

