/*
 * Decompiled with CFR 0.152.
 */
package sos.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.ImageIcon;

public class ImageTransform
implements Serializable {
    private static final long serialVersionUID = -1483945178505123097L;
    private ImageIcon sourceImage = new ImageIcon();
    private AffineTransform clippingTransform = new AffineTransform();
    private AffineTransform inverseTransform = null;
    private double magnification;
    private transient Dimension dest;
    private transient Point2D.Double pointAtImage;
    private transient Point2D.Double pointAtScreen;
    private transient Point2D.Double canvasCenter;
    private transient Point2D.Double screenOffset;
    private transient AffineTransform screenMx;

    public ImageTransform() {
        this.initTransient();
    }

    public ImageTransform(int width, int height, Image srcImg) {
        this.initTransient();
        this.setImage(srcImg);
        this.setDestSize(width, height);
        if (srcImg != null) {
            this.setFullSrc();
        }
    }

    public void initTransient() {
        this.dest = new Dimension();
        this.pointAtImage = new Point2D.Double();
        this.pointAtScreen = new Point2D.Double();
        this.canvasCenter = new Point2D.Double();
        this.screenOffset = new Point2D.Double();
        this.screenMx = new AffineTransform();
    }

    public void setImage(Image img) {
        if (img != null) {
            this.sourceImage.setImage(img);
        }
    }

    public void setDestSize(int width, int height) {
        this.dest.setSize(width, height);
        this.canvasCenter.x = (double)width / 2.0;
        this.canvasCenter.y = (double)height / 2.0;
    }

    public Dimension getDestSize() {
        return this.dest;
    }

    public void scaleImage(double newRatio) {
        this.scaleImage(newRatio, this.canvasCenter.x, this.canvasCenter.y);
    }

    public void scaleImage(double rate, double screenX, double screenY) {
        this.magnification *= rate;
        this.transformScreenToImage(screenX, screenY);
        this.clippingTransform.translate(this.pointAtImage.x, this.pointAtImage.y);
        this.clippingTransform.scale(rate, rate);
        this.clippingTransform.translate(-this.pointAtImage.x, -this.pointAtImage.y);
        this.inverseTransform = null;
    }

    public void locateCenter() {
        this.magnification = 1.0;
        this.clippingTransform.setToTranslation(this.canvasCenter.x - (double)this.getOriginalImageWidth() / 2.0, this.canvasCenter.y - (double)this.getOriginalImageHeight() / 2.0);
        this.screenOffset.setLocation(this.canvasCenter.x, this.canvasCenter.y);
        this.inverseTransform = null;
    }

    public void setFullSrc() {
        this.locateCenter();
        double rw = 1.0 * this.dest.getWidth() / (double)this.getOriginalImageWidth();
        double rh = 1.0 * this.dest.getHeight() / (double)this.getOriginalImageHeight();
        this.scaleImage(Math.min(rw, rh));
    }

    public int getOriginalImageWidth() {
        return this.sourceImage.getIconWidth();
    }

    public int getOriginalImageHeight() {
        return this.sourceImage.getIconHeight();
    }

    public void drawImage(Graphics g) {
        if (g != null && this.sourceImage != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(this.sourceImage.getImage(), this.clippingTransform, null);
        }
    }

    public void drawImage(Graphics g, Rectangle bounds) {
        if (g != null && this.sourceImage != null) {
            Graphics2D g2 = (Graphics2D)g;
            g.setClip(bounds);
            g2.drawImage(this.sourceImage.getImage(), this.clippingTransform, null);
        }
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double value) {
        this.magnification = value;
        this.transformScreenToImage(this.canvasCenter.x, this.canvasCenter.y);
        this.clippingTransform.setToTranslation(this.canvasCenter.x - this.pointAtImage.x, this.canvasCenter.y - this.pointAtImage.y);
        this.screenOffset.setLocation(this.pointAtImage.x, this.pointAtImage.y);
        this.scaleImage(value);
    }

    public void translateScreen(double dx, double dy) {
        this.screenMx.setToTranslation(dx, dy);
        this.clippingTransform.preConcatenate(this.screenMx);
        this.screenOffset.x += dx;
        this.screenOffset.y += dy;
        this.inverseTransform = null;
    }

    private void transformScreenToImage(double screenX, double screenY) {
        this.pointAtScreen.x = screenX;
        this.pointAtScreen.y = screenY;
        try {
            this.clippingTransform.inverseTransform(this.pointAtScreen, this.pointAtImage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Point2D inverseTransform(Point source) {
        try {
            this.clippingTransform.inverseTransform(source, this.pointAtImage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.pointAtImage;
    }

    public Shape inverseTransform(Shape src) {
        if (this.inverseTransform == null) {
            try {
                this.inverseTransform = this.clippingTransform.createInverse();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.inverseTransform.createTransformedShape(src);
    }

    public void rotateImage(double theta) {
        this.transformScreenToImage(this.canvasCenter.x, this.canvasCenter.y);
        this.clippingTransform.rotate(theta, this.pointAtImage.x, this.pointAtImage.y);
        this.inverseTransform = null;
    }

    public void deformImage(double theta, double scaleRatio) {
        this.transformScreenToImage(this.canvasCenter.x, this.canvasCenter.y);
        this.clippingTransform.translate(this.pointAtImage.x, this.pointAtImage.y);
        this.clippingTransform.scale(scaleRatio, scaleRatio);
        this.clippingTransform.rotate(theta);
        this.clippingTransform.translate(-this.pointAtImage.x, -this.pointAtImage.y);
        this.inverseTransform = null;
    }

    public Point2D.Double getScreenOffset() {
        return this.screenOffset;
    }

    public boolean hasOriginalImage() {
        return this.sourceImage.getImage() != null;
    }

    public Rectangle2D.Double getVisibleBounds() {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        this.transformScreenToImage(0.0, 0.0);
        rect.x = this.pointAtImage.x;
        rect.y = this.pointAtImage.y;
        rect.width = this.dest.getWidth() / this.magnification;
        rect.height = this.dest.getHeight() / this.magnification;
        return rect;
    }

    public Rectangle getVisibleBounds(int scale) {
        Rectangle rect = new Rectangle();
        this.transformScreenToImage(0.0, 0.0);
        rect.x = (int)((double)scale * this.pointAtImage.x);
        rect.y = (int)((double)scale * this.pointAtImage.y);
        rect.width = (int)((double)scale * this.dest.getWidth() / this.magnification);
        rect.height = (int)((double)scale * this.dest.getHeight() / this.magnification);
        return rect;
    }

    public AffineTransform getAffineTransform() {
        return this.clippingTransform;
    }

    public void calcMagnification() {
        this.magnification = this.clippingTransform.getScaleX();
    }
}

