/*
 * AnimationMaker.java
 *
 * Created on 2005/01/09, 11:06
 */

package taktstock.animation;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import sos.gui.JProgressDialog;
import sos.io.SOSFileIO;
import taktstock.CommentInfo;
import taktstock.Conductor;
import taktstock.KeyFrame;
import taktstock.TaktstockFile;
import taktstock.TaktstockViewer;

/**
 *
 * @author Gaku Tanaka
 */
public class AnimationMaker extends javax.swing.JFrame implements TableModelListener{
	static private int COLUMN_SCHEDULE = 2;
	static private int COLUMN_PAUSE = 3;
	static private int COLUMN_DURATION = 4;
	
	static private final DecimalFormat decimal = new DecimalFormat("0000");
	static private PlayListEditor playListEditor;
	
	private Conductor conductor;
	private TaktstockViewer viewer;
	private int indexOldFile = -1;
	
	private	DefaultListModel modelFileList;
	private DefaultTableModel modelPlayList;
	
	private SOSFileIO fileIO = new SOSFileIO();
	
	/** Creates new form AnimationMaker */
	public AnimationMaker(Conductor conduct, TaktstockViewer taktstockViewer) {
		this.conductor = conduct;
		this.viewer = taktstockViewer;
		initComponents();
		
		modelFileList = new DefaultListModel();
		jListAnimationFile.setModel(modelFileList);
		
		KeyFrameRenderer keyFrameRenderer = new KeyFrameRenderer();
		jTableKeyFrames.setDefaultRenderer(Object.class, keyFrameRenderer);
		
		KeyFrameEditor keyFrameEditor = new KeyFrameEditor(viewer);
		DefaultTableColumnModel columnModelFrame =(DefaultTableColumnModel)jTableKeyFrames.getColumnModel();
		columnModelFrame.getColumn(0).setPreferredWidth(10);
		columnModelFrame.getColumn(1).setCellEditor(keyFrameEditor);
		
		ListSelectionModel selectionModel = jTableKeyFrames.getSelectionModel();
		selectionModel.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				if(e.getValueIsAdjusting()){
					return;
				}
				
				int rowIndex = jTableKeyFrames.getSelectedRow();
				if (rowIndex==-1){
					return;
				}
				
				double[] matrix = (double[])jTableKeyFrames.getValueAt(rowIndex,0);
				conductor.setFrameMatrix(matrix);
				
				viewer.setCurrentComment((CommentInfo)jTableKeyFrames.getValueAt(rowIndex, 1));
				viewer.drawImage();
			}
		});
		
		jTablePlayList.setDefaultRenderer(Object.class, new PlayListRenderer(jListAnimationFile));
		DefaultTableColumnModel columnModelPlayList =(DefaultTableColumnModel)jTablePlayList.getColumnModel();
		playListEditor = new PlayListEditor();
		columnModelPlayList.getColumn(3).setCellEditor(playListEditor);
		columnModelPlayList.getColumn(4).setCellEditor(playListEditor);
		
		modelPlayList = (DefaultTableModel)jTablePlayList.getModel();
		modelPlayList.addTableModelListener(this);
		
		SpinnerNumberModel fpsModel = new SpinnerNumberModel(15,1,60,1);
		jSpinnerFrameRate.setModel(fpsModel);
		jDialogExport.pack();
	}
	
	public void getPlayList(ArrayList<KeyFrame> keyFrameArray){
		if (modelPlayList.getRowCount()==0){
			selectionsToPlayList();
		}
		if (modelPlayList.getRowCount()<=1){
			return;
		}
		
		playListEditor.stopCellEditing();
		keyFrameArray.clear();
		
		int indexFile, indexFrame;
		for (int i=0; i<modelPlayList.getRowCount(); i++){
			indexFile = (Integer)modelPlayList.getValueAt(i,0);
			TaktstockFile file = (TaktstockFile)modelFileList.getElementAt(indexFile);
			
			indexFrame = (Integer)modelPlayList.getValueAt(i,1);
			boolean pause = (Boolean)modelPlayList.getValueAt(i,3);
			int time = (Integer)modelPlayList.getValueAt(i,4);
			boolean showComment = (Boolean)modelPlayList.getValueAt(i,5);
			KeyFrame keyFrame = new KeyFrame(file,indexFrame,pause,time,showComment);
			keyFrameArray.add(keyFrame);
		}
		
		for (int i=0; i<keyFrameArray.size()-1; i++){
			keyFrameArray.get(i).setNextFrame(keyFrameArray.get(i+1));
		}
	}
	
	private void selectionsToPlayList(){
		int[] selection = jTableKeyFrames.getSelectedRows();
		if (selection.length==0){
			int rowCount = jTableKeyFrames.getRowCount();
			if (rowCount==0){
				return;
			}else{
				jTableKeyFrames.setRowSelectionInterval(0,rowCount-1);
				selection = jTableKeyFrames.getSelectedRows();
			}
		}
		
		int indexFile = jListAnimationFile.getSelectedIndex();
		for (int i=0; i<selection.length; i++){
			addPlayList(indexFile,selection[i]);
		}
		
		jTableKeyFrames.clearSelection();
	}
	
	public void addFile(File file, int samplingRate){
		// for animation
		int index = -1;
		for (int i=0; i<modelFileList.getSize(); i++){
			TaktstockFile taktstockFile = (TaktstockFile)modelFileList.getElementAt(i);
			if (taktstockFile.getFile().equals(file)){
				index = i;
				break;
			}
		}
		
		if (-1==index){
			TaktstockFile taktstockFile = new TaktstockFile(file,samplingRate);
			modelFileList.addElement(taktstockFile);
			jListAnimationFile.setSelectedIndex(modelFileList.getSize()-1);
		}else{
			jListAnimationFile.setSelectedIndex(index);
		}
	}
	
	private void addPlayList(int indexFile, int indexFrame){
		if (indexFile==-1 || indexFrame==-1){
			return;
		}
		
		int rowIndex = modelPlayList.getRowCount()-1;
		long schedule = 0L;
		if (0<=rowIndex){
			long preDuration = (Integer)modelPlayList.getValueAt(rowIndex, COLUMN_DURATION);
			if (preDuration == 0){
				modelPlayList.setValueAt(3000, rowIndex,COLUMN_DURATION);
			}
			if (!(Boolean)modelPlayList.getValueAt(rowIndex,COLUMN_PAUSE)){
				schedule = sumTime(rowIndex);
			}
		}
		
		Object[] playListItem = new Object[6];
		playListItem[0] = indexFile;
		playListItem[1] = indexFrame;
		playListItem[2] = schedule;
		playListItem[3] = false;
		playListItem[4] = 0;
		playListItem[5] = true;
		
		modelPlayList.addRow(playListItem);
	}
	
	private void addPlayList(String[] str){
		modelPlayList.setRowCount(0);
		
		Object[] playListItem = new Object[6];
		playListItem[0] = Integer.valueOf(str[0]);
		playListItem[1] = Integer.valueOf(str[1]);
		playListItem[2] = Long.valueOf(str[2]);
		playListItem[3] = Boolean.valueOf(str[3]);
		playListItem[4] = Integer.valueOf(str[4]);
		playListItem[5] = Boolean.valueOf(str[5]);
		
		modelPlayList.addRow(playListItem);
	}
	
	private long sumTime(int rowIndex){
		long result = (Integer)modelPlayList.getValueAt(rowIndex,COLUMN_DURATION);
		result += (Long)modelPlayList.getValueAt(rowIndex,COLUMN_SCHEDULE);
		
		return result;
	}
	
	public void tableChanged(TableModelEvent evt) {
		
		if (evt.getType()==TableModelEvent.UPDATE){
			int row = evt.getFirstRow();
			int column = evt.getColumn();
			
			if (column==COLUMN_SCHEDULE || column==COLUMN_DURATION){
				int rowCount = modelPlayList.getRowCount();
				if (row<rowCount-1){
					long value = sumTime(row);
					modelPlayList.setValueAt(value, row+1, COLUMN_SCHEDULE);
				}
			}
		}
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jDialogExport = new javax.swing.JDialog();
        jLabel1 = new javax.swing.JLabel();
        jTextExportDir = new javax.swing.JTextField();
        jButtonSelectExprotDir = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jTextExportFileName = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jSpinnerFrameRate = new javax.swing.JSpinner();
        jLabel4 = new javax.swing.JLabel();
        jComboBox1 = new javax.swing.JComboBox();
        jPanel1 = new javax.swing.JPanel();
        jButtonExport = new javax.swing.JButton();
        jButtonCancelExport = new javax.swing.JButton();
        jPanelFrame = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTableKeyFrames = new javax.swing.JTable();
        jPanelFrameButton = new javax.swing.JPanel();
        jButtonAddFrame = new javax.swing.JButton();
        jButtonRemoveFrame = new javax.swing.JButton();
        jButtonToPlayList = new javax.swing.JButton();
        jListAnimationFile = new javax.swing.JList();
        jPanelPlayList = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTablePlayList = new javax.swing.JTable();
        jPanelPlayListButton = new javax.swing.JPanel();
        jButtonRemovePlayList = new javax.swing.JButton();
        jButtonClearPlayList = new javax.swing.JButton();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuOpenPlayList = new javax.swing.JMenuItem();
        jMenuSavePlayList = new javax.swing.JMenuItem();
        jMenuExport = new javax.swing.JMenuItem();

        jDialogExport.getContentPane().setLayout(new java.awt.GridBagLayout());

        jDialogExport.setTitle("Export");
        jLabel1.setText("Directory: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jDialogExport.getContentPane().add(jLabel1, gridBagConstraints);

        jTextExportDir.setPreferredSize(new java.awt.Dimension(200, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        jDialogExport.getContentPane().add(jTextExportDir, gridBagConstraints);

        jButtonSelectExprotDir.setText("Select");
        jButtonSelectExprotDir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSelectExprotDirActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        jDialogExport.getContentPane().add(jButtonSelectExprotDir, gridBagConstraints);

        jLabel2.setText("FileName: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jDialogExport.getContentPane().add(jLabel2, gridBagConstraints);

        jTextExportFileName.setText("images");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jDialogExport.getContentPane().add(jTextExportFileName, gridBagConstraints);

        jLabel3.setText("FrameRate: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jDialogExport.getContentPane().add(jLabel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jDialogExport.getContentPane().add(jSpinnerFrameRate, gridBagConstraints);

        jLabel4.setText("FileType: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jDialogExport.getContentPane().add(jLabel4, gridBagConstraints);

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "jpeg", "bmp" }));
        jComboBox1.setPreferredSize(new java.awt.Dimension(70, 23));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jDialogExport.getContentPane().add(jComboBox1, gridBagConstraints);

        jButtonExport.setText("Export");
        jButtonExport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonExportActionPerformed(evt);
            }
        });

        jPanel1.add(jButtonExport);

        jButtonCancelExport.setText("Cancel");
        jButtonCancelExport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelExportActionPerformed(evt);
            }
        });

        jPanel1.add(jButtonCancelExport);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jDialogExport.getContentPane().add(jPanel1, gridBagConstraints);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("TAKTSTOCK ANIMATION");
        jPanelFrame.setLayout(new java.awt.BorderLayout());

        jPanelFrame.setBackground(new java.awt.Color(230, 230, 255));
        jPanelFrame.setBorder(new javax.swing.border.TitledBorder("Key Frames"));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(150, 200));
        jTableKeyFrames.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "NO", "COMMENTS"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, true
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableKeyFrames.setAutoCreateColumnsFromModel(false);
        jScrollPane1.setViewportView(jTableKeyFrames);

        jPanelFrame.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanelFrameButton.setLayout(new java.awt.GridBagLayout());

        jPanelFrameButton.setOpaque(false);
        jButtonAddFrame.setForeground(java.awt.Color.gray);
        jButtonAddFrame.setText("ADD");
        jButtonAddFrame.setFocusPainted(false);
        jButtonAddFrame.setFocusable(false);
        jButtonAddFrame.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddFrameActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 2);
        jPanelFrameButton.add(jButtonAddFrame, gridBagConstraints);

        jButtonRemoveFrame.setForeground(java.awt.Color.gray);
        jButtonRemoveFrame.setText("REMOVE");
        jButtonRemoveFrame.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRemoveFrameActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanelFrameButton.add(jButtonRemoveFrame, gridBagConstraints);

        jButtonToPlayList.setForeground(java.awt.Color.gray);
        jButtonToPlayList.setText("To PlayList");
        jButtonToPlayList.setFocusPainted(false);
        jButtonToPlayList.setFocusable(false);
        jButtonToPlayList.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonToPlayListActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 5, 0);
        jPanelFrameButton.add(jButtonToPlayList, gridBagConstraints);

        jPanelFrame.add(jPanelFrameButton, java.awt.BorderLayout.NORTH);

        getContentPane().add(jPanelFrame, java.awt.BorderLayout.CENTER);

        jListAnimationFile.setBackground(new java.awt.Color(230, 230, 255));
        jListAnimationFile.setBorder(new javax.swing.border.TitledBorder("File List"));
        jListAnimationFile.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jListAnimationFile.setMinimumSize(new java.awt.Dimension(50, 0));
        jListAnimationFile.setPreferredSize(new java.awt.Dimension(100, 0));
        jListAnimationFile.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListAnimationFileValueChanged(evt);
            }
        });

        getContentPane().add(jListAnimationFile, java.awt.BorderLayout.WEST);

        jPanelPlayList.setLayout(new java.awt.BorderLayout());

        jPanelPlayList.setBorder(new javax.swing.border.TitledBorder("Play List"));
        jScrollPane2.setPreferredSize(new java.awt.Dimension(500, 200));
        jTablePlayList.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "FILE", "FRAME", "SCHEDULE", "PAUSE", "DURATION", "COMMENT"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Object.class, java.lang.Object.class, java.lang.Object.class, java.lang.Object.class, java.lang.Object.class, java.lang.Boolean.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, true, true, true
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane2.setViewportView(jTablePlayList);

        jPanelPlayList.add(jScrollPane2, java.awt.BorderLayout.EAST);

        jButtonRemovePlayList.setText("REMOVE");
        jButtonRemovePlayList.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRemovePlayListActionPerformed(evt);
            }
        });

        jPanelPlayListButton.add(jButtonRemovePlayList);

        jButtonClearPlayList.setText("CLEAR");
        jButtonClearPlayList.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonClearPlayListActionPerformed(evt);
            }
        });

        jPanelPlayListButton.add(jButtonClearPlayList);

        jPanelPlayList.add(jPanelPlayListButton, java.awt.BorderLayout.NORTH);

        getContentPane().add(jPanelPlayList, java.awt.BorderLayout.EAST);

        jMenuFile.setText("File");
        jMenuOpenPlayList.setText("Open PlayList");
        jMenuOpenPlayList.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuOpenPlayListActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuOpenPlayList);

        jMenuSavePlayList.setText("Save PlayList");
        jMenuSavePlayList.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSavePlayListActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuSavePlayList);

        jMenuExport.setText("Export");
        jMenuExport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuExportActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuExport);

        jMenuBar1.add(jMenuFile);

        setJMenuBar(jMenuBar1);

        pack();
    }//GEN-END:initComponents
	
	private void jButtonClearPlayListActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonClearPlayListActionPerformed
		modelPlayList.setRowCount(0);
	}//GEN-LAST:event_jButtonClearPlayListActionPerformed
	
	private void jButtonRemovePlayListActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRemovePlayListActionPerformed
		int index = jTablePlayList.getSelectedRow();
		if (-1<index){
			modelPlayList.removeRow(index);
		}
	}//GEN-LAST:event_jButtonRemovePlayListActionPerformed
	
	private void jButtonSelectExprotDirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSelectExprotDirActionPerformed
		File export = fileIO.getSaveDirectory();
		jTextExportDir.setText(export.getPath());
	}//GEN-LAST:event_jButtonSelectExprotDirActionPerformed
	
	private void jButtonCancelExportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelExportActionPerformed
		jDialogExport.setVisible(false);
	}//GEN-LAST:event_jButtonCancelExportActionPerformed
	
	private void jButtonExportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonExportActionPerformed
		conductor.setPlayList();
		
		String parent = jTextExportDir.getText()+System.getProperty("file.separator")+jTextExportFileName.getText();
		
		int frameRate = (Integer)jSpinnerFrameRate.getValue();
		int deltaTime = 1000/frameRate;
		long totalTime = (Long)modelPlayList.getValueAt(modelPlayList.getRowCount()-1, 2);
		int cycle = (int)(totalTime/deltaTime);
		
		long elapsedTime = 0L;
		File exportFile;
		JProgressDialog progress = new JProgressDialog(this);
		progress.start("Saving the result image...", false);
		for (int i=0; i<=cycle; i++){
			exportFile = new File(parent+decimal.format(i+1)+".jpg");
			conductor.processFrame(elapsedTime);
			conductor.saveFineImage(exportFile);
			elapsedTime += deltaTime;
			progress.setValue(100*i/cycle);
		}
		progress.stop();
		jDialogExport.setVisible(false);
	}//GEN-LAST:event_jButtonExportActionPerformed
	
	private void jMenuExportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuExportActionPerformed
		jDialogExport.setVisible(true);
	}//GEN-LAST:event_jMenuExportActionPerformed
	
	private void jMenuSavePlayListActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSavePlayListActionPerformed
		if (modelPlayList.getRowCount()==0){
			return;
		}
		File f = fileIO.getSaveFile();
		if (f==null){
			return;
		}
		
		String[] data = new String[modelFileList.getSize()+modelPlayList.getRowCount()+1];
		// write file list
		data[0] = Integer.toString(modelFileList.getSize());
		for (int i=0; i<modelFileList.getSize(); i++){
			TaktstockFile taktstockFile = (TaktstockFile)modelFileList.get(i);
			data[i+1] = taktstockFile.toString();
		}
		// write play list
		for (int y=0; y<modelPlayList.getRowCount(); y++){
			StringBuffer str = new StringBuffer(modelPlayList.getValueAt(y,0).toString());
			for (int x=1; x<modelPlayList.getColumnCount(); x++){
				str.append(",");
				str.append(modelPlayList.getValueAt(y,x));
			}
			data[y+1+modelFileList.getSize()] = str.toString();
		}
		SOSFileIO.writeStrings(f, data);
		
	}//GEN-LAST:event_jMenuSavePlayListActionPerformed
	
	private void jMenuOpenPlayListActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuOpenPlayListActionPerformed
		File f = fileIO.getOpenFile();
		if (f==null){
			return;
		}
		ArrayList<String> arg = SOSFileIO.readStrings(f);
		int nFileList = Integer.parseInt(arg.get(0))+1;
		
		String parent = f.getParent()+System.getProperty("file.separator");
		for (int i=1; i<nFileList; i++){
			File file = new File(parent+arg.get(i));
			addFile(file,viewer.getSamplingRate());
		}
		jListAnimationFile.setSelectedIndex(0);
		
		modelPlayList.setRowCount(0);
		for (int i=nFileList; i<arg.size(); i++){
			String[] items = arg.get(i).split(",");
			addPlayList(items);
		}
	}//GEN-LAST:event_jMenuOpenPlayListActionPerformed
	
	private void jButtonRemoveFrameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRemoveFrameActionPerformed
		int index = jTableKeyFrames.getSelectedRow();
		if (-1<index){
			DefaultTableModel modelKeyFrame = (DefaultTableModel)jTableKeyFrames.getModel();
			modelKeyFrame.removeRow(index);
		}
	}//GEN-LAST:event_jButtonRemoveFrameActionPerformed
	
	private void jListAnimationFileValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListAnimationFileValueChanged
		int indexSelected = jListAnimationFile.getSelectedIndex();
		if (indexOldFile!=indexSelected && indexSelected!=-1){
			TaktstockFile selectedFile = (TaktstockFile)jListAnimationFile.getSelectedValue();
			selectedFile.copyTableModel(jTableKeyFrames);
			
			conductor.setCurrentTaktstockFile(selectedFile);
			conductor.loadThumbnail();
			viewer.fitImageToCanvas();
			
			indexOldFile = indexSelected;
		}
	}//GEN-LAST:event_jListAnimationFileValueChanged
	
	private void jButtonToPlayListActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonToPlayListActionPerformed
		
		selectionsToPlayList();
	}//GEN-LAST:event_jButtonToPlayListActionPerformed
	
	private void jButtonAddFrameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddFrameActionPerformed
		if (jListAnimationFile.getSelectedIndex()==-1){
			return;
		}
		
		Object[] rowData = new Object[2];
		rowData[0] = conductor.getTransformMatrix();
		rowData[1] = new CommentInfo();
		DefaultTableModel modelKeyFrame = (DefaultTableModel)jTableKeyFrames.getModel();
		modelKeyFrame.addRow(rowData);
		
	}//GEN-LAST:event_jButtonAddFrameActionPerformed
	
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAddFrame;
    private javax.swing.JButton jButtonCancelExport;
    private javax.swing.JButton jButtonClearPlayList;
    private javax.swing.JButton jButtonExport;
    private javax.swing.JButton jButtonRemoveFrame;
    private javax.swing.JButton jButtonRemovePlayList;
    private javax.swing.JButton jButtonSelectExprotDir;
    private javax.swing.JButton jButtonToPlayList;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JDialog jDialogExport;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JList jListAnimationFile;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuExport;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenuItem jMenuOpenPlayList;
    private javax.swing.JMenuItem jMenuSavePlayList;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanelFrame;
    private javax.swing.JPanel jPanelFrameButton;
    private javax.swing.JPanel jPanelPlayList;
    private javax.swing.JPanel jPanelPlayListButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSpinner jSpinnerFrameRate;
    private javax.swing.JTable jTableKeyFrames;
    private javax.swing.JTable jTablePlayList;
    private javax.swing.JTextField jTextExportDir;
    private javax.swing.JTextField jTextExportFileName;
    // ϐ錾̏I//GEN-END:variables
	
}
