/*
 * KeyFrame.java
 *
 * Created on 2005/01/01, 15:23
 */

package taktstock;

import java.awt.Graphics2D;
import java.io.File;
import java.util.Vector;

/**
 *
 * @author Gaku Tanaka
 */
public class KeyFrame{
	static private double[] synMatrix = new double[6];
	
	private double[] matrix;
	private long duration;
	private boolean pauseFrame;
	private CommentInfo comment;
	
	private TaktstockFile taktstockFile;
	private long startTime;
	private KeyFrame prevFrame;
	private KeyFrame nextFrame;
	private boolean showComment;
	private boolean stillFrame;
	
	/** Creates a new instance of KeyFrame */
	public KeyFrame(TaktstockFile file, int indexFrame, boolean pause, long time, boolean showComment) {
		taktstockFile = file;
		
		Vector data = file.getData(indexFrame);
		matrix = (double[])data.get(0);
		comment = (CommentInfo)data.get(1);
		
		duration = time;
		pauseFrame = pause;
		this.showComment = showComment;
	}
	
	public void setNextFrame(KeyFrame keyFrame){
	
		nextFrame = keyFrame;
		
		if (!getFile().equals(nextFrame.getFile())){
			nextFrame.startTime = 0L;
			stillFrame = true;
		}else{
			if (nextFrame.pauseFrame){
				nextFrame.startTime = 0L;
			}else{
				nextFrame.startTime = startTime+duration;
			}
		}
		
		keyFrame.prevFrame = this;
	}
	
	public KeyFrame getNextFrame(){
		if (nextFrame==null){
			return this;
		}
		return nextFrame;
	}
	
	public KeyFrame getPrevFrame(){
		if (prevFrame==null){
			return this;
		}
		return prevFrame;
	}
	
	public double[] transform(long time){
		if (isStillFrame()){
			return matrix;
		}
		
		double ratio = 1.0*(time-startTime)/duration;
		for (int i=0; i<6; i++){
			synMatrix[i] = (1.0-ratio)*matrix[i] + ratio*(getNextFrame().matrix[i]);
		}
		
		return synMatrix;
	}
	
	public long getEndTime(){
		if (nextFrame==null){
			return startTime;
		}
		return startTime+duration;
	}
	
	public boolean isPauseFrame(){
		return pauseFrame;
	}
	
	public void drawComment(Graphics2D g){
		comment.draw(g);
	}
	
	public TaktstockFile getTaktstockFile(){
		return taktstockFile;
	}
	
	public File getFile(){
		return taktstockFile.getFile();
	}
	
	public CommentInfo getComment(){
		return comment;
	}
	
	public boolean isShowComment(){
		return showComment;
	}
	
	public long getStartTime(){
		return startTime;
	}

	public boolean isStillFrame() {
		return stillFrame;
	}

}
