/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class PointRect {
    private int rectSize = 5;
    private int halfSize = 2;
    public int label = -1;
    private Point point;
    private Rectangle rect;

    public PointRect(int x, int y) {
        this.point = new Point(x, y);
        this.rect = new Rectangle(x - this.halfSize, y - this.halfSize, this.rectSize, this.rectSize);
    }

    public PointRect(int x, int y, int size) {
        this.point = new Point(x, y);
        this.rectSize = size;
        this.halfSize = this.rectSize / 2;
        this.rect = new Rectangle(x - this.halfSize, y - this.halfSize, this.rectSize, this.rectSize);
    }

    public PointRect(Point p, int size) {
        this.point = p;
        this.rectSize = size;
        this.halfSize = this.rectSize / 2;
        this.rect = new Rectangle(this.point.x - this.halfSize, this.point.y - this.halfSize, this.rectSize, this.rectSize);
    }

    public void setSize(int value) {
        this.rectSize = value;
        this.halfSize = value / 2;
        this.rect.setBounds(this.point.x - this.halfSize, this.point.y - this.halfSize, this.rectSize, this.rectSize);
    }

    public void setLocation(int x, int y) {
        this.point.setLocation(x, y);
        this.rect.setLocation(x - this.halfSize, y - this.halfSize);
    }

    public Point getLocation() {
        return this.point;
    }

    public boolean contains(int x, int y) {
        return this.rect.contains(x, y);
    }

    public boolean contains(Point2D p) {
        return this.rect.contains(p);
    }

    public void drawRect(Graphics g) {
        g.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
    }

    public void fillRect(Graphics g) {
        g.fillRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
    }

    public int getX() {
        return this.point.x;
    }

    public int getY() {
        return this.point.y;
    }

    public Rectangle getBounds() {
        return this.rect;
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.rect);
    }
}

