/*
 * Decompiled with CFR 0.152.
 */
package taktstock.animation;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import taktstock.TaktstockFile;

public class PlayListRenderer
implements TableCellRenderer {
    private static DecimalFormat decimal = new DecimalFormat("00");
    private DefaultListModel listModel;
    private Color selectedColor = new Color(255, 230, 210);
    private Color uneditableColor = new Color(230, 230, 230);
    private JCheckBox jCheckBox;
    private JLabel jLabel;

    public PlayListRenderer(JList list) {
        this.listModel = (DefaultListModel)list.getModel();
        this.initComponents();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent component = null;
        if (obj != null) {
            this.jLabel.setHorizontalAlignment(10);
            switch (column) {
                case 0: {
                    int index = (Integer)obj;
                    TaktstockFile file = (TaktstockFile)this.listModel.getElementAt(index);
                    this.jLabel.setText(file.getFile().getName());
                    component = this.jLabel;
                    break;
                }
                case 1: {
                    int index = (Integer)obj;
                    this.jLabel.setText(Integer.toString(index + 1));
                    component = this.jLabel;
                    break;
                }
                case 2: {
                    int sec = ((Long)obj).intValue() / 1000;
                    int min = sec / 60;
                    int hour = min / 60;
                    this.jLabel.setText(decimal.format(hour) + ":" + decimal.format(min) + ":" + decimal.format(sec));
                    this.jLabel.setHorizontalAlignment(11);
                    component = this.jLabel;
                    break;
                }
                case 3: {
                    if (row >= jTable.getRowCount() - 1) break;
                    this.jCheckBox.setSelected((Boolean)obj);
                    component = this.jCheckBox;
                    break;
                }
                case 4: {
                    if (row >= jTable.getRowCount() - 1) break;
                    int time = (Integer)obj;
                    this.jLabel.setText(Integer.toString(time));
                    this.jLabel.setHorizontalAlignment(11);
                    component = this.jLabel;
                }
            }
            if (component != null) {
                if (isSelected) {
                    component.setBackground(this.selectedColor);
                    component.setOpaque(true);
                } else {
                    component.setOpaque(false);
                }
            }
        }
        return component;
    }

    private void initComponents() {
        this.jLabel = new JLabel();
        this.jCheckBox = new JCheckBox();
        this.jLabel.setText("jLabel1");
        this.jLabel.setOpaque(true);
        this.jCheckBox.setHorizontalAlignment(0);
    }
}

