/*
 * Decompiled with CFR 0.152.
 */
package taktstock.animation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import taktstock.CommentInfo;
import taktstock.TaktstockViewer;

public class KeyFrameEditor
extends AbstractCellEditor
implements TableCellEditor {
    private TaktstockViewer viewer;
    private CommentInfo currentCommentInfo;
    protected static final String EDIT = "edit";
    private JButton jButton;
    private JComboBox jComboFont;
    private JComboBox jComboStyle;
    private JDialog jDialog;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelColor;
    private JLabel jLabelColorString;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerSize;
    private JTextArea jTextAreaComment;

    public KeyFrameEditor() {
    }

    public KeyFrameEditor(TaktstockViewer viewer) {
        this.viewer = viewer;
        this.initComponents();
        this.jButton.setActionCommand(EDIT);
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fonts.length; ++i) {
            this.jComboFont.addItem(fonts[i]);
        }
        this.jDialog.pack();
    }

    public Object getCellEditorValue() {
        return this.currentCommentInfo;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (this.jDialog.isVisible()) {
            this.fireEditingStopped();
        }
        Point p = MouseInfo.getPointerInfo().getLocation();
        this.jDialog.setLocation(p.x + 5, p.y + 5);
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object obj, boolean param, int param3, int param4) {
        this.currentCommentInfo = (CommentInfo)obj;
        return this.jButton;
    }

    private void setTextColor(Color color) {
        if (color != null) {
            this.currentCommentInfo.setColor(color);
            this.jLabelColor.setBackground(color);
            this.jLabelColorString.setText("[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]");
            this.viewer.updateCanvas();
        }
    }

    private void initComponents() {
        this.jDialog = new JDialog();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboFont = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jComboStyle = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jSpinnerSize = new JSpinner();
        this.jLabelColor = new JLabel();
        this.jLabelColorString = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jButton = new JButton();
        this.jDialog.getContentPane().setLayout(new GridBagLayout());
        this.jDialog.setTitle("Text property editor");
        this.jDialog.setAlwaysOnTop(true);
        this.jDialog.setModal(false);
        this.jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                KeyFrameEditor.this.jDialogWindowClosing(evt);
            }
        });
        this.jLabel4.setText("Color:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jDialog.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel3.setText("Font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jDialog.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jComboFont.setPreferredSize(new Dimension(200, 24));
        this.jComboFont.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                KeyFrameEditor.this.jComboFontItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jDialog.getContentPane().add((Component)this.jComboFont, gridBagConstraints);
        this.jLabel1.setText("Style:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jDialog.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jComboStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"PLAIN", "BOLD", "ITALIC", "BOLD+ITALIC"}));
        this.jComboStyle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                KeyFrameEditor.this.jComboStyleItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.jDialog.getContentPane().add((Component)this.jComboStyle, gridBagConstraints);
        this.jLabel2.setText(" Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jDialog.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jSpinnerSize.setPreferredSize(new Dimension(50, 20));
        this.jSpinnerSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                KeyFrameEditor.this.jSpinnerSizeStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jDialog.getContentPane().add((Component)this.jSpinnerSize, gridBagConstraints);
        this.jLabelColor.setBackground(new Color(0, 0, 0));
        this.jLabelColor.setEnabled(false);
        this.jLabelColor.setOpaque(true);
        this.jLabelColor.setPreferredSize(new Dimension(15, 15));
        this.jLabelColor.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                KeyFrameEditor.this.jLabelColorMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.jDialog.getContentPane().add((Component)this.jLabelColor, gridBagConstraints);
        this.jLabelColorString.setText("[0,0,0]");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.jDialog.getContentPane().add((Component)this.jLabelColorString, gridBagConstraints);
        this.jTextAreaComment.setRows(5);
        this.jTextAreaComment.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                KeyFrameEditor.this.jTextAreaCommentKeyReleased(evt);
            }
        });
        this.jTextAreaComment.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                KeyFrameEditor.this.jTextAreaCommentMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.jDialog.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton.setBorderPainted(false);
        this.jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KeyFrameEditor.this.jButtonActionPerformed(evt);
            }
        });
    }

    private void jTextAreaCommentKeyReleased(KeyEvent evt) {
        this.currentCommentInfo.setText(this.jTextAreaComment.getText());
        this.viewer.updateCanvas();
    }

    private void jDialogWindowClosing(WindowEvent evt) {
        this.viewer.setEditingComment(false);
        this.jDialog.setVisible(false);
        this.fireEditingStopped();
    }

    private void jButtonActionPerformed(ActionEvent evt) {
        if (EDIT.equals(evt.getActionCommand())) {
            this.viewer.setCurrentComment(this.currentCommentInfo);
            this.viewer.setEditingComment(true);
            this.jTextAreaComment.setText(this.currentCommentInfo.getText());
            this.jComboFont.setSelectedItem(this.currentCommentInfo.getFontName());
            this.jComboStyle.setSelectedIndex(this.currentCommentInfo.getFontStyle());
            this.jSpinnerSize.setValue(this.currentCommentInfo.getFontSize());
            this.setTextColor(this.currentCommentInfo.getColor());
            this.jDialog.setVisible(true);
        }
    }

    private void jTextAreaCommentMouseReleased(MouseEvent evt) {
    }

    private void jComboStyleItemStateChanged(ItemEvent evt) {
        if (this.currentCommentInfo != null) {
            int fontStyle = this.jComboStyle.getSelectedIndex();
            this.currentCommentInfo.setFontStyle(fontStyle);
            this.viewer.updateCanvas();
        }
    }

    private void jComboFontItemStateChanged(ItemEvent evt) {
        if (this.currentCommentInfo != null) {
            String fontName = (String)this.jComboFont.getSelectedItem();
            this.currentCommentInfo.setFontName(fontName);
            this.viewer.updateCanvas();
        }
    }

    private void jLabelColorMousePressed(MouseEvent evt) {
        Color color = JColorChooser.showDialog(this.jDialog, "Color for the text", this.jLabelColor.getBackground());
        if (color != null) {
            this.setTextColor(color);
        }
    }

    private void jSpinnerSizeStateChanged(ChangeEvent evt) {
        if (this.currentCommentInfo != null) {
            int fontSize = (Integer)this.jSpinnerSize.getValue();
            this.currentCommentInfo.setFontSize(fontSize);
            this.viewer.updateCanvas();
        }
    }
}

