/*
 * Decompiled with CFR 0.152.
 */
package taktstock;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sos.awt.ImageTransform;
import sos.awt.JImageCanvas;
import sos.io.SOSFileIO;
import taktstock.CommentInfo;
import taktstock.Conductor;

public class TaktstockViewer
extends JFrame {
    private GraphicsDevice device;
    private ArrayList<Integer> displayModeIndex = new ArrayList();
    private Conductor conductor;
    private AffineTransform screenTransform = new AffineTransform();
    private AffineTransform fineTransform = new AffineTransform();
    private CommentInfo currentComment = null;
    private TimerTask taskFps;
    private Timer timerFps = null;
    private int fps = 15;
    private int frameCount;
    private int oldX;
    private int oldY;
    private SOSFileIO fileIO = new SOSFileIO();
    private boolean editingComment = false;
    private ButtonGroup buttonGroupPlayMode;
    private JButton jButtonFitImage;
    private JButton jButtonFullScreen;
    private JButton jButtonPlayAnimation;
    private JButton jButtonSetCanvasSize;
    private JImageCanvas jCanvasMain;
    private JCheckBox jCheckAdaptCanvasSize;
    private JCheckBox jCheckFullScreen;
    private JCheckBox jCheckShowFps;
    private JComboBox jComboMode;
    private JFrame jFrameFullScreen;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelFps;
    private JLabel jLabelImageHeight;
    private JLabel jLabelImageWidth;
    private JLabel jLabelThumbnailHeight;
    private JLabel jLabelThumbnailWidth;
    private JMenuBar jMenuBarFile;
    private JMenu jMenuFile;
    private JMenuItem jMenuItemMakeAnimation;
    private JMenuItem jMenuItemOpen;
    private JMenuItem jMenuItemSave;
    private JMenu jMenuWindow;
    private JPanel jPanelSettings;
    private JPanel jPanelStatus;
    private JPanel jPanelSub;
    private JSpinner jSpinnerCanvasHeight;
    private JSpinner jSpinnerCanvasWidth;
    private JSpinner jSpinnerThumbnail;

    public TaktstockViewer(Conductor conductor) {
        this.initComponents();
        this.setupGraphics();
        this.setupKeyInput();
        SpinnerNumberModel subsampleModel = new SpinnerNumberModel(4, 1, 100, 1);
        this.jSpinnerThumbnail.setModel(subsampleModel);
        this.pack();
        this.jFrameFullScreen.setTitle(this.getTitle());
        this.conductor = conductor;
    }

    private void setupGraphics() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.device = ge.getDefaultScreenDevice();
        DisplayMode[] modes = this.device.getDisplayModes();
        DisplayMode mode = this.device.getDisplayMode();
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i].getBitDepth() != mode.getBitDepth()) continue;
            this.jComboMode.addItem(modes[i].getWidth() + " x " + modes[i].getHeight());
            this.displayModeIndex.add(i);
            if (modes[i].equals(mode)) break;
        }
        this.jComboMode.setSelectedIndex(this.displayModeIndex.size() - 1);
    }

    private void setupKeyInput() {
        KeyboardFocusManager keyboardManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardManager.addKeyEventPostProcessor(new KeyEventPostProcessor(){

            public boolean postProcessKeyEvent(KeyEvent evt) {
                switch (evt.getID()) {
                    case 401: {
                        int keyCode = evt.getKeyCode();
                        if (keyCode == 34 || keyCode == 40) {
                            TaktstockViewer.this.conductor.resumeAnimation();
                            break;
                        }
                        if (keyCode != 33 && keyCode != 38) break;
                        TaktstockViewer.this.conductor.rewindAnimation();
                        break;
                    }
                    case 402: {
                        break;
                    }
                }
                return false;
            }
        });
    }

    private void createFpsTask() {
        this.taskFps = new TimerTask(){

            public void run() {
                TaktstockViewer.this.jLabelFps.setText(TaktstockViewer.this.frameCount + " FPS");
                TaktstockViewer.this.frameCount = 0;
            }
        };
    }

    public void updateCanvas() {
        this.jCanvasMain.paintImmediately(0, 0, this.jCanvasMain.getWidth(), this.jCanvasMain.getHeight());
        if (this.currentComment != null) {
            Graphics2D g = (Graphics2D)this.jCanvasMain.getGraphics();
            this.currentComment.draw(g);
        }
    }

    public void drawThumbnail() {
        this.jCanvasMain.clearCanvas();
        this.jCanvasMain.drawImage();
        this.updateCanvas();
        if (this.jCheckShowFps.isSelected()) {
            ++this.frameCount;
        }
    }

    public void drawImage() {
        this.drawThumbnail();
        this.conductor.setFineBuffer();
    }

    private void setFullScreen() {
        DisplayMode[] modes = this.device.getDisplayModes();
        int index = this.displayModeIndex.get(this.jComboMode.getSelectedIndex());
        double rateX = 1.0 * (double)modes[index].getWidth() / (double)this.jCanvasMain.getWidth();
        double rateY = 1.0 * (double)modes[index].getHeight() / (double)this.jCanvasMain.getHeight();
        double rate = Math.max(rateX, rateY);
        this.screenTransform.setToScale(rate, rate);
        this.jFrameFullScreen.getContentPane().add(this.jCanvasMain);
        this.setVisible(false);
        try {
            this.device.setFullScreenWindow(this.jFrameFullScreen);
            this.device.setDisplayMode(modes[index]);
        }
        catch (Exception e) {
            this.device.setFullScreenWindow(null);
            e.printStackTrace();
            System.exit(0);
        }
    }

    public void fitImageToCanvas() {
        this.jCanvasMain.setFullSrc();
        this.drawImage();
    }

    public ImageTransform getImageTransform() {
        return this.jCanvasMain.getImageTransform();
    }

    public void drawFineImageToOffScreen(BufferedImage fineImage, int sourceWidth, int sourceHeight) {
        this.fineTransform.setToScale(1.0 * (double)this.jCanvasMain.getWidth() / (double)sourceWidth, 1.0 * (double)this.jCanvasMain.getHeight() / (double)sourceHeight);
        Graphics2D g2 = (Graphics2D)this.jCanvasMain.getOffGraphics();
        g2.drawImage(fineImage, this.fineTransform, this.jCanvasMain);
    }

    public void setSpinnerEnabled(boolean value) {
        this.jSpinnerThumbnail.setEnabled(true);
    }

    public void showSize(int originalWidth, int originalHeight) {
        this.jLabelThumbnailWidth.setText(Integer.toString(this.jCanvasMain.getImageWidth()));
        this.jLabelThumbnailHeight.setText(Integer.toString(this.jCanvasMain.getImageHeight()));
        this.jLabelImageWidth.setText(Integer.toString(originalWidth));
        this.jLabelImageHeight.setText(Integer.toString(originalHeight));
    }

    public void setAnimationScreen() {
        if (this.jCheckFullScreen.isSelected()) {
            this.setFullScreen();
        }
    }

    public AffineTransform getScreenTransform() {
        return this.screenTransform;
    }

    public void setCurrentComment(CommentInfo comment) {
        this.currentComment = comment;
    }

    public int getSamplingRate() {
        return (Integer)this.jSpinnerThumbnail.getValue();
    }

    public void setEditingComment(boolean editingComment) {
        this.editingComment = editingComment;
    }

    private void initComponents() {
        this.jFrameFullScreen = new JFrame();
        this.buttonGroupPlayMode = new ButtonGroup();
        this.jCanvasMain = new JImageCanvas();
        this.jPanelSub = new JPanel();
        this.jPanelStatus = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabelThumbnailWidth = new JLabel();
        this.jLabelThumbnailHeight = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabelImageWidth = new JLabel();
        this.jLabelImageHeight = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabelFps = new JLabel();
        this.jCheckShowFps = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jPanelSettings = new JPanel();
        this.jCheckAdaptCanvasSize = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboMode = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSpinnerThumbnail = new JSpinner();
        this.jLabel7 = new JLabel();
        this.jCheckFullScreen = new JCheckBox();
        this.jButtonFullScreen = new JButton();
        this.jButtonPlayAnimation = new JButton();
        this.jButtonFitImage = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jSpinnerCanvasWidth = new JSpinner();
        this.jSpinnerCanvasHeight = new JSpinner();
        this.jButtonSetCanvasSize = new JButton();
        this.jMenuBarFile = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemOpen = new JMenuItem();
        this.jMenuItemSave = new JMenuItem();
        this.jMenuWindow = new JMenu();
        this.jMenuItemMakeAnimation = new JMenuItem();
        this.jFrameFullScreen.setUndecorated(true);
        this.jFrameFullScreen.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                TaktstockViewer.this.jFrameFullScreenKeyPressed(evt);
            }
        });
        this.setDefaultCloseOperation(3);
        this.setTitle("TAKTSTOCK 1.0RC");
        this.setFocusCycleRoot(false);
        this.setFocusable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TaktstockViewer.this.formWindowClosing(evt);
            }
        });
        this.jCanvasMain.setBackground(new Color(0, 0, 0));
        this.jCanvasMain.setFocusCycleRoot(true);
        this.jCanvasMain.setOpaque(true);
        this.jCanvasMain.setPreferredSize(new Dimension(640, 480));
        this.jCanvasMain.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                TaktstockViewer.this.jCanvasMainComponentResized(evt);
            }
        });
        this.jCanvasMain.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                TaktstockViewer.this.jCanvasMainMouseDragged(evt);
            }
        });
        this.jCanvasMain.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TaktstockViewer.this.jCanvasMainMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                TaktstockViewer.this.jCanvasMainMousePressed(evt);
            }
        });
        this.jCanvasMain.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                TaktstockViewer.this.jCanvasMainMouseWheelMoved(evt);
            }
        });
        this.getContentPane().add((Component)this.jCanvasMain, "Center");
        this.jPanelSub.setLayout(new BorderLayout());
        this.jPanelStatus.setLayout(new GridBagLayout());
        this.jPanelStatus.setBackground(new Color(230, 230, 255));
        this.jPanelStatus.setBorder(new TitledBorder("STATUS"));
        this.jPanelStatus.setFocusable(false);
        this.jPanelStatus.setMinimumSize(new Dimension(130, 98));
        this.jPanelStatus.setPreferredSize(new Dimension(150, 130));
        this.jLabel9.setForeground(new Color(128, 126, 126));
        this.jLabel9.setText("Thumbnail: ");
        this.jLabel9.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelStatus.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabelThumbnailWidth.setHorizontalAlignment(4);
        this.jLabelThumbnailWidth.setFocusable(false);
        this.jLabelThumbnailWidth.setPreferredSize(new Dimension(60, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelStatus.add((Component)this.jLabelThumbnailWidth, gridBagConstraints);
        this.jLabelThumbnailHeight.setPreferredSize(new Dimension(60, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanelStatus.add((Component)this.jLabelThumbnailHeight, gridBagConstraints);
        this.jLabel10.setForeground(new Color(128, 126, 126));
        this.jLabel10.setText("Image:");
        this.jLabel10.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelStatus.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabelImageWidth.setHorizontalAlignment(4);
        this.jLabelImageWidth.setFocusable(false);
        this.jLabelImageWidth.setPreferredSize(new Dimension(60, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelStatus.add((Component)this.jLabelImageWidth, gridBagConstraints);
        this.jLabelImageHeight.setPreferredSize(new Dimension(60, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanelStatus.add((Component)this.jLabelImageHeight, gridBagConstraints);
        this.jLabel14.setForeground(new Color(128, 126, 126));
        this.jLabel14.setText("FPS: ");
        this.jLabel14.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelStatus.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabelFps.setHorizontalAlignment(4);
        this.jLabelFps.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanelStatus.add((Component)this.jLabelFps, gridBagConstraints);
        this.jCheckShowFps.setForeground(new Color(128, 126, 126));
        this.jCheckShowFps.setText("measure");
        this.jCheckShowFps.setFocusable(false);
        this.jCheckShowFps.setOpaque(false);
        this.jCheckShowFps.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TaktstockViewer.this.jCheckShowFpsItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanelStatus.add((Component)this.jCheckShowFps, gridBagConstraints);
        this.jLabel13.setText("x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanelStatus.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel16.setText("x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanelStatus.add((Component)this.jLabel16, gridBagConstraints);
        this.jPanelSub.add((Component)this.jPanelStatus, "North");
        this.jPanelSettings.setLayout(new GridBagLayout());
        this.jPanelSettings.setBackground(new Color(230, 230, 255));
        this.jPanelSettings.setBorder(new TitledBorder("SETTINGS"));
        this.jPanelSettings.setFocusable(false);
        this.jCheckAdaptCanvasSize.setForeground(new Color(128, 126, 126));
        this.jCheckAdaptCanvasSize.setSelected(true);
        this.jCheckAdaptCanvasSize.setText("adapt canvas size");
        this.jCheckAdaptCanvasSize.setOpaque(false);
        this.jCheckAdaptCanvasSize.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TaktstockViewer.this.jCheckAdaptCanvasSizeItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanelSettings.add((Component)this.jCheckAdaptCanvasSize, gridBagConstraints);
        this.jLabel1.setForeground(new Color(102, 102, 255));
        this.jLabel1.setText("CANVAS");
        this.jLabel1.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 2, 0);
        this.jPanelSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel3.setForeground(new Color(102, 102, 255));
        this.jLabel3.setText("ANIMATION");
        this.jLabel3.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 2, 0);
        this.jPanelSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jComboMode.setForeground(new Color(152, 152, 255));
        this.jComboMode.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanelSettings.add((Component)this.jComboMode, gridBagConstraints);
        this.jLabel4.setForeground(new Color(128, 126, 126));
        this.jLabel4.setText("rate: ");
        this.jLabel4.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelSettings.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setForeground(new Color(128, 126, 126));
        this.jLabel5.setText("full: ");
        this.jLabel5.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelSettings.add((Component)this.jLabel5, gridBagConstraints);
        this.jSpinnerThumbnail.setEnabled(false);
        this.jSpinnerThumbnail.setFocusable(false);
        this.jSpinnerThumbnail.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TaktstockViewer.this.jSpinnerThumbnailStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanelSettings.add((Component)this.jSpinnerThumbnail, gridBagConstraints);
        this.jLabel7.setForeground(new Color(102, 102, 255));
        this.jLabel7.setText("THUMBNAIL");
        this.jLabel7.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanelSettings.add((Component)this.jLabel7, gridBagConstraints);
        this.jCheckFullScreen.setForeground(new Color(128, 126, 126));
        this.jCheckFullScreen.setText("full screen");
        this.jCheckFullScreen.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanelSettings.add((Component)this.jCheckFullScreen, gridBagConstraints);
        this.jButtonFullScreen.setForeground(Color.gray);
        this.jButtonFullScreen.setText("FULL SCREEN");
        this.jButtonFullScreen.setFocusPainted(false);
        this.jButtonFullScreen.setFocusable(false);
        this.jButtonFullScreen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TaktstockViewer.this.jButtonFullScreenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanelSettings.add((Component)this.jButtonFullScreen, gridBagConstraints);
        this.jButtonPlayAnimation.setForeground(Color.gray);
        this.jButtonPlayAnimation.setText("PLAY");
        this.jButtonPlayAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TaktstockViewer.this.jButtonPlayAnimationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanelSettings.add((Component)this.jButtonPlayAnimation, gridBagConstraints);
        this.jButtonFitImage.setForeground(Color.gray);
        this.jButtonFitImage.setText("FIT TO CANVAS");
        this.jButtonFitImage.setFocusPainted(false);
        this.jButtonFitImage.setFocusable(false);
        this.jButtonFitImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TaktstockViewer.this.jButtonFitImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanelSettings.add((Component)this.jButtonFitImage, gridBagConstraints);
        this.jLabel2.setForeground(new Color(128, 126, 126));
        this.jLabel2.setText("width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelSettings.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel8.setForeground(new Color(128, 126, 126));
        this.jLabel8.setText("height: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelSettings.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanelSettings.add((Component)this.jSpinnerCanvasWidth, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanelSettings.add((Component)this.jSpinnerCanvasHeight, gridBagConstraints);
        this.jButtonSetCanvasSize.setForeground(Color.gray);
        this.jButtonSetCanvasSize.setText("SET SIZE");
        this.jButtonSetCanvasSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TaktstockViewer.this.jButtonSetCanvasSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanelSettings.add((Component)this.jButtonSetCanvasSize, gridBagConstraints);
        this.jPanelSub.add((Component)this.jPanelSettings, "Center");
        this.getContentPane().add((Component)this.jPanelSub, "West");
        this.jMenuFile.setText("File");
        this.jMenuFile.setPreferredSize(new Dimension(80, 17));
        this.jMenuItemOpen.setText("Open Image");
        this.jMenuItemOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TaktstockViewer.this.jMenuItemOpenActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpen);
        this.jMenuItemSave.setText("Save Image");
        this.jMenuItemSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TaktstockViewer.this.jMenuItemSaveActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSave);
        this.jMenuBarFile.add(this.jMenuFile);
        this.jMenuWindow.setText("Window");
        this.jMenuItemMakeAnimation.setText("Animation");
        this.jMenuItemMakeAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TaktstockViewer.this.jMenuItemMakeAnimationActionPerformed(evt);
            }
        });
        this.jMenuWindow.add(this.jMenuItemMakeAnimation);
        this.jMenuBarFile.add(this.jMenuWindow);
        this.setJMenuBar(this.jMenuBarFile);
        this.pack();
    }

    private void jCheckAdaptCanvasSizeItemStateChanged(ItemEvent evt) {
        this.jSpinnerThumbnail.setEnabled(!this.jCheckAdaptCanvasSize.isSelected());
    }

    private void jButtonSetCanvasSizeActionPerformed(ActionEvent evt) {
        int width = (Integer)this.jSpinnerCanvasWidth.getValue();
        int height = (Integer)this.jSpinnerCanvasHeight.getValue();
        this.jCanvasMain.setSize(width, height);
        this.pack();
    }

    private void jButtonPlayAnimationActionPerformed(ActionEvent evt) {
        this.conductor.playAnimation(this.fps);
    }

    private void jMenuItemMakeAnimationActionPerformed(ActionEvent evt) {
        this.conductor.showAnimationMaker();
    }

    private void jMenuItemSaveActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        this.conductor.saveCurrentImage();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jMenuItemOpenActionPerformed(ActionEvent evt) {
        File file = this.fileIO.getOpenFile();
        if (file != null) {
            this.setCursor(new Cursor(3));
            if (this.jCheckAdaptCanvasSize.isSelected()) {
                int rate = this.conductor.calculateSamplingRate(file, this.jCanvasMain.getSize());
                this.jSpinnerThumbnail.setValue(rate);
            }
            int samplingRate = (Integer)this.jSpinnerThumbnail.getValue();
            this.conductor.addAnimationFile(file, samplingRate);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jCanvasMainMouseWheelMoved(MouseWheelEvent evt) {
        this.jCanvasMain.mouseWheelMoved(evt);
        this.drawImage();
    }

    private void jCheckShowFpsItemStateChanged(ItemEvent evt) {
        if (this.timerFps != null) {
            this.timerFps.cancel();
        }
        if (this.jCheckShowFps.isSelected()) {
            this.timerFps = new Timer();
            this.createFpsTask();
            this.timerFps.scheduleAtFixedRate(this.taskFps, 0L, 1000L);
        } else {
            this.jLabelFps.setText("");
        }
    }

    private void jCanvasMainComponentResized(ComponentEvent evt) {
        Dimension preSize = this.jCanvasMain.getPreSize();
        double rw = 1.0 * (double)this.jCanvasMain.getWidth() / (double)preSize.width;
        double rh = 1.0 * (double)this.jCanvasMain.getHeight() / (double)preSize.height;
        double ratio = 1.0;
        ratio = 1.0 < rw && 1.0 < rh ? Math.max(rw, rh) : Math.min(rw, rh);
        this.jCanvasMain.scaleImage(ratio);
        this.drawImage();
        this.jSpinnerCanvasWidth.setValue(this.jCanvasMain.getWidth());
        this.jSpinnerCanvasHeight.setValue(this.jCanvasMain.getHeight());
    }

    private void jSpinnerThumbnailStateChanged(ChangeEvent evt) {
        int samplingRate = (Integer)this.jSpinnerThumbnail.getValue();
        this.conductor.changeSamplingRate(samplingRate);
    }

    private void jFrameFullScreenKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.getContentPane().add(this.jCanvasMain);
            Dimension preSize = this.jCanvasMain.getPreSize();
            this.setVisible(true);
            this.device.setFullScreenWindow(null);
            this.jFrameFullScreen.setVisible(false);
        }
    }

    private void jButtonFullScreenActionPerformed(ActionEvent evt) {
        this.setFullScreen();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.conductor.cancelAllTimerTask();
    }

    private void jButtonFitImageActionPerformed(ActionEvent evt) {
        this.jCanvasMain.setFullSrc();
        this.drawImage();
    }

    private void jCanvasMainMousePressed(MouseEvent evt) {
        if (this.editingComment) {
            this.oldX = evt.getX();
            this.oldY = evt.getY();
        } else {
            this.jCanvasMain.mousePressed(evt);
        }
    }

    private void jCanvasMainMouseDragged(MouseEvent evt) {
        if (this.editingComment) {
            int dx = evt.getX() - this.oldX;
            int dy = evt.getY() - this.oldY;
            this.currentComment.translate(dx, dy);
            this.oldX = evt.getX();
            this.oldY = evt.getY();
            this.updateCanvas();
        } else {
            this.jCanvasMain.mouseDragged(evt);
            this.drawImage();
        }
    }

    private void jCanvasMainMouseClicked(MouseEvent evt) {
        this.jCanvasMain.mouseClicked(evt);
        this.drawImage();
    }
}

