/*
 * Decompiled with CFR 0.152.
 */
package taktstock;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Vector;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import sos.io.Extension;
import sos.io.SOSImageIO;
import taktstock.CommentInfo;

public class TaktstockFile {
    private static final String path = "UnknownChunks/UnknownChunk";
    private static final String[] attr = new String[]{"type/tkFl"};
    private static Vector<String> columnNames = new Vector();
    private File file;
    private int samplingRate;
    private Vector<Vector<Object>> tableModelData = new Vector();

    public TaktstockFile(File file, int rate) {
        this.file = file;
        this.samplingRate = rate;
        this.loadKeyFrame();
    }

    private void loadKeyFrame() {
        IIOMetadata metadata = SOSImageIO.getMetadata(this.file);
        byte[] data = null;
        if (metadata != null) {
            try {
                IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
                IIOMetadataNode node = SOSImageIO.getNode(root, path, attr);
                if (node != null) {
                    data = (byte[])node.getUserObject();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (data != null) {
            try {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
                ObjectInputStream objectIn = new ObjectInputStream(byteIn);
                this.tableModelData = (Vector)objectIn.readObject();
                objectIn.close();
                byteIn.close();
            }
            catch (StreamCorruptedException e) {
                System.out.println("Error but OK");
            }
            catch (ClassCastException e) {
                System.out.println("Error but OK");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        if (0 < this.tableModelData.size()) {
            byte[][] data = new byte[1][];
            try {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
                objectOut.writeObject(this.tableModelData);
                objectOut.flush();
                data[0] = byteOut.toByteArray();
                objectOut.close();
                byteOut.close();
            }
            catch (NotSerializableException e) {
                System.out.println("Serializable error");
                e.printStackTrace();
            }
            catch (Exception e) {
                System.out.println("Other error");
            }
            BufferedImage img = SOSImageIO.readImage(this.file);
            IIOMetadata metadata = SOSImageIO.getDefaultMetadata("png", img);
            IIOMetadataNode node = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
            IIOMetadataNode privateChunk = SOSImageIO.getNode(node, path, attr);
            if (privateChunk == null) {
                privateChunk = SOSImageIO.addNode(node, path, attr);
            }
            privateChunk.setUserObject(data[0]);
            try {
                metadata.setFromTree(metadata.getNativeMetadataFormatName(), node);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File newFile = new File(Extension.replace(this.file.getPath(), "png"));
            SOSImageIO.writeImage(newFile, img, metadata);
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public void setSamplingRate(int rate) {
        this.samplingRate = rate;
    }

    public void copyTableModel(JTable distTable) {
        DefaultTableModel model = (DefaultTableModel)distTable.getModel();
        model.setDataVector(this.tableModelData, columnNames);
    }

    public Vector getData(int index) {
        Vector<Object> data = this.tableModelData.get(index);
        return data;
    }

    public CommentInfo getCommentInfo(int index) {
        Vector vec = this.getData(index);
        return (CommentInfo)vec.get(3);
    }

    public String toString() {
        return this.file.getName();
    }

    static {
        columnNames.add("NO");
        columnNames.add("COMMENTS");
    }
}

