/*
 * Decompiled with CFR 0.152.
 */
package taktstock;

import java.awt.Graphics2D;
import java.io.File;
import java.util.Vector;
import taktstock.CommentInfo;
import taktstock.TaktstockFile;

public class KeyFrame {
    private static double[] synMatrix = new double[6];
    private double[] matrix;
    private long duration;
    private boolean pauseFrame;
    private CommentInfo comment;
    private TaktstockFile taktstockFile;
    private long startTime;
    private KeyFrame prevFrame;
    private KeyFrame nextFrame;
    private boolean showComment;
    private boolean stillFrame;

    public KeyFrame(TaktstockFile file, int indexFrame, boolean pause, long time, boolean showComment) {
        this.taktstockFile = file;
        Vector data = file.getData(indexFrame);
        this.matrix = (double[])data.get(0);
        this.comment = (CommentInfo)data.get(1);
        this.duration = time;
        this.pauseFrame = pause;
        this.showComment = showComment;
    }

    public void setNextFrame(KeyFrame keyFrame) {
        this.nextFrame = keyFrame;
        if (!this.getFile().equals(this.nextFrame.getFile())) {
            this.nextFrame.startTime = 0L;
            this.stillFrame = true;
        } else {
            this.nextFrame.startTime = this.nextFrame.pauseFrame ? 0L : this.startTime + this.duration;
        }
        keyFrame.prevFrame = this;
    }

    public KeyFrame getNextFrame() {
        if (this.nextFrame == null) {
            return this;
        }
        return this.nextFrame;
    }

    public KeyFrame getPrevFrame() {
        if (this.prevFrame == null) {
            return this;
        }
        return this.prevFrame;
    }

    public double[] transform(long time) {
        if (this.isStillFrame()) {
            return this.matrix;
        }
        double ratio = 1.0 * (double)(time - this.startTime) / (double)this.duration;
        for (int i = 0; i < 6; ++i) {
            KeyFrame.synMatrix[i] = (1.0 - ratio) * this.matrix[i] + ratio * this.getNextFrame().matrix[i];
        }
        return synMatrix;
    }

    public long getEndTime() {
        if (this.nextFrame == null) {
            return this.startTime;
        }
        return this.startTime + this.duration;
    }

    public boolean isPauseFrame() {
        return this.pauseFrame;
    }

    public void drawComment(Graphics2D g) {
        this.comment.draw(g);
    }

    public TaktstockFile getTaktstockFile() {
        return this.taktstockFile;
    }

    public File getFile() {
        return this.taktstockFile.getFile();
    }

    public CommentInfo getComment() {
        return this.comment;
    }

    public boolean isShowComment() {
        return this.showComment;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isStillFrame() {
        return this.stillFrame;
    }
}

