/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.util;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.dyndns.nuda.tools.util.StringUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class StringUtilTest
extends TestCase {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testDeIndent() {
        String param = "\t\u3042\u3044\u3046\u3048\u304a\n\t\u304b\u304d\u304f\u3051\u3053";
        String expected = "\u3042\u3044\u3046\u3048\u304a\n\u304b\u304d\u304f\u3051\u3053";
        String actual = StringUtil.deIndent((String)param);
        Assert.assertEquals((String)expected, (String)actual);
    }

    public void testIndent() {
        String param = "\u3042\u3044\u3046\u3048\u304a\n\u304b\u304d\u304f\u3051\u3053";
        String expected = "\t\t\u3042\u3044\u3046\u3048\u304a\n\t\t\u304b\u304d\u304f\u3051\u3053";
        String actual = StringUtil.indent((String)param, (int)2);
        Assert.assertEquals((String)expected, (String)actual);
    }

    public void testIndentWithNum() {
        String param = "\u3042\u3044\u3046\u3048\u304a\n\u304b\u304d\u304f\u3051\u3053";
        String expected = "001 :\t\t\u3042\u3044\u3046\u3048\u304a\n002 :\t\t\u304b\u304d\u304f\u3051\u3053";
        String actual = StringUtil.indentWithNum((String)param, (int)2);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testFormatStringObjectArray01() {
        String message = StringUtil.format((String)"{}", (Object[])new Object[]{"a.b.c"});
        Assert.assertEquals((String)message, (String)"a.b.c", (String)message);
    }

    @Test
    public void testFormatStringObjectArray02() {
        String message = StringUtil.format((String)"{}", (Object[])new Object[]{"a\\b\\c"});
        Assert.assertEquals((String)message, (String)"a\\b\\c", (String)message);
    }

    @Test
    public void testFormatStringObjectArray03() {
        String message = StringUtil.format((String)"{}", (Object[])new Object[]{"a?b?c"});
        Assert.assertEquals((String)message, (String)"a?b?c", (String)message);
    }

    @Test
    public void testFormatStringObjectArray04() {
        String message = StringUtil.format((String)"{}", (Object[])new Object[]{"a+b+c"});
        Assert.assertEquals((String)message, (String)"a+b+c", (String)message);
    }

    @Test
    public void testFormatStringObjectArray05() {
        String message = StringUtil.format((String)"{}", (Object[])new Object[]{"a*b*c"});
        Assert.assertEquals((String)message, (String)"a*b*c", (String)message);
    }

    @Test
    public void testFormatStringObjectArray06() {
        String message = StringUtil.format((String)"{} {} {} {} {}", (Object[])new Object[]{"a.b.c", "a\\b\\c", "a?b?c", "a+b+c", "a*b*c"});
        Assert.assertEquals((String)message, (String)"a.b.c a\\b\\c a?b?c a+b+c a*b*c", (String)message);
    }

    @Test
    public void testFormatStringObjectArray07() {
        String message = StringUtil.format((String)"{{}} {} {} {{} {}}", (Object[])new Object[]{"a.b.c", "a\\b\\c", "a?b?c", "a+b+c", "a*b*c"});
        Assert.assertEquals((String)message, (String)"{a.b.c} a\\b\\c a?b?c {a+b+c a*b*c}", (String)message);
    }

    @Test
    public void testFormatStringMap01() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key01", "a.b.c");
        map.put("key02", "a\\b\\c");
        map.put("key03", "a?b?c");
        map.put("key04", "a+b+c");
        map.put("key05", "a*b*c");
        String message = StringUtil.format((String)"{{key01}} {key02} {key03} {{key04} {key05}}", map);
        Assert.assertEquals((String)message, (String)"{a.b.c} a\\b\\c a?b?c {a+b+c a*b*c}", (String)message);
    }
}

