package org.dyndns.nuda.profile;

import org.dyndns.nuda.plugin.SysPluginLoader;

/**
 * アプリケーション計測用プロファイラのためのリポジトリクラスです
 * @author koseki
 *
 */
public class ProfilerRepository {
	private static Profiler _profiler = null;
	private static Object LOCK = new Object();
	
	public static void setProfiler(Profiler profiler) {
		if(profiler == null) {
			return;
		}
		if(_profiler == null) {
			synchronized(LOCK) {
				if(_profiler == null) {
					_profiler = profiler;
				}
			}
		}
	}
	
	public static void reserveProfiler() {
		if(_profiler != null) {
			_profiler.reserveProfiler();
		} else {
			new SysPluginLoader().loadPlugin(Profiler.class);
			if(_profiler != null) {
				_profiler.reserveProfiler();
			}
		}
	}
}
