package org.dyndns.nuda.logger;


/**
 * 汎用ロガーと各種ロギングライブラリとのアダプタを表すインタフェースです.<br />
 * このクラスはLog4JのNDCなどの機能には対応しておりません
 * 
 * @author nkoseki
 * 
 */
public interface LoggerAdaptor {
	//	public enum LOG_LEVEL {
	//		TRACE(0), DEBUG(1), INFO(2), WARN(3), ERROR(4), FATAL(5);
	//		
	//		LOG_LEVEL(final int logLevelNum) {
	//			this.logLevelNum = logLevelNum;
	//		}
	//		
	//		private int	logLevelNum	= 0;
	//	}
	
	/**
	 * アダプト先ログライブラリの推奨バージョンを文字列表現で返します
	 * 
	 * @return
	 */
	public String getRecommendVersion();
	
	/**
	 * アダプト先ログライブラリのロギングクラス名を返します
	 * 
	 * @return
	 */
	public String getLoggerClassName();
	
	/**
	 * アダプト先ログライブラリのロギングクラスを返します
	 * 
	 * @return
	 */
	public Class<?> getLoggerClass();
	
	/**
	 * 引数に指定されたロガー名でログアダプタを生成します
	 * 
	 * @param loggerName
	 * @return
	 */
	public LoggerAdaptor getLogger(String loggerName);
	
	/**
	 * 引数に指定されたクラスオブジェクトでログアダプタを生成します
	 * 
	 * @param targetClass
	 * @return
	 */
	public LoggerAdaptor getLogger(Class<?> targetClass);
	
	/**
	 * ログレベル:traceでログを出力します
	 * 
	 * @param format
	 * @param params
	 */
	public void trace(String format, Object... params);
	
	/**
	 * ログレベル:traceでログを出力します
	 * 
	 * @param message
	 * @param t
	 */
	public void trace(String message, Throwable t);
	
	/**
	 * ログレベル:debugでログを出力します
	 * 
	 * @param format
	 * @param params
	 */
	public void debug(String format, Object... params);
	
	/**
	 * ログレベル:debugでログを出力します
	 * 
	 * @param message
	 * @param t
	 */
	public void debug(String message, Throwable t);
	
	/**
	 * ログレベル:infoでログを出力します
	 * 
	 * @param format
	 * @param params
	 */
	public void info(String format, Object... params);
	
	/**
	 * ログレベル:infoでログを出力します
	 * 
	 * @param message
	 * @param t
	 */
	public void info(String message, Throwable t);
	
	/**
	 * ログレベル:warnでログを出力します
	 * 
	 * @param format
	 * @param params
	 */
	public void warn(String format, Object... params);
	
	/**
	 * ログレベル:warnでログを出力します
	 * 
	 * @param message
	 * @param t
	 */
	public void warn(String message, Throwable t);
	
	/**
	 * ログレベル:errorでログを出力します
	 * 
	 * @param format
	 * @param params
	 */
	public void error(String format, Object... params);
	
	/**
	 * ログレベル:errorでログを出力します
	 * 
	 * @param message
	 * @param t
	 */
	public void error(String message, Throwable t);
	
	/**
	 * ログレベル:fatalでログを出力します
	 * 
	 * @param format
	 * @param params
	 */
	public void fatal(String format, Object... params);
	
	/**
	 * ログレベル:fatalでログを出力します
	 * 
	 * @param message
	 * @param t
	 */
	public void fatal(String message, Throwable t);
}
