/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringValidator {
    public static final String ENCODE_W31J = "Windows-31j";
    public static final String ENCODE_SJIS = "SJIS";
    public static final String ENCODE_EUCJP = "euc-jp";
    public static final String ENCODE_UTF8 = "UTF-8";
    private static Pattern PTN = Pattern.compile("[01]+");
    private static Pattern PTN2 = Pattern.compile("(\\d{5})+?");
    private static Pattern PTN3 = Pattern.compile("(\\d{4})+?");
    private static Pattern PTN4 = Pattern.compile("([0-9a-f]{1})+?");

    private static boolean checkCharacterCode(String str, String encoding) {
        if (str == null) {
            return true;
        }
        Charset charSet = Charset.forName(encoding);
        try {
            byte[] bytes = str.getBytes(charSet);
            return str.equals(new String(bytes, encoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("\u30a8\u30f3\u30b3\u30fc\u30c9\u540d\u79f0\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002", ex);
        }
    }

    public static boolean isWindows31j(String str) {
        return StringValidator.checkCharacterCode(str, ENCODE_W31J);
    }

    public static boolean isSJIS(String str) {
        return StringValidator.checkCharacterCode(str, ENCODE_SJIS);
    }

    public static boolean isEUC(String str) {
        return StringValidator.checkCharacterCode(str, ENCODE_EUCJP);
    }

    public static boolean isUTF8(String str) {
        return StringValidator.checkCharacterCode(str, ENCODE_UTF8);
    }

    public static String getCharCode(String source) {
        if (StringValidator.isWindows31j(source)) {
            return ENCODE_W31J;
        }
        if (StringValidator.isSJIS(source)) {
            return ENCODE_SJIS;
        }
        if (StringValidator.isEUC(source)) {
            return ENCODE_EUCJP;
        }
        if (StringValidator.isUTF8(source)) {
            return ENCODE_UTF8;
        }
        return "";
    }

    private static String convertHexFromBytes(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            builder.append(Integer.toHexString((b & 0xF0) >> 4));
            builder.append(Integer.toHexString(b & 0xF));
            ++n2;
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        String testStr = "";
        byte[] bytes = testStr.getBytes(Charset.forName(ENCODE_UTF8));
        StringBuilder builder = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            builder.append(Integer.toHexString((b & 0xF0) >> 4));
            builder.append(Integer.toHexString(b & 0xF));
            ++n2;
        }
        String hex = StringValidator.convertHexFromBytes(bytes);
        System.out.println("(" + bytes.length + ")binary > \n" + hex + "(" + hex.length() + ")");
        System.out.println("<<<" + new String(bytes, Charset.forName(ENCODE_UTF8)));
        LinkedList<String> lst = new LinkedList<String>();
        int i = 0;
        while (i < bytes.length) {
            lst.add(String.valueOf(Integer.toBinaryString(bytes[i])) + "-");
            ++i;
        }
        System.out.println("==");
        System.out.println(">>>>" + StringValidator.convert16dToBin(hex));
        System.out.println("==");
        String s = StringValidator.get32DFromStr2(StringValidator.convert16dToBin(hex));
        String s2 = StringValidator.get16DFromStr(lst);
        System.out.println("(" + s.length() + ")binary > \n" + s + "(" + s.length() + ")");
    }

    public static void test02(String binStr) {
        System.out.println("=====================================================================================");
        String testStr = binStr;
        ArrayList<String> strList = new ArrayList<String>();
        int i = 0;
        while (i < testStr.length()) {
            String s = new Character(testStr.charAt(i)).toString();
            if (s.getBytes().length != 1) {
                throw new RuntimeException("\u5bfe\u8c61\u6587\u5b57\u306b\u30de\u30eb\u30c1\u30d0\u30a4\u30c8\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059");
            }
            strList.add(s);
            ++i;
        }
        if (strList.size() == 0 || strList.size() % 2 != 0) {
            if (strList.size() == 0) {
                throw new RuntimeException("\u5bfe\u8c61\u6587\u5b57\u304c\u3042\u308a\u307e\u305b\u3093");
            }
            throw new RuntimeException("\u5bfe\u8c61\u6587\u5b57\u304c\u4e2d\u9014\u534a\u7aef\u306a\u9577\u3055\u3067\u3059\u3002\u6587\u5b57\u9577\u306f\uff12\u306e\u500d\u6570\u306b\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        int i2 = 1;
        int buf = 0;
        for (String ch : strList) {
            if (i2 != 0 && i2 % 2 == 0) {
                int buf00 = StringValidator.getCodeFromChar(ch);
                int buf0 = buf << 4 & 0xF0;
                buf = buf00 | buf0;
                byteList.add((byte)buf);
                buf = 0;
            } else {
                buf = StringValidator.getCodeFromChar(ch);
            }
            ++i2;
        }
        System.out.println("=====================================================================================");
        Byte[] bytes000 = byteList.toArray(new Byte[byteList.size()]);
        byte[] result = new byte[bytes000.length];
        StringBuilder b = new StringBuilder();
        LinkedList<String> binList = new LinkedList<String>();
        int idx = 0;
        while (idx < bytes000.length) {
            b.append(Integer.toBinaryString(bytes000[idx].byteValue()));
            binList.add(Integer.toBinaryString(bytes000[idx].byteValue()));
            result[idx] = bytes000[idx];
            ++idx;
        }
        System.out.println(">>>" + new String(result, Charset.forName(ENCODE_UTF8)));
    }

    private static int getCodeFromChar(String ch) {
        if ("0".equals(ch)) {
            return 0;
        }
        if ("1".equals(ch)) {
            return 1;
        }
        if ("2".equals(ch)) {
            return 2;
        }
        if ("3".equals(ch)) {
            return 3;
        }
        if ("4".equals(ch)) {
            return 4;
        }
        if ("5".equals(ch)) {
            return 5;
        }
        if ("6".equals(ch)) {
            return 6;
        }
        if ("7".equals(ch)) {
            return 7;
        }
        if ("8".equals(ch)) {
            return 8;
        }
        if ("9".equals(ch)) {
            return 9;
        }
        if ("a".equals(ch.toUpperCase())) {
            return 10;
        }
        if ("b".equals(ch.toUpperCase())) {
            return 11;
        }
        if ("c".equals(ch.toUpperCase())) {
            return 12;
        }
        if ("d".equals(ch.toUpperCase())) {
            return 13;
        }
        if ("e".equals(ch.toUpperCase())) {
            return 14;
        }
        if ("f".equals(ch.toUpperCase())) {
            return 15;
        }
        return Integer.MIN_VALUE;
    }

    private static String get32DFromStr(List<String> binList) {
        StringBuilder b = new StringBuilder();
        for (String str : binList) {
            Matcher m = PTN.matcher(str);
            m.matches();
            b.append(str);
        }
        int fill = 5 - b.toString().length() % 5;
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < fill) {
            result.append("0");
            ++i;
        }
        result.append(b.toString());
        String target = result.toString();
        LinkedList<String> d32List = new LinkedList<String>();
        Matcher m2 = PTN2.matcher(target);
        while (m2.find()) {
            d32List.add(target.substring(m2.start(), m2.end()));
        }
        StringBuilder result0 = new StringBuilder();
        for (String d32 : d32List) {
            result0.append(StringValidator.convertBinTo32d(d32));
        }
        return result0.toString();
    }

    private static String get32DFromStr2(String binList) {
        StringBuilder b = new StringBuilder();
        int fill = 5 - binList.length() % 5;
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < fill) {
            result.append("0");
            ++i;
        }
        result.append(binList);
        String target = result.toString();
        LinkedList<String> d32List = new LinkedList<String>();
        Matcher m2 = PTN2.matcher(target);
        while (m2.find()) {
            d32List.add(target.substring(m2.start(), m2.end()));
        }
        StringBuilder result0 = new StringBuilder();
        for (String d32 : d32List) {
            result0.append(StringValidator.convertBinTo32d(d32));
        }
        return result0.toString();
    }

    private static String get16DFromStr(List<String> binList) {
        StringBuilder b = new StringBuilder();
        for (String str : binList) {
            Matcher m = PTN.matcher(str);
            m.matches();
            b.append(str);
        }
        int fill = 4 - b.toString().length() % 4;
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < fill) {
            result.append("0");
            ++i;
        }
        result.append(b.toString());
        String target = result.toString();
        LinkedList<String> d32List = new LinkedList<String>();
        Matcher m2 = PTN3.matcher(target);
        while (m2.find()) {
            d32List.add(target.substring(m2.start(), m2.end()));
        }
        StringBuilder result0 = new StringBuilder();
        for (String d32 : d32List) {
            result0.append(StringValidator.convertBinTo16d(d32));
        }
        return result0.toString();
    }

    private static String convertBinTo32d(String d32) {
        StringBuilder result0 = new StringBuilder();
        if ("00000".equals(d32)) {
            result0.append("0");
        } else if ("00001".equals(d32)) {
            result0.append("1");
        } else if ("00010".equals(d32)) {
            result0.append("2");
        } else if ("00011".equals(d32)) {
            result0.append("3");
        } else if ("00100".equals(d32)) {
            result0.append("4");
        } else if ("00101".equals(d32)) {
            result0.append("5");
        } else if ("00110".equals(d32)) {
            result0.append("6");
        } else if ("00111".equals(d32)) {
            result0.append("7");
        } else if ("01000".equals(d32)) {
            result0.append("8");
        } else if ("01001".equals(d32)) {
            result0.append("9");
        } else if ("01010".equals(d32)) {
            result0.append("a");
        } else if ("01011".equals(d32)) {
            result0.append("b");
        } else if ("01100".equals(d32)) {
            result0.append("c");
        } else if ("01101".equals(d32)) {
            result0.append("d");
        } else if ("01110".equals(d32)) {
            result0.append("e");
        } else if ("01111".equals(d32)) {
            result0.append("f");
        } else if ("10000".equals(d32)) {
            result0.append("g");
        } else if ("10001".equals(d32)) {
            result0.append("h");
        } else if ("10010".equals(d32)) {
            result0.append("i");
        } else if ("10011".equals(d32)) {
            result0.append("j");
        } else if ("10100".equals(d32)) {
            result0.append("k");
        } else if ("10101".equals(d32)) {
            result0.append("l");
        } else if ("10110".equals(d32)) {
            result0.append("m");
        } else if ("10111".equals(d32)) {
            result0.append("n");
        } else if ("11000".equals(d32)) {
            result0.append("o");
        } else if ("11001".equals(d32)) {
            result0.append("p");
        } else if ("11010".equals(d32)) {
            result0.append("q");
        } else if ("11011".equals(d32)) {
            result0.append("r");
        } else if ("11100".equals(d32)) {
            result0.append("s");
        } else if ("11101".equals(d32)) {
            result0.append("t");
        } else if ("11110".equals(d32)) {
            result0.append("u");
        } else if ("11111".equals(d32)) {
            result0.append("v");
        }
        return result0.toString();
    }

    private static String convertBinTo16d(String d16) {
        StringBuilder result0 = new StringBuilder();
        Matcher m2 = PTN4.matcher(d16);
        while (m2.find()) {
            String hex = d16.substring(m2.start(), m2.end());
            if ("0000".equals(hex)) {
                result0.append("0");
            } else if ("0001".equals(hex)) {
                result0.append("1");
            } else if ("0010".equals(hex)) {
                result0.append("2");
            } else if ("0011".equals(hex)) {
                result0.append("3");
            } else if ("0100".equals(hex)) {
                result0.append("4");
            } else if ("0101".equals(hex)) {
                result0.append("5");
            } else if ("0110".equals(hex)) {
                result0.append("6");
            } else if ("0111".equals(hex)) {
                result0.append("7");
            } else if ("1000".equals(hex)) {
                result0.append("8");
            } else if ("1001".equals(hex)) {
                result0.append("9");
            } else if ("1010".equals(hex)) {
                result0.append("a");
            } else if ("1011".equals(hex)) {
                result0.append("b");
            } else if ("1100".equals(hex)) {
                result0.append("c");
            } else if ("1101".equals(hex)) {
                result0.append("d");
            } else if ("1110".equals(hex)) {
                result0.append("e");
            } else if ("1111".equals(hex)) {
                result0.append("f");
            }
            result0.append(hex);
        }
        return result0.toString();
    }

    private static String convert16dToBin(String d16) {
        StringBuilder result0 = new StringBuilder();
        Matcher m2 = PTN4.matcher(d16);
        while (m2.find()) {
            String hex = d16.substring(m2.start(), m2.end());
            if ("0".equals(hex)) {
                result0.append("0000");
                continue;
            }
            if ("1".equals(hex)) {
                result0.append("0001");
                continue;
            }
            if ("2".equals(hex)) {
                result0.append("0010");
                continue;
            }
            if ("3".equals(hex)) {
                result0.append("0011");
                continue;
            }
            if ("4".equals(hex)) {
                result0.append("0100");
                continue;
            }
            if ("5".equals(hex)) {
                result0.append("0101");
                continue;
            }
            if ("6".equals(hex)) {
                result0.append("0110");
                continue;
            }
            if ("7".equals(hex)) {
                result0.append("0111");
                continue;
            }
            if ("8".equals(hex)) {
                result0.append("1000");
                continue;
            }
            if ("9".equals(hex)) {
                result0.append("1001");
                continue;
            }
            if ("a".equals(hex)) {
                result0.append("1010");
                continue;
            }
            if ("b".equals(hex)) {
                result0.append("1011");
                continue;
            }
            if ("c".equals(hex)) {
                result0.append("1100");
                continue;
            }
            if ("d".equals(hex)) {
                result0.append("1101");
                continue;
            }
            if ("e".equals(hex)) {
                result0.append("1110");
                continue;
            }
            if (!"f".equals(hex)) continue;
            result0.append("1111");
        }
        return result0.toString();
    }

    public static String bin2hex(byte[] data) {
        StringBuffer sb = new StringBuffer();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String s = Integer.toHexString(0xFF & b);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
            ++n2;
        }
        return sb.toString();
    }
}

