/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dyndns.nuda.tools.util.StringUtilFormatConst;
import org.dyndns.nuda.tools.util.StringUtilIndentConst;
import org.dyndns.nuda.tools.util.StringUtilSplitCSVRowConst;
import org.dyndns.nuda.tools.util.filter.AutoReplacementFilter;

public class StringUtil {
    private StringUtil() {
    }

    public static String loadString(String path) throws IOException {
        StringBuilder b = new StringBuilder();
        if (path == null) {
            return b.toString();
        }
        if (path.isEmpty()) {
            return b.toString();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        is = loader.getResourceAsStream(path);
        if (is == null) {
            return b.toString();
        }
        try {
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            while (br.ready()) {
                String line = br.readLine();
                b.append(line).append("\n");
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return b.toString();
    }

    public static String deIndent(String content) {
        String content0 = content;
        Pattern p0 = StringUtilIndentConst.p0;
        Matcher m0 = p0.matcher(content);
        String replacement = "";
        if (m0.find()) {
            replacement = m0.group();
            content0 = m0.replaceFirst("");
        }
        StringBuilder b0 = new StringBuilder();
        b0.append("^").append(replacement);
        Pattern p = Pattern.compile(b0.toString(), 40);
        Matcher m = p.matcher(content0);
        String replaceItem = "";
        while (m.find()) {
            replaceItem = m.replaceFirst("<<<org.dyndns.nuda.repserv.util.StringUtil.REPLACEMENT_HOLDER>>>");
            m.reset(replaceItem);
        }
        replaceItem = replaceItem.replace("<<<org.dyndns.nuda.repserv.util.StringUtil.REPLACEMENT_HOLDER>>>", "");
        return replaceItem;
    }

    public static String indent(String content, int tabCount) {
        String content0 = content;
        Pattern p = StringUtilIndentConst.REPLACEMENT_PATTERN;
        Matcher m = p.matcher(content0);
        String replaceItem = "";
        while (m.find()) {
            replaceItem = m.replaceFirst("<REPLACEMENT>" + m.group(1));
            m.reset(replaceItem);
        }
        StringBuilder tab = new StringBuilder();
        int i = 0;
        while (i < tabCount) {
            tab.append("\t");
            ++i;
        }
        replaceItem = replaceItem.replace("<REPLACEMENT>", tab.toString());
        return replaceItem;
    }

    public static String indentWithNum(String content, int tabCount) {
        String content0 = content;
        Pattern p = StringUtilIndentConst.REPLACEMENT_NUM_PATTERN;
        Matcher m = p.matcher(content0);
        String replaceItem = "";
        int lineNum = 1;
        while (m.find()) {
            String lineNumStr = String.format("%03d", lineNum);
            StringBuilder b = new StringBuilder();
            b.append(lineNumStr).append(" :<REPLACEMENT>").append(m.group(1));
            replaceItem = m.replaceFirst(b.toString());
            m.reset(replaceItem);
            ++lineNum;
        }
        StringBuilder tab = new StringBuilder();
        int i = 0;
        while (i < tabCount) {
            tab.append("\t");
            ++i;
        }
        replaceItem = replaceItem.replace("<REPLACEMENT>", tab.toString());
        return replaceItem;
    }

    public static String format(String format, Object ... params) {
        String result = "";
        if (format == null) {
            return null;
        }
        if (params == null || params.length == 0) {
            result = format;
        } else {
            Matcher m = StringUtilFormatConst.PTN.matcher(format);
            int i = 0;
            while (m.find()) {
                if (i < params.length) {
                    if (params[i] != null) {
                        String replacement = params[i].toString();
                        replacement = AutoReplacementFilter.getInstance().replace(replacement);
                        String replaceResult = m.replaceFirst(replacement);
                        m.reset(replaceResult);
                        result = replaceResult;
                    } else {
                        String replaceResult = m.replaceFirst("<StringUtil.NOT_REPLACE>");
                        m.reset(replaceResult);
                        result = replaceResult;
                    }
                }
                ++i;
            }
            Matcher m2 = StringUtilFormatConst.PTN2.matcher(result);
            while (m2.find()) {
                String r = m2.replaceFirst("{}");
                m2.reset(r);
                result = r;
            }
        }
        result = AutoReplacementFilter.getInstance().repair(result);
        return result;
    }

    public static String format(String format, Map<String, Object> map) {
        String result = "";
        if (format == null) {
            return result;
        }
        if (map == null || map.size() == 0) {
            result = format;
        } else {
            Matcher m = StringUtilFormatConst.PTN3.matcher(format);
            while (m.find()) {
                String replaceResult;
                String g = m.group(1);
                Object val = map.get(g);
                if (map.containsKey(g)) {
                    String replacement = val.toString();
                    replacement = AutoReplacementFilter.getInstance().replace(replacement);
                    replaceResult = m.replaceFirst(replacement);
                    m.reset(replaceResult);
                    result = replaceResult;
                    continue;
                }
                if (g.isEmpty()) {
                    String replaceResult2 = m.replaceFirst("<StringUtil.NOT_REPLACE>");
                    m.reset(replaceResult2);
                    result = replaceResult2;
                    continue;
                }
                String group = m.group();
                group = group.replace("{", "<<<org.dyndns.nuda.repserv.util.StringUtil.BLACKET_LEFT>>>").replace("}", "<<<org.dyndns.nuda.repserv.util.StringUtil.BLACKET_RIGHT>>>");
                replaceResult = m.replaceFirst(group);
                m.reset(replaceResult);
                result = replaceResult;
            }
            Matcher m2 = StringUtilFormatConst.PTN2.matcher(result);
            while (m2.find()) {
                String r = m2.replaceFirst("{}");
                m2.reset(r);
                result = r;
            }
            result = result.replace("<<<org.dyndns.nuda.repserv.util.StringUtil.BLACKET_LEFT>>>", "{").replace("<<<org.dyndns.nuda.repserv.util.StringUtil.BLACKET_RIGHT>>>", "}");
        }
        result = AutoReplacementFilter.getInstance().repair(result);
        return result;
    }

    public static List<String> splitCSVRow(String csvRow) {
        LinkedList<String> result = new LinkedList<String>();
        Matcher m = StringUtilSplitCSVRowConst.splitCSVRowPTN.matcher(csvRow);
        while (m.find()) {
            String r = m.group();
            Matcher m2 = StringUtilSplitCSVRowConst.splitCSVRowPTN2.matcher(r);
            if (m2.find()) {
                result.add(m2.group(1));
                continue;
            }
            result.add(r.trim());
        }
        return result;
    }
}

