/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.sample3;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;

public class ActiveProxy<I> {
    private Class<?> getTargetClass() {
        Class<?> cls = this.getClass();
        if (cls.getGenericSuperclass() instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(cls.getGenericSuperclass());
            Type[] types = pt.getActualTypeArguments();
            if (types != null && types.length > 0) {
                ParameterizedType pt0 = (ParameterizedType)ParameterizedType.class.cast(types[0]);
                return (Class)pt0.getRawType();
            }
        } else {
            System.out.println(">" + cls.getGenericSuperclass().getClass().getCanonicalName());
        }
        return null;
    }

    public void test() {
        System.out.println(this.getTargetClass());
    }

    private static class InvocationHandlerImpl
    implements InvocationHandler {
        private Object target = null;

        private InvocationHandlerImpl() {
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public Object getTarget() {
            return this.target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            StringBuilder message = new StringBuilder();
            message.append("call");
            message.append(" Name[");
            message.append(method.getName());
            message.append(":");
            message.append("<");
            message.append(method.getReturnType().getCanonicalName());
            message.append(">");
            message.append("]");
            message.append(" Parameter[");
            if (args != null) {
                int count = 0;
                Object[] objectArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    Object arg = objectArray[n2];
                    if (count != args.length - 1) {
                        message.append(arg);
                        message.append(":");
                        message.append("<");
                        message.append(arg.getClass().getCanonicalName());
                        message.append(">");
                        message.append(", ");
                    } else {
                        message.append(arg);
                        message.append(":");
                        message.append("<");
                        message.append(arg.getClass().getCanonicalName());
                        message.append(">");
                    }
                    ++count;
                    ++n2;
                }
            }
            message.append("]");
            System.out.println(message.toString());
            if (this.target == null) {
                Class<?> returnType = method.getReturnType();
                if (Integer.TYPE.equals(returnType)) {
                    return 0;
                }
                if (Byte.TYPE.equals(returnType)) {
                    return (byte)0;
                }
                if (Short.TYPE.equals(returnType)) {
                    return (short)0;
                }
                if (Long.TYPE.equals(returnType)) {
                    return 0L;
                }
                if (Float.TYPE.equals(returnType)) {
                    return Float.valueOf(0.0f);
                }
                if (Double.TYPE.equals(returnType)) {
                    return 0.0;
                }
                if (Character.TYPE.equals(returnType)) {
                    return Character.valueOf("".toCharArray()[0]);
                }
                if (Boolean.TYPE.equals(returnType)) {
                    return false;
                }
                return null;
            }
            return method.invoke(this.target, args);
        }
    }

    public class ProxyFactory {
        public I create() {
            InvocationHandlerImpl ih = new InvocationHandlerImpl();
            ClassLoader l = Thread.currentThread().getContextClassLoader();
            Class targetClass = ActiveProxy.this.getTargetClass();
            Object obj = Proxy.newProxyInstance(l, new Class[]{targetClass}, (InvocationHandler)ih);
            return obj;
        }

        public I create(I target) {
            InvocationHandlerImpl ih = new InvocationHandlerImpl();
            ih.setTarget(target);
            ClassLoader l = Thread.currentThread().getContextClassLoader();
            Class targetClass = ActiveProxy.this.getTargetClass();
            Object obj = Proxy.newProxyInstance(l, new Class[]{targetClass}, (InvocationHandler)ih);
            return obj;
        }

        public I create(InvocationHandler ih) {
            ClassLoader l = Thread.currentThread().getContextClassLoader();
            Class targetClass = ActiveProxy.this.getTargetClass();
            Object obj = Proxy.newProxyInstance(l, new Class[]{targetClass}, ih);
            return obj;
        }
    }
}

